/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.writer;

import java.io.IOException;
import java.util.Locale;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.search.lucene.analysis.NgramAnalyzer;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitField;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PensieveWriter
implements ITmWriter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private IndexWriter indexWriter;

    public PensieveWriter(Directory indexDirectory, boolean createNewTmIndex) throws IOException {
        this.indexWriter = new IndexWriter(indexDirectory, (Analyzer)new NgramAnalyzer(Locale.ENGLISH, 4), createNewTmIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        catch (AlreadyClosedException ignored) {
        }
        finally {
            try {
                this.indexWriter.close();
            }
            catch (IOException ignored) {
                this.LOGGER.warn("Exception closing Pensieve IndexWriter.", ignored);
            }
        }
    }

    @Override
    public void commit() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public void indexTranslationUnit(TranslationUnit tu) {
        if (tu == null) {
            throw new NullPointerException("TextUnit can not be null");
        }
        Document doc = this.createDocument(tu);
        if (doc != null) {
            try {
                this.indexWriter.addDocument(doc);
            }
            catch (CorruptIndexException e) {
                throw new OkapiIOException("Error adding a translationUnit to the TM. Corrupted index.", e);
            }
            catch (IOException e) {
                throw new OkapiIOException("Error adding a translationUnit to the TM.", e);
            }
        }
    }

    @Override
    public void indexTranslationUnit(TranslationUnit tu, boolean overwrite) {
        if (tu == null) {
            throw new NullPointerException("TextUnit can not be null.");
        }
        try {
            if (overwrite) {
                TextFragment srcFrag = tu.getSource().getContent();
                if (srcFrag.hasCode()) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(new TermQuery(new Term(TranslationUnitField.SOURCE_EXACT.name(), srcFrag.getCodedText())), BooleanClause.Occur.MUST);
                    bq.add(new TermQuery(new Term(TranslationUnitField.SOURCE_CODES.name(), Code.codesToString(srcFrag.getCodes(), true))), BooleanClause.Occur.MUST);
                    this.indexWriter.deleteDocuments((Query)bq);
                } else {
                    this.indexWriter.deleteDocuments(new Term(TranslationUnitField.SOURCE_EXACT.name(), srcFrag.getCodedText()));
                }
            }
        }
        catch (CorruptIndexException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM. Corrupted index.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM.", e);
        }
        this.indexTranslationUnit(tu);
    }

    @Override
    public void delete(String id) {
        if (Util.isEmpty(id)) {
            throw new IllegalArgumentException("id is a required field for delete to happen");
        }
        try {
            this.indexWriter.deleteDocuments(new Term(MetadataType.ID.fieldName(), id));
        }
        catch (CorruptIndexException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM. Corrupted index.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM.", e);
        }
    }

    @Override
    public void update(TranslationUnit tu) {
        if (tu == null || tu.getMetadata().get((Object)MetadataType.ID) == null) {
            throw new IllegalArgumentException("tu must be set and at least have its ID set");
        }
        this.delete((String)tu.getMetadata().get((Object)MetadataType.ID));
        this.indexTranslationUnit(tu);
    }

    Field createField(TranslationUnitField field, TextFragment frag, Field.Store store, Field.Index index) {
        return new Field(field.name(), frag.toText(), store, index);
    }

    Field createField(TranslationUnitField field, TranslationUnitVariant tuv, Field.Store store, Field.Index index) {
        return new Field(field.name(), tuv.getLanguage().toString(), store, index);
    }

    void addMetadataToDocument(Document doc, Metadata metadata) {
        for (MetadataType type : metadata.keySet()) {
            doc.add(new Field(type.fieldName(), (String)metadata.get((Object)type), type.store(), type.indexType()));
        }
    }

    Document createDocument(TranslationUnit tu) {
        if (tu == null) {
            throw new NullPointerException("source content not set");
        }
        if (tu.isSourceEmpty()) {
            return null;
        }
        Document doc = new Document();
        doc.add(this.createField(TranslationUnitField.SOURCE_LANG, tu.getSource(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add(this.createRawCodedTextField(TranslationUnitField.SOURCE_EXACT, tu.getSource().getContent(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add(this.createIndexedTextField(TranslationUnitField.SOURCE, tu.getSource().getContent(), Field.Store.NO, Field.Index.ANALYZED_NO_NORMS));
        doc.add(this.createCodesField(TranslationUnitField.SOURCE_CODES, tu.getSource().getContent(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (!tu.isTargetEmpty()) {
            doc.add(this.createField(TranslationUnitField.TARGET_LANG, tu.getTarget(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add(this.createRawCodedTextField(TranslationUnitField.TARGET, tu.getTarget().getContent(), Field.Store.YES, Field.Index.NO));
            doc.add(this.createCodesField(TranslationUnitField.TARGET_CODES, tu.getTarget().getContent(), Field.Store.YES, Field.Index.NO));
        }
        this.addMetadataToDocument(doc, tu.getMetadata());
        return doc;
    }

    private Field createIndexedTextField(TranslationUnitField fieldType, TextFragment frag, Field.Store store, Field.Index index) {
        return new Field(fieldType.name(), frag.getText(), store, index, Field.TermVector.YES);
    }

    private Field createRawCodedTextField(TranslationUnitField fieldType, TextFragment frag, Field.Store store, Field.Index index) {
        return new Field(fieldType.name(), frag.getCodedText(), store, index);
    }

    private Field createCodesField(TranslationUnitField field, TextFragment frag, Field.Store store, Field.Index index) {
        return new Field(field.name(), Code.codesToString(frag.getCodes(), true), store, index);
    }
}

