/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import net.sf.okapi.common.BaseContext;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationEditor;
import net.sf.okapi.common.filters.IFilterConfigurationListEditor;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.filters.FilterConfigurationsDialog;
import net.sf.okapi.common.ui.genericeditor.GenericEditor;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FilterConfigurationEditor
implements IFilterConfigurationEditor,
IFilterConfigurationListEditor {
    public boolean editConfiguration(String configId, IFilterConfigurationMapper fcMapper) {
        return this.editConfiguration(configId, fcMapper, null, null, (IContext)new BaseContext());
    }

    public boolean editConfiguration(String configId, IFilterConfigurationMapper fcMapper, IFilter cachedFilter, Object parent, IContext context) {
        FilterConfiguration config = fcMapper.getConfiguration(configId);
        if (config == null) {
            throw new RuntimeException(String.format("Cannot find the configuration for '%s'.", configId));
        }
        IParameters params = fcMapper.getParameters(config, cachedFilter);
        if (params == null) {
            Shell shell = null;
            if (parent != null && parent instanceof Shell) {
                shell = (Shell)parent;
            }
            MessageBox dlg = new MessageBox(shell, 2);
            dlg.setMessage("This filter has no parameters to edit.");
            dlg.setText("Information");
            dlg.open();
            return false;
        }
        IParametersEditor editor = fcMapper.createConfigurationEditor(configId, cachedFilter);
        if (editor != null) {
            if (!editor.edit(params, !config.custom, context)) {
                return false;
            }
        } else {
            IEditorDescriptionProvider descProv = fcMapper.getDescriptionProvider(params.getClass().getName());
            if (descProv != null) {
                GenericEditor genEditor = new GenericEditor();
                if (!genEditor.edit(params, descProv, !config.custom, context)) {
                    return false;
                }
            } else {
                Shell shell = null;
                if (parent != null && parent instanceof Shell) {
                    shell = (Shell)parent;
                }
                InputDialog dlg = new InputDialog(shell, String.format("Filter Parameters (%s)", config.configId), "Parameters:", params.toString(), null, 0, 300, 800);
                dlg.setReadOnly(!config.custom);
                dlg.changeFontSize(2);
                String data = dlg.showDialog();
                if (data == null) {
                    return false;
                }
                if (!config.custom) {
                    return true;
                }
                data = data.replace("\r\n", "\n");
                params.fromString(data.replace("\r", "\n"));
            }
        }
        if (config.custom) {
            fcMapper.saveCustomParameters(config, params);
        }
        return true;
    }

    public void editConfigurations(IFilterConfigurationMapper fcMapper) {
        FilterConfigurationsDialog dlg = new FilterConfigurationsDialog(null, false, (FilterConfigurationMapper)fcMapper, null);
        dlg.showDialog(null);
    }

    public String editConfigurations(IFilterConfigurationMapper fcMapper, String configId) {
        FilterConfigurationsDialog dlg = new FilterConfigurationsDialog(null, true, (FilterConfigurationMapper)fcMapper, null);
        return dlg.showDialog(configId);
    }
}

