/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.ui.tokens;

import java.util.ArrayList;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.common.ui.abstracteditor.TableAdapter;
import net.sf.okapi.steps.tokenization.tokens.Parameters;
import net.sf.okapi.steps.tokenization.tokens.TokenItem;
import net.sf.okapi.steps.tokenization.ui.tokens.AddModifyTokenPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TokenSelectorPage
extends Composite
implements IDialogPage {
    protected Label listDescr;
    private Table table;
    private TableColumn colName;
    private TableColumn colDescr;
    protected Button add;
    protected Button modify;
    protected Button remove;
    private TableAdapter adapter;
    protected boolean modified;

    public TokenSelectorPage(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new GridLayout(2, false));
        this.listDescr = new Label(this, 0);
        this.listDescr.setLayoutData(new GridData(16384, 0x1000000, false, false, 2, 1));
        this.listDescr.setText("Select tokens in the table below using the check-boxes:");
        this.listDescr.setData("name", "listDescr");
        this.table = new Table(this, 67584);
        if (this.hasCheckBoxes()) {
            this.table.dispose();
            this.table = new Table(this, 67616);
        }
        this.table.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TokenSelectorPage.this.interop(e.widget);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                TokenSelectorPage.this.addModifyRow(TokenSelectorPage.this.table.getItem(new Point(e.x, e.y)));
            }
        });
        GridData gridData = new GridData(4, 4, true, true, 1, 4);
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        this.table.setLayoutData(gridData);
        this.table.setData("name", "table");
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.colName = new TableColumn(this.table, 0);
        this.colName.setData("name", "colName");
        this.colName.setWidth(150);
        this.colName.setText("Name");
        this.colDescr = new TableColumn(this.table, 16384);
        this.colDescr.setData("name", "colDescr");
        this.colDescr.setWidth(100);
        this.colDescr.setText("Description");
        this.add = new Button(this, 0);
        this.add.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TokenSelectorPage.this.addModifyRow(null);
            }
        });
        GridData gridData_1 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData_1.widthHint = 70;
        this.add.setLayoutData(gridData_1);
        this.add.setData("name", "add");
        this.add.setText("Add...");
        this.modify = new Button(this, 0);
        this.modify.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TokenSelectorPage.this.addModifyRow(TokenSelectorPage.this.table.getItem(TokenSelectorPage.this.table.getSelectionIndex()));
            }
        });
        this.modify.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.modify.setData("name", "modify");
        this.modify.setText("Modify...");
        this.remove = new Button(this, 0);
        this.remove.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TokenSelectorPage.this.adapter.removeSelected();
                TokenSelectorPage.this.modified = true;
                TokenSelectorPage.this.interop(e.widget);
            }
        });
        this.remove.setLayoutData(new GridData(4, 128, false, false, 1, 1));
        this.remove.setData("name", "remove");
        this.remove.setText("Remove");
        this.adapter = new TableAdapter(this.table);
        new Label(this, 0);
        this.adapter.setRelColumnWidths(new double[]{1.0, 3.0});
    }

    protected boolean hasCheckBoxes() {
        return false;
    }

    protected void addModifyRow(TableItem item) {
        if (item == null) {
            this.adapter.unselect();
            Object res = SWTUtil.inputQuery(AddModifyTokenPage.class, this.getShell(), "Add token type", new String[]{"", ""}, null);
            if (res != null) {
                this.modified = true;
                this.adapter.addModifyRow((String[])res, 1, 3);
            } else {
                this.adapter.restoreSelection();
            }
        } else {
            Object res = SWTUtil.inputQuery(AddModifyTokenPage.class, this.getShell(), "Modify token type", SWTUtil.getText(item), null);
            if (res != null) {
                this.modified = true;
                this.adapter.modifyRow(item, (String[])res);
            }
        }
        this.adapter.sort(1, false);
        this.interop(this.table);
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    public boolean canClose(boolean isOK) {
        return true;
    }

    @Override
    public void interop(Widget speaker) {
        if (SWTUtil.checkControl(this.modify)) {
            this.modify.setEnabled(this.table.getItemCount() > 0 && this.table.getSelectionIndex() != -1);
        }
        if (SWTUtil.checkControl(this.remove)) {
            this.remove.setEnabled(this.modify.getEnabled());
        }
    }

    @Override
    public boolean load(Object data) {
        Parameters params = new Parameters();
        if (params == null) {
            return false;
        }
        if (!params.loadItems()) {
            return false;
        }
        this.adapter.clear();
        for (TokenItem item : params.getItems()) {
            this.adapter.addRow(new String[]{item.getName(), item.getDescription()}, false);
        }
        this.adapter.sort(1, false);
        this.modified = false;
        if (data instanceof ArrayList) {
            ArrayList list = (ArrayList)data;
            for (String string : list) {
                TableItem item = this.adapter.findValue(string, 1);
                if (item == null) continue;
                item.setChecked(true);
            }
        }
        return true;
    }

    @Override
    public boolean save(Object data) {
        if (data instanceof ArrayList) {
            ArrayList list = (ArrayList)data;
            list.clear();
            for (TableItem item : this.table.getItems()) {
                if (!item.getChecked()) continue;
                list.add(item.getText(0));
            }
        }
        return true;
    }

    protected TableAdapter getAdapter() {
        return this.adapter;
    }
}

