/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Util;

public final class LocaleId
implements Comparable<Object> {
    public static final LocaleId EMPTY = new LocaleId("", false);
    public static final LocaleId ARABIC = new LocaleId("ar", false);
    public static final LocaleId CHINA_CHINESE = new LocaleId("zh-cn", false);
    public static final LocaleId TAIWAN_CHINESE = new LocaleId("zh-tw", false);
    public static final LocaleId ENGLISH = new LocaleId("en", false);
    public static final LocaleId FRENCH = new LocaleId("fr", false);
    public static final LocaleId GERMAN = new LocaleId("de", false);
    public static final LocaleId ITALIAN = new LocaleId("it", false);
    public static final LocaleId JAPANESE = new LocaleId("ja", false);
    public static final LocaleId KOREAN = new LocaleId("ko-kr", false);
    public static final LocaleId PORTUGUESE = new LocaleId("pt", false);
    public static final LocaleId RUSSIAN = new LocaleId("ru", false);
    public static final LocaleId SPANISH = new LocaleId("es", false);
    private static final Pattern BIDILOCALES = Pattern.compile("(ar|he|fa|ur|dv|syr|syc)(-.*)?", 2);
    private String locId;
    private static final int ID_LANGUAGE = 5;
    private static final int ID_REGION = 10;
    private static final int ID_USER = 18;
    private static final int POSIX_LANGUAGE = 1;
    private static final int POSIX_REGION = 3;
    private static final int POSIX_VARIANT = 7;
    private static final String[][] JAVALOCMAP = new String[][]{{"ja_JP_JP", "ja-jp-x-calja"}, {"no_NO_NY", "nn-no"}, {"th_TH_TH", "th-th-x-numth"}, {"th_TH_TH_#u-nu-thai", "th-th-x-numth"}};
    private static final Pattern BCP_PATTERN = Pattern.compile("(\\A[xX]([\\x2d]\\p{Alnum}{1,8})*\\z)|(((\\A\\p{Alpha}{2,8}(?=\\x2d|\\z)){1}(([\\x2d]\\p{Alpha}{3})(?=\\x2d|\\z)){0,3}([\\x2d]\\p{Alpha}{4}(?=\\x2d|\\z))?([\\x2d](\\p{Alpha}{2}|\\d{3})(?=\\x2d|\\z))?([\\x2d](\\d\\p{Alnum}{3}|\\p{Alnum}{5,8})(?=\\x2d|\\z))*)(([\\x2d]([a-wyzA-WYZ](?=\\x2d))([\\x2d](\\p{Alnum}{2,8})+)*))*([\\x2d][xX]([\\x2d]\\p{Alnum}{1,8})*)?)\\z");
    private static final Pattern POSIX_PATTERN = Pattern.compile("\\A(\\p{Alpha}{2,3})(_(\\p{Alpha}*?))?(\\.([\\p{Alnum}_-]*?))?(@([\\p{Alnum}_-]*?))?\\z");
    private static final Pattern ID_PATTERN = Pattern.compile("(\\A[xX]([\\x2d]\\p{Alnum}{1,8})*\\z)|(((\\A\\p{Alpha}{2,8}(?=\\x2d|\\z)){1}(([\\x2d]\\p{Alpha}{3})(?=\\x2d|\\z)){0,3}([\\x2d]\\p{Alpha}{4}(?=\\x2d|\\z))?([\\x2d](\\p{Alpha}{2}|\\d{3})(?=\\x2d|\\z))?([\\x2d](\\d\\p{Alnum}{3}|\\p{Alnum}{5,8})(?=\\x2d|\\z))*)(([\\x2d]([a-wyzA-WYZ](?=\\x2d))([\\x2d](\\p{Alnum}{2,8})+)*))*([\\x2d][xX]([\\x2d]\\p{Alnum}{1,8})*)?)\\z");
    private static final Pattern ALLOWED_CHARS = Pattern.compile("[\\-a-zA-Z0-9]+");

    public static String replaceVariables(String input, LocaleId srcLoc, LocaleId trgLoc) {
        return LocaleId.replaceVariables(input, srcLoc == null ? "" : srcLoc.toString(), trgLoc == null ? "" : trgLoc.toString());
    }

    public static String replaceVariables(String input, String srcLoc, String trgLoc) {
        String[] res;
        if (input.indexOf("${") == -1) {
            return input;
        }
        input = input.replace("${Src", "${src");
        input = input.replace("${Trg", "${trg");
        if (srcLoc == null) {
            srcLoc = "";
        }
        if (trgLoc == null) {
            trgLoc = "";
        }
        input = input.replace("${srcLangU}", srcLoc.toUpperCase());
        input = input.replace("${srcLangL}", srcLoc.toLowerCase());
        input = input.replace("${srcLang}", srcLoc);
        input = input.replace("${trgLangU}", trgLoc.toUpperCase());
        input = input.replace("${trgLangL}", trgLoc.toLowerCase());
        if ((input = input.replace("${trgLang}", trgLoc)).indexOf("${srcLoc") != -1) {
            res = LocaleId.splitLanguageCode(srcLoc);
            input = input.replace("${srcLoc}", String.format("%s_%s", res[0].toLowerCase(), res[1].toUpperCase()));
            input = input.replace("${srcLocLang}", res[0].toLowerCase());
            input = input.replace("${srcLocReg}", res[1].toUpperCase());
        }
        if (input.indexOf("${trgLoc") != -1) {
            res = LocaleId.splitLanguageCode(trgLoc);
            input = input.replace("${trgLoc}", String.format("%s_%s", res[0].toLowerCase(), res[1].toUpperCase()));
            input = input.replace("${trgLocLang}", res[0].toLowerCase());
            input = input.replace("${trgLocReg}", res[1].toUpperCase());
        }
        return input;
    }

    public LocaleId(String locId, boolean normalize) {
        this.locId = normalize ? this.normalize(locId) : locId;
    }

    public LocaleId(String language) {
        this(language, null);
    }

    public LocaleId(String language, String region) {
        if (Util.isEmpty(language)) {
            throw new IllegalArgumentException("The language cannot be null or empty.");
        }
        StringBuilder tmp = new StringBuilder(language);
        if (!Util.isEmpty(region)) {
            tmp.append("-");
            tmp.append(region);
        }
        this.locId = this.normalize(tmp.toString());
    }

    public LocaleId(String language, String region, String userPart) {
        if (Util.isEmpty(language)) {
            throw new IllegalArgumentException("The language cannot be null or empty.");
        }
        StringBuilder tmp = new StringBuilder(language);
        if (!Util.isEmpty(region)) {
            tmp.append("-");
            tmp.append(region);
            if (!Util.isEmpty(userPart)) {
                tmp.append("-x-");
                tmp.append(userPart);
            }
        }
        this.locId = this.normalize(tmp.toString());
    }

    public LocaleId(Locale loc) {
        if (loc == null) {
            throw new IllegalArgumentException("The locale cannot be null.");
        }
        String tmp = loc.toString();
        for (int i = 0; i < JAVALOCMAP.length; ++i) {
            if (!JAVALOCMAP[i][0].equals(tmp)) continue;
            tmp = JAVALOCMAP[i][1];
            break;
        }
        this.locId = this.normalize(tmp);
    }

    public String toString() {
        return this.locId;
    }

    public LocaleId clone() {
        return this;
    }

    public int hashCode() {
        return this.locId.hashCode();
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (this == arg) {
            return true;
        }
        if (arg instanceof LocaleId) {
            return this.locId.equals(((LocaleId)arg).locId);
        }
        if (arg instanceof String) {
            return this.locId.equals(this.normalize((String)arg));
        }
        return false;
    }

    @Override
    public int compareTo(Object arg) {
        if (arg == null) {
            return 1;
        }
        if (arg instanceof LocaleId) {
            return this.locId.compareTo(((LocaleId)arg).locId);
        }
        if (arg instanceof String) {
            return this.locId.compareTo(this.normalize((String)arg));
        }
        return 1;
    }

    private String normalize(String locId) {
        if (Util.isEmpty(locId)) {
            throw new IllegalArgumentException("The locale identifier cannot be null or empty.");
        }
        String tmp = locId.replace('_', '-').toLowerCase();
        int n = tmp.indexOf(45);
        if (n == 1 ? tmp.charAt(0) != 'x' : n != 2 && n != 3 && n != -1 || tmp.length() < 2) {
            throw new IllegalArgumentException(String.format("The locale identifier '%s' is invalid.", tmp));
        }
        if (!ALLOWED_CHARS.matcher(tmp).matches()) {
            throw new IllegalArgumentException(String.format("The locale identifier '%s' contains at least one invalid character.", tmp));
        }
        return tmp;
    }

    public static LocaleId fromString(String locId) {
        if ("".equals(locId)) {
            return EMPTY;
        }
        return new LocaleId(locId, true);
    }

    public static LocaleId fromPOSIXLocale(String locId) {
        if (Util.isEmpty(locId)) {
            throw new IllegalArgumentException("The locale identifier cannot be null or empty.");
        }
        Matcher m = POSIX_PATTERN.matcher(locId);
        if (m.find()) {
            StringBuilder tag = new StringBuilder();
            String tmp = m.group(1);
            if (!Util.isEmpty(tmp)) {
                tag.append(tmp);
            }
            if (!Util.isEmpty(tmp = m.group(3))) {
                tag.append('-');
                tag.append(tmp);
            }
            if (!Util.isEmpty(tmp = m.group(7))) {
                tag.append("-x-");
                tag.append(tmp);
            }
            return new LocaleId(tag.toString(), true);
        }
        throw new IllegalArgumentException(String.format("The POSIX locale '%s' is invalid.", locId));
    }

    public String toPOSIXLocaleId() {
        String tmp = this.getLanguage();
        if (this.getRegion() != null) {
            tmp = tmp + "_" + this.getRegion().toUpperCase();
        }
        return tmp;
    }

    public static LocaleId fromBCP47(String langtag) {
        if (Util.isEmpty(langtag)) {
            throw new IllegalArgumentException("The language tag cannot be null or empty.");
        }
        Matcher m = BCP_PATTERN.matcher(langtag);
        if (m.find()) {
            return new LocaleId(langtag.toLowerCase(), false);
        }
        throw new IllegalArgumentException(String.format("The BCP-47 language tag '%s' is invalid.", langtag));
    }

    public String toBCP47() {
        return this.locId;
    }

    public Locale toJavaLocale() {
        String[] parts = null;
        for (int i = 0; i < JAVALOCMAP.length; ++i) {
            if (!JAVALOCMAP[i][1].equals(this.locId)) continue;
            parts = JAVALOCMAP[i][0].split("_");
            break;
        }
        if (parts == null) {
            parts = LocaleId.splitParts(this.locId);
        }
        if (!Util.isEmpty((String)parts[0])) {
            if (!Util.isEmpty(parts[1])) {
                if (!Util.isEmpty(parts[2])) {
                    return new Locale(parts[0], parts[1].toUpperCase(), parts[2].toUpperCase());
                }
                return new Locale(parts[0], parts[1].toUpperCase());
            }
            return new Locale(parts[0]);
        }
        return Locale.getDefault();
    }

    public String getLanguage() {
        int n = this.locId.indexOf(45);
        if (n > 0) {
            return this.locId.substring(0, n);
        }
        return this.locId;
    }

    public String getRegion() {
        try {
            Matcher m = ID_PATTERN.matcher(this.locId);
            m.find();
            return m.group(10);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getUserPart() {
        String tmp = null;
        try {
            Matcher m = ID_PATTERN.matcher(this.locId);
            m.find();
            tmp = m.group(18);
        }
        catch (Throwable e) {
            return null;
        }
        if (tmp == null) {
            return null;
        }
        int n = tmp.indexOf("-x-");
        return n >= 0 ? tmp.substring(n + 3) : null;
    }

    public boolean sameLanguageAs(LocaleId other) {
        if (other == null) {
            return false;
        }
        return this.sameLanguageAs(other.toString(), false);
    }

    public boolean sameLanguageAs(String langCode) {
        return this.sameLanguageAs(langCode, true);
    }

    private boolean sameLanguageAs(String otherLocId, boolean normalize) {
        if (otherLocId == null) {
            return false;
        }
        if (normalize) {
            otherLocId = this.normalize(otherLocId);
        }
        int n1 = this.locId.indexOf(45);
        int n2 = otherLocId.indexOf(45);
        if (n1 == -1) {
            n1 = this.locId.length();
        }
        if (n2 == -1) {
            n2 = otherLocId.length();
        }
        if (n1 != n2) {
            return false;
        }
        for (int i = 0; i < n1; ++i) {
            if (this.locId.charAt(i) == otherLocId.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean sameRegionAs(LocaleId other) {
        if (other == null) {
            return false;
        }
        String region1 = this.getRegion();
        String region2 = other.getRegion();
        if (region1 == null && region2 == null) {
            return true;
        }
        if (region1 == null) {
            return false;
        }
        return region1.equals(region2);
    }

    public boolean sameRegionAs(String langCode) {
        return this.sameRegionAs(new LocaleId(langCode, true));
    }

    public boolean sameUserPartAs(LocaleId other) {
        if (other == null) {
            return false;
        }
        String userPart1 = this.getUserPart();
        String userPart2 = other.getUserPart();
        if (userPart1 == null && userPart2 == null) {
            return true;
        }
        if (userPart1 == null) {
            return false;
        }
        return userPart1.equals(userPart2);
    }

    public boolean sameUserPartAs(String langCode) {
        return this.sameUserPartAs(new LocaleId(langCode, true));
    }

    public static LocaleId[] getAvailableLocales() {
        Locale[] jlocales = Locale.getAvailableLocales();
        LocaleId[] locIds = new LocaleId[jlocales.length];
        for (int i = 0; i < jlocales.length; ++i) {
            locIds[i] = new LocaleId(jlocales[i]);
        }
        return locIds;
    }

    private static String[] splitParts(String locId) {
        String[] parts = new String[3];
        Matcher m = ID_PATTERN.matcher(locId);
        if (m.find()) {
            parts[0] = m.group(5);
            parts[1] = m.group(10);
            parts[2] = m.group(18);
        }
        return parts;
    }

    public static String[] splitLanguageCode(String language) {
        String[] parts = new String[]{"", ""};
        if (language == null || language.length() == 0) {
            return parts;
        }
        int n = (language = language.replace('_', '-')).indexOf(45);
        if (n > -1) {
            parts[0] = language.substring(0, n);
            parts[1] = language.substring(n + 1);
        } else {
            parts[0] = language;
        }
        return parts;
    }

    public static boolean isBidirectional(LocaleId locId) {
        return BIDILOCALES.matcher(locId.toBCP47()).matches();
    }

    public static List<LocaleId> convertToLocaleIds(List<String> languageCodes) {
        ArrayList<LocaleId> locales = new ArrayList<LocaleId>();
        for (String languageCode : languageCodes) {
            locales.add(new LocaleId(languageCode, true));
        }
        return locales;
    }
}

