/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import net.sf.okapi.common.Util;

public class XLIFFTool {
    private String id;
    private String name;
    private String version;
    private String company;
    private StringBuilder skel = new StringBuilder();

    public XLIFFTool(String toolId, String toolName) {
        this.id = toolId;
        this.name = toolName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String toolVersion) {
        this.version = toolVersion;
    }

    public void setCompany(String toolCompany) {
        this.company = toolCompany;
    }

    public void addSkeletonContent(String text) {
        this.skel.append(text);
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<tool");
        sb.append(" tool-id=\"").append(Util.escapeToXML(this.id, 1, false, null)).append("\"");
        sb.append(" tool-name=\"").append(Util.escapeToXML(this.name, 1, false, null)).append("\"");
        if (this.version != null) {
            sb.append(" tool-version=\"").append(Util.escapeToXML(this.version, 1, false, null)).append("\"");
        }
        if (this.company != null) {
            sb.append(" tool-company=\"").append(Util.escapeToXML(this.company, 1, false, null)).append("\"");
        }
        sb.append(">");
        sb.append((CharSequence)this.skel);
        sb.append("</tool>");
        return sb.toString();
    }
}

