/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ReversedIterator;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.ILayerProvider;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.Referent;
import net.sf.okapi.common.skeleton.StorageList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSkeletonWriter
implements ISkeletonWriter {
    public static final String ALLOWEMPTYOUTPUTTARGET = "allowEmptyOutputTarget";
    protected LocaleId inputLoc;
    protected LocaleId outputLoc;
    protected ILayerProvider layer;
    protected EncoderManager encoderManager;
    protected Stack<StorageList> storageStack;
    protected boolean isMultilingual;
    protected boolean allowEmptyOutputTarget = false;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LinkedHashMap<String, Referent> referents;
    protected String outputEncoding;
    private int referentCopies = 1;
    private ISkeletonWriter sfWriter;

    protected IReferenceable getReference(String id) {
        if (this.referents == null) {
            return null;
        }
        Referent ref = this.referents.get(id);
        if (ref == null) {
            return null;
        }
        if (--ref.count == 0) {
            this.referents.remove(id);
        }
        return ref.ref;
    }

    @Override
    public void close() {
        this.sfWriter = null;
        if (this.referents != null) {
            this.referents.clear();
            this.referents = null;
        }
        if (this.storageStack != null) {
            this.storageStack.clear();
            this.storageStack = null;
        }
    }

    public void setReferentCopies(int referentCopies) {
        this.referentCopies = referentCopies < 1 ? 1 : referentCopies;
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        if (this.sfWriter != null) {
            return this.sfWriter.processStartDocument(outputLocale, outputEncoding, layer, encoderManager, resource);
        }
        this.referents = new LinkedHashMap();
        this.storageStack = new Stack();
        this.inputLoc = resource.getLocale();
        this.outputLoc = outputLocale;
        this.encoderManager = encoderManager;
        this.outputEncoding = outputEncoding;
        this.layer = layer;
        this.isMultilingual = resource.isMultilingual();
        IParameters prm = resource.getFilterParameters();
        if (this.encoderManager != null) {
            this.encoderManager.setDefaultOptions(prm, outputEncoding, resource.getLineBreak());
            this.encoderManager.updateEncoder(resource.getMimeType());
        }
        this.allowEmptyOutputTarget = false;
        if (prm != null && this.isMultilingual) {
            this.allowEmptyOutputTarget = prm.getBoolean(ALLOWEMPTYOUTPUTTARGET);
        }
        return this.getString((GenericSkeleton)resource.getSkeleton(), EncoderContext.SKELETON);
    }

    @Override
    public String processEndDocument(Ending resource) {
        if (this.sfWriter != null) {
            return this.sfWriter.processEndDocument(resource);
        }
        return this.getString((GenericSkeleton)resource.getSkeleton(), EncoderContext.SKELETON);
    }

    @Override
    public String processStartSubDocument(StartSubDocument resource) {
        if (this.sfWriter != null) {
            return this.sfWriter.processStartSubDocument(resource);
        }
        if (this.storageStack.size() > 0) {
            this.storageStack.peek().add(resource);
            return "";
        }
        return this.getString((GenericSkeleton)resource.getSkeleton(), EncoderContext.SKELETON);
    }

    @Override
    public String processEndSubDocument(Ending resource) {
        if (this.sfWriter != null) {
            return this.sfWriter.processEndSubDocument(resource);
        }
        if (this.storageStack.size() > 0) {
            this.storageStack.peek().add(resource);
            return "";
        }
        return this.getString((GenericSkeleton)resource.getSkeleton(), EncoderContext.SKELETON);
    }

    @Override
    public String processStartGroup(StartGroup resource) {
        if (resource.isReferent()) {
            StorageList sl = new StorageList(resource);
            this.referents.put(sl.getId(), new Referent(sl, this.referentCopies));
            this.storageStack.push(sl);
            return "";
        }
        if (this.storageStack.size() > 0) {
            StorageList sl = new StorageList(resource);
            this.storageStack.peek().add(sl);
            this.storageStack.push(sl);
            return "";
        }
        if (this.sfWriter != null) {
            return this.sfWriter.processStartGroup(resource);
        }
        return this.getString((GenericSkeleton)resource.getSkeleton(), EncoderContext.SKELETON);
    }

    @Override
    public String processEndGroup(Ending resource) {
        if (this.storageStack.size() > 0) {
            this.storageStack.peek().add(resource);
            this.storageStack.pop();
            return "";
        }
        if (this.sfWriter != null) {
            return this.sfWriter.processEndGroup(resource);
        }
        return this.getString((GenericSkeleton)resource.getSkeleton(), EncoderContext.SKELETON);
    }

    @Override
    public String processStartSubfilter(StartSubfilter resource) {
        this.sfWriter = resource.createSkeletonWriter(resource, this.outputLoc, this.outputEncoding);
        return this.processStartGroup(resource);
    }

    @Override
    public String processEndSubfilter(EndSubfilter resource) {
        String res = this.processEndGroup(resource);
        this.sfWriter = null;
        return res;
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        if (this.sfWriter != null) {
            return this.sfWriter.processTextUnit(resource);
        }
        if (resource.isReferent()) {
            this.referents.put(resource.getId(), new Referent(resource, this.referentCopies));
            return "";
        }
        if (this.storageStack.size() > 0) {
            this.storageStack.peek().add(resource);
            return "";
        }
        return this.getString(resource, this.outputLoc, EncoderContext.SKELETON);
    }

    @Override
    public String processDocumentPart(DocumentPart resource) {
        if (this.sfWriter != null) {
            return this.sfWriter.processDocumentPart(resource);
        }
        if (resource.isReferent()) {
            this.referents.put(resource.getId(), new Referent(resource, this.referentCopies));
            return "";
        }
        if (this.storageStack.size() > 0) {
            this.storageStack.peek().add(resource);
            return "";
        }
        return this.getString((GenericSkeleton)resource.getSkeleton(), EncoderContext.SKELETON);
    }

    protected String getString(ISkeleton skeleton, EncoderContext context) {
        if (skeleton == null) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        for (GenericSkeletonPart part : ((GenericSkeleton)skeleton).getParts()) {
            tmp.append(this.getString(part, context));
        }
        return tmp.toString();
    }

    protected String getString(GenericSkeletonPart part, EncoderContext context) {
        if (!part.data.toString().contains("[#$")) {
            if (this.layer == null) {
                return part.data.toString();
            }
            return this.layer.encode(part.data.toString(), context);
        }
        StringBuilder sb = new StringBuilder(part.data);
        while (sb.indexOf("[#$") != -1) {
            Object[] marker = TextFragment.getRefMarker(sb);
            if (marker == null) {
                return "-ERR:INVALID-REF-MARKER-";
            }
            String propName = (String)marker[3];
            if (propName != null) {
                if ("$segment$".equals(propName)) {
                    String segId = (String)marker[0];
                    ITextUnit tu = (ITextUnit)part.getParent();
                    LocaleId locId = part.getLocale();
                    TextContainer tc = null;
                    tc = locId == null ? tu.getSource() : tu.getTarget(locId);
                    Segment seg = null;
                    if (tc != null) {
                        seg = tc.getSegments().get(segId);
                    }
                    if (seg == null) {
                        this.logger.warn("Segment reference '{}' not found.", (Object)((String)marker[0]));
                        return "-ERR:INVALID-SEGMENT-REF-";
                    }
                    return this.getContent(seg.getContent(), locId, context);
                }
                return this.getString((INameable)part.parent, propName, part.locId, context);
            }
            LocaleId locToUse = part.locId == null ? this.outputLoc : part.locId;
            EncoderContext contextToUse = context;
            if (this.isMultilingual) {
                locToUse = part.locId;
                EncoderContext encoderContext = contextToUse = locToUse == null ? EncoderContext.TEXT : context;
            }
            if (part.parent != null) {
                if (part.parent instanceof ITextUnit) {
                    return this.getContent((ITextUnit)part.parent, locToUse, contextToUse);
                }
                throw new RuntimeException("The self-reference to this skeleton part must be a text-unit.");
            }
            IReferenceable ref = this.getReference((String)marker[0]);
            String refData = null;
            int start = (Integer)marker[1];
            int end = (Integer)marker[2];
            if (ref == null) {
                this.logger.warn("Reference '{}' not found.", (Object)((String)marker[0]));
                refData = "-ERR:REF-NOT-FOUND-";
            } else {
                refData = ref instanceof ITextUnit ? this.getString((ITextUnit)ref, locToUse, contextToUse) : (ref instanceof GenericSkeletonPart ? this.getString((GenericSkeletonPart)((Object)ref), contextToUse) : (ref instanceof StorageList ? this.getString((StorageList)ref, locToUse, contextToUse) : this.getString((GenericSkeleton)((IResource)((Object)ref)).getSkeleton(), context)));
            }
            sb.replace(start, end, refData);
        }
        return sb.toString();
    }

    protected String getString(INameable ref, String propName, LocaleId locToUse, EncoderContext context) {
        if (ref == null) {
            this.logger.warn("Null reference for '{}'.", (Object)propName);
            return "-ERR:NULL-REF-";
        }
        if (propName != null) {
            return this.getPropertyValue(ref, propName, locToUse, context);
        }
        if (ref instanceof ITextUnit) {
            return this.getString((ITextUnit)ref, locToUse, context);
        }
        if (ref instanceof DocumentPart) {
            return this.getString((GenericSkeleton)ref.getSkeleton(), context);
        }
        if (ref instanceof StorageList) {
            return this.getString((StorageList)ref, locToUse, context);
        }
        this.logger.warn("Invalid reference type for '{}'.", (Object)propName);
        return "-ERR:INVALID-REFTYPE-";
    }

    protected String getString(ITextUnit tu, LocaleId locToUse, EncoderContext context) {
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        if (skel == null) {
            return this.getContent(tu, locToUse, context);
        }
        StringBuilder tmp = new StringBuilder();
        for (GenericSkeletonPart part : skel.getParts()) {
            tmp.append(this.getString(part, context));
        }
        return tmp.toString();
    }

    protected String getContent(ITextUnit tu, LocaleId locToUse, EncoderContext context) {
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(tu.getMimeType());
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = null;
        if (locToUse != null) {
            trgCont = tu.getTarget(locToUse);
            if (trgCont == null || trgCont.isEmpty()) {
                if (this.allowEmptyOutputTarget && this.layer == null) {
                    if (trgCont == null) {
                        trgCont = tu.createTarget(locToUse, false, 0);
                    }
                } else {
                    trgCont = srcCont;
                }
            }
        } else {
            trgCont = srcCont;
        }
        if (!tu.isTranslatable()) {
            context = EncoderContext.TEXT;
        }
        if (srcCont.hasBeenSegmented() || !srcCont.contentIsOneSegment() || trgCont.getAnnotation(AltTranslationsAnnotation.class) != null) {
            return this.getSegmentedText(srcCont, trgCont, locToUse, context, tu.isReferent());
        }
        TextFragment tf = trgCont.getFirstContent();
        if (this.layer == null) {
            return this.getContent(tf, locToUse, context);
        }
        switch (context) {
            case SKELETON: {
                return this.layer.endCode() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.layer.startCode();
            }
            case INLINE: {
                return this.layer.endInline() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.layer.startInline();
            }
        }
        return this.getContent(tf, locToUse, context);
    }

    private String getSegmentedText(TextContainer srcCont, TextContainer trgCont, LocaleId locToUse, EncoderContext context, boolean isReferent) {
        StringBuilder tmp = new StringBuilder();
        AltTranslationsAnnotation atAnn = null;
        for (TextPart part : trgCont) {
            if (part.isSegment()) {
                Segment srcSeg;
                Segment trgSeg = (Segment)part;
                TextFragment trgFrag = trgSeg.text;
                int lev = 0;
                AltTranslation at = null;
                atAnn = trgSeg.getAnnotation(AltTranslationsAnnotation.class);
                if (atAnn != null && (at = atAnn.getFirst()) != null) {
                    lev = at.getCombinedScore();
                }
                if ((srcSeg = srcCont.getSegments().get(trgSeg.id)) == null) {
                    this.logger.warn("No source segment found for target segment id='{}':\n\"{}\".", (Object)trgSeg.id, (Object)trgFrag.toText());
                } else if (trgFrag.isEmpty() && !srcSeg.text.isEmpty()) {
                    trgFrag = srcSeg.text;
                    lev = 0;
                }
                if (this.layer == null) {
                    tmp.append(this.getContent(trgFrag, locToUse, context));
                    continue;
                }
                switch (context) {
                    case SKELETON: {
                        tmp.append(this.layer.endCode() + this.layer.startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.layer.midSegment(lev) + this.getContent(trgFrag, locToUse, EncoderContext.TEXT) + this.layer.endSegment() + this.layer.startCode());
                        break;
                    }
                    case INLINE: {
                        tmp.append(this.layer.endInline() + this.layer.startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.layer.midSegment(lev) + this.getContent(trgFrag, locToUse, EncoderContext.TEXT) + this.layer.endSegment() + this.layer.startInline());
                        break;
                    }
                    default: {
                        tmp.append(this.layer.startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.layer.midSegment(lev) + this.getContent(trgFrag, locToUse, EncoderContext.TEXT) + this.layer.endSegment());
                    }
                }
                continue;
            }
            tmp.append(this.getContent(part.text, locToUse, context));
        }
        return tmp.toString();
    }

    public String getContent(TextFragment tf, LocaleId locToUse, EncoderContext context) {
        if (!tf.hasCode()) {
            if (this.encoderManager == null) {
                if (this.layer == null) {
                    return tf.toText();
                }
                return this.layer.encode(tf.toText(), context);
            }
            if (this.layer == null) {
                return this.encoderManager.encode(tf.toText(), context);
            }
            return this.layer.encode(this.encoderManager.encode(tf.toText(), context), context);
        }
        List<Code> codes = tf.getCodes();
        StringBuilder tmp = new StringBuilder();
        String text = tf.getCodedText();
        boolean inlineCdata = false;
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\ue101': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (code.getType().equals("cdata")) {
                        inlineCdata = true;
                    }
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                case '\ue102': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (code.getType().equals("cdata")) {
                        inlineCdata = false;
                    }
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                case '\ue103': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                default: {
                    if (inlineCdata) {
                        tmp.append(ch);
                        continue block5;
                    }
                    if (Character.isHighSurrogate(ch)) {
                        int cp = text.codePointAt(i);
                        ++i;
                        if (this.encoderManager == null) {
                            if (this.layer == null) {
                                tmp.append(new String(Character.toChars(cp)));
                                continue block5;
                            }
                            tmp.append(this.layer.encode(cp, context));
                            continue block5;
                        }
                        if (this.layer == null) {
                            tmp.append(this.encoderManager.encode(cp, context));
                            continue block5;
                        }
                        tmp.append(this.layer.encode(this.encoderManager.encode(cp, context), context));
                        continue block5;
                    }
                    if (this.encoderManager == null) {
                        if (this.layer == null) {
                            tmp.append(ch);
                            continue block5;
                        }
                        tmp.append(this.layer.encode(ch, context));
                        continue block5;
                    }
                    if (this.layer == null) {
                        tmp.append(this.encoderManager.encode(ch, context));
                        continue block5;
                    }
                    tmp.append(this.layer.encode(this.encoderManager.encode(ch, context), context));
                }
            }
        }
        return tmp.toString();
    }

    protected String expandCodeContent(Code code, LocaleId locToUse, EncoderContext context) {
        String codeTmp = code.getOuterData();
        if (this.layer != null) {
            codeTmp = this.layer.startInline() + this.layer.encode(codeTmp, EncoderContext.INLINE) + this.layer.endInline();
        }
        if (!code.hasReference()) {
            return codeTmp;
        }
        StringBuilder tmp = new StringBuilder(codeTmp);
        Object[] marker = null;
        while ((marker = TextFragment.getRefMarker(tmp)) != null) {
            int start = (Integer)marker[1];
            int end = (Integer)marker[2];
            String propName = (String)marker[3];
            IReferenceable ref = this.getReference((String)marker[0]);
            if (ref == null) {
                this.logger.warn("Reference '{}' not found.", (Object)((String)marker[0]));
                tmp.replace(start, end, "-ERR:REF-NOT-FOUND-");
                continue;
            }
            if (propName != null) {
                tmp.replace(start, end, this.getPropertyValue((INameable)((Object)ref), propName, locToUse, EncoderContext.INLINE));
                continue;
            }
            if (ref instanceof ITextUnit) {
                tmp.replace(start, end, this.getString((ITextUnit)ref, locToUse, EncoderContext.INLINE));
                continue;
            }
            if (ref instanceof GenericSkeletonPart) {
                tmp.replace(start, end, this.getString((GenericSkeletonPart)((Object)ref), EncoderContext.INLINE));
                continue;
            }
            if (ref instanceof StorageList) {
                tmp.replace(start, end, this.getString((StorageList)ref, locToUse, EncoderContext.INLINE));
                continue;
            }
            tmp.replace(start, end, this.getString((GenericSkeleton)((IResource)((Object)ref)).getSkeleton(), EncoderContext.INLINE));
        }
        return tmp.toString();
    }

    protected String getString(StorageList list, LocaleId locToUse, EncoderContext context) {
        StringBuilder tmp = new StringBuilder();
        if (list.getStartGroup() instanceof StartSubfilter) {
            tmp.append(this.getString((GenericSkeleton)list.getSkeleton(), context));
            StartSubfilter ssf = (StartSubfilter)list.getStartGroup();
            tmp.append(ssf.getSkeletonWriter().getEncodedOutput());
            for (IResource res : new ReversedIterator<IResource>(list)) {
                if (!(res instanceof Ending)) continue;
                tmp.append(this.getString((GenericSkeleton)res.getSkeleton(), context));
                break;
            }
        } else {
            tmp.append(this.getString((GenericSkeleton)list.getSkeleton(), context));
            for (IResource res : list) {
                if (res instanceof ITextUnit) {
                    tmp.append(this.getString((ITextUnit)res, locToUse, context));
                    continue;
                }
                if (res instanceof StorageList) {
                    tmp.append(this.getString((StorageList)res, locToUse, context));
                    continue;
                }
                if (res instanceof DocumentPart) {
                    tmp.append(this.getString((GenericSkeleton)res.getSkeleton(), context));
                    continue;
                }
                if (!(res instanceof Ending)) continue;
                tmp.append(this.getString((GenericSkeleton)res.getSkeleton(), context));
            }
        }
        return tmp.toString();
    }

    protected String getPropertyValue(INameable resource, String name, LocaleId locToUse, EncoderContext context) {
        Property prop;
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(resource.getMimeType());
        }
        if ((prop = locToUse == null ? resource.getSourceProperty(name) : (locToUse.equals(LocaleId.EMPTY) ? resource.getProperty(name) : (resource.hasTargetProperty(locToUse, name) ? resource.getTargetProperty(locToUse, name) : resource.getSourceProperty(name)))) == null) {
            this.logger.warn("Property '{}' not found.", (Object)name);
            return "-ERR:PROP-NOT-FOUND-";
        }
        String value = prop.getValue();
        if (value == null) {
            this.logger.warn("Property value for '{}' is null.", (Object)name);
            return "-ERR:PROP-VALUE-NULL-";
        }
        if ("language".equals(name)) {
            LocaleId locId = LocaleId.fromString(value);
            if (locId.sameLanguageAs(this.inputLoc)) {
                value = this.outputLoc.toString();
            }
        } else if ("encoding".equals(name)) {
            value = this.outputEncoding;
        }
        if (this.encoderManager == null) {
            if (this.layer == null) {
                return value;
            }
            return this.layer.encode(value, context);
        }
        if (this.layer == null) {
            return this.encoderManager.toNative(name, value);
        }
        return this.layer.encode(this.encoderManager.toNative(name, value), context);
    }

    public void addToReferents(Event event) {
        if (event != null) {
            IResource resource;
            if (this.referents == null) {
                this.referents = new LinkedHashMap();
                this.storageStack = new Stack();
            }
            if ((resource = event.getResource()) != null) {
                switch (event.getEventType()) {
                    case TEXT_UNIT: {
                        if (!((ITextUnit)resource).isReferent()) break;
                        this.referents.put(resource.getId(), new Referent((ITextUnit)resource, this.referentCopies));
                        break;
                    }
                    case DOCUMENT_PART: {
                        if (!((DocumentPart)resource).isReferent()) break;
                        this.referents.put(resource.getId(), new Referent((DocumentPart)resource, this.referentCopies));
                        break;
                    }
                    case START_GROUP: 
                    case START_SUBFILTER: {
                        if (!((StartGroup)resource).isReferent()) break;
                        StorageList sl = new StorageList((StartGroup)resource);
                        this.referents.put(sl.getId(), new Referent(sl, this.referentCopies));
                        break;
                    }
                }
            }
        }
    }

    protected ILayerProvider getLayer() {
        return this.layer;
    }
}

