/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.translatetoolkit;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String SUPPORTCODES = "supportCodes";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setHost("amagama.locamotion.org");
        this.setPort(80);
        this.setSupportCodes(false);
    }

    public String getHost() {
        return this.getString(HOST);
    }

    public void setHost(String host) {
        this.setString(HOST, host);
    }

    public int getPort() {
        return this.getInteger(PORT);
    }

    public void setPort(int port) {
        this.setInteger(PORT, port);
    }

    public boolean getSupportCodes() {
        return this.getBoolean(SUPPORTCODES);
    }

    public void setSupportCodes(boolean supportCodes) {
        this.setBoolean(SUPPORTCODES, supportCodes);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(HOST, "Host", "The host name of the TM server (e.g. localhost)");
        desc.add(PORT, "Port", "The port number of the TM server (e.g. 8080)");
        desc.add(SUPPORTCODES, "Inline codes are letter-coded (e.g. <x1/><g2></g2>)", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Translation Toolkit TM Connector Settings");
        desc.addTextInputPart(paramsDesc.get(HOST));
        desc.addTextInputPart(paramsDesc.get(PORT));
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(SUPPORTCODES));
        cbp.setVertical(true);
        return desc;
    }
}

