/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.json.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class JSONFilter
implements IFilter {
    private static final String MIMETYPE = "application/json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private String encoding;
    private LocaleId srcLoc;
    private boolean hasUTF8BOM;
    private String lineBreak;
    private String inputText;
    private int tuId;
    private int otherId;
    private String docName;
    private LinkedList<Event> queue;
    private boolean canceled;
    private int current;
    private int startRead;
    private StringBuilder buffer;
    private int startString;
    private int endString;
    private boolean hasNext;
    private Pattern exceptions;
    private EncoderManager encoderManager;
    private IFilter subFilter;
    private int subFilterSectionIndex = 0;
    private IFilterConfigurationMapper fcMapper;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "JSON (JavaScript Object Notation)", "Configuration for JSON files", null, ".json;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(MIMETYPE, "net.sf.okapi.common.encoder.JSONEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getDisplayName() {
        return "JSON Filter";
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public String getName() {
        return "okf_json";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.hasNext = false;
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
        }
        if (this.queue.size() == 0) {
            this.parse();
        }
        return this.queue.poll();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        String subFilterName;
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        this.encoding = input.getEncoding();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.encoding), e);
        }
        this.srcLoc = input.getSourceLocale();
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        StringBuilder tmp = new StringBuilder();
        char[] buf = new char[2048];
        int count = 0;
        try {
            while ((count = reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading the input.", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing the input.", e);
                }
            }
        }
        this.inputText = tmp.toString().replace(this.lineBreak, "\n");
        this.current = 0;
        this.tuId = 0;
        this.otherId = 0;
        this.subFilterSectionIndex = 0;
        this.buffer = new StringBuilder();
        this.exceptions = Util.isEmpty(this.params.getExceptions()) ? null : Pattern.compile(this.params.getExceptions());
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
        }
        if (!this.params.getUseCodeFinder() && (subFilterName = this.params.getSubfilter()) != null && !"".equals(subFilterName)) {
            this.subFilter = this.getFilterConfigurationMapper().createFilter(subFilterName, this.subFilter);
        }
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(String.valueOf(++this.otherId));
        startDoc.setName(this.docName);
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLocale(this.srcLoc);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setFilterParameters(this.getParameters());
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType(MIMETYPE);
        startDoc.setMimeType(MIMETYPE);
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        this.hasNext = true;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    public IFilterConfigurationMapper getFilterConfigurationMapper() {
        return this.fcMapper;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void parse() {
        TOKEN token;
        this.startRead = this.current;
        int state = 0;
        String key = "";
        boolean prevWasString = false;
        while ((token = this.readToken()) != TOKEN.ENDINPUT) {
            block0 : switch (state) {
                case 0: {
                    switch (token) {
                        case KEYVALUESEP: {
                            key = this.buffer.toString();
                            prevWasString = false;
                            state = 1;
                            break block0;
                        }
                        case SEPARATOR: 
                        case ENDARRAY: {
                            if (prevWasString && this.params.getExtractStandalone() && this.processString(null)) {
                                return;
                            }
                            prevWasString = false;
                            break block0;
                        }
                        case STRING: {
                            prevWasString = true;
                            break block0;
                        }
                    }
                    prevWasString = false;
                    break;
                }
                case 1: {
                    state = 0;
                    prevWasString = false;
                    if (token != TOKEN.STRING || !this.processString(key)) break;
                    return;
                }
            }
        }
        Ending ending = new Ending(String.valueOf(++this.otherId));
        if (this.startRead < this.current) {
            GenericSkeleton skel = new GenericSkeleton();
            if (this.endString < this.current) {
                skel.append(this.inputText.substring(this.startRead, this.current + 1).replace("\n", this.lineBreak));
            }
            ending.setSkeleton(skel);
        }
        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
        this.hasNext = false;
    }

    private TOKEN readToken() {
        do {
            if (this.current + 1 >= this.inputText.length()) {
                return TOKEN.ENDINPUT;
            }
            switch (this.inputText.charAt(++this.current)) {
                case '{': {
                    return TOKEN.STARTOBJECT;
                }
                case '}': {
                    return TOKEN.ENDOBJECT;
                }
                case '[': {
                    return TOKEN.STARTARRAY;
                }
                case ']': {
                    return TOKEN.ENDARRAY;
                }
                case ':': {
                    return TOKEN.KEYVALUESEP;
                }
                case ',': {
                    return TOKEN.SEPARATOR;
                }
                case '\"': {
                    return this.readString();
                }
            }
        } while (Character.isWhitespace(this.inputText.charAt(this.current)));
        return this.readThing();
    }

    private TOKEN readString() {
        int state = 0;
        this.startString = this.current;
        this.buffer.setLength(0);
        while (true) {
            if (this.current + 1 >= this.inputText.length()) {
                throw new OkapiIOException("Unexpected end of input when parsing.");
            }
            block0 : switch (state) {
                case 0: {
                    switch (this.inputText.charAt(++this.current)) {
                        case '\"': {
                            this.endString = this.current;
                            return TOKEN.STRING;
                        }
                        case '\\': {
                            state = 1;
                            break block0;
                        }
                    }
                    this.buffer.append(this.inputText.charAt(this.current));
                    break;
                }
                case 1: {
                    state = 0;
                    switch (this.inputText.charAt(++this.current)) {
                        case 'b': {
                            this.buffer.append('\b');
                            break block0;
                        }
                        case 'f': {
                            this.buffer.append('\f');
                            break block0;
                        }
                        case 'n': {
                            this.buffer.append('\n');
                            break block0;
                        }
                        case 'r': {
                            this.buffer.append('\r');
                            break block0;
                        }
                        case 't': {
                            this.buffer.append('\t');
                            break block0;
                        }
                        case 'u': {
                            state = 2;
                            break block0;
                        }
                        case '\"': 
                        case '/': 
                        case '\\': {
                            this.buffer.append(this.inputText.charAt(this.current));
                            break block0;
                        }
                    }
                    this.logger.warn("Unexpected escape sequence '\\{}'.", (Object)Character.valueOf(this.inputText.charAt(this.current)));
                    this.buffer.append('\\');
                    this.buffer.append(this.inputText.charAt(this.current));
                    break;
                }
                case 2: {
                    ++this.current;
                    String tmp = this.inputText.substring(this.current, this.current + 4);
                    this.buffer.append((char)Integer.parseInt(tmp, 16));
                    this.current += 3;
                    state = 0;
                }
            }
        }
    }

    private TOKEN readThing() {
        this.buffer.setLength(0);
        while (true) {
            if (this.current + 1 >= this.inputText.length()) {
                throw new OkapiIOException("Unexpected end of input when parsing.");
            }
            switch (this.inputText.charAt(++this.current)) {
                case ']': 
                case '}': {
                    --this.current;
                    return TOKEN.THING;
                }
            }
            if (Character.isWhitespace(this.inputText.charAt(this.current))) {
                return TOKEN.THING;
            }
            this.buffer.append(this.inputText.charAt(this.current));
        }
    }

    private boolean processString(String resName) {
        if (!Util.isEmpty(resName)) {
            boolean extract = this.params.getExtractAllPairs();
            if (this.exceptions != null && this.exceptions.matcher(resName).find()) {
                boolean bl = extract = !extract;
            }
            if (!extract) {
                return false;
            }
        }
        if (this.subFilter != null) {
            String parentId = String.valueOf(++this.tuId);
            SubFilter subfilter = new SubFilter(this.subFilter, this.getEncoderManager().getEncoder(), ++this.subFilterSectionIndex, parentId, resName);
            List<Event> subfilterEvents = subfilter.getEvents(new RawDocument(this.buffer.toString(), this.srcLoc));
            this.queue.addAll(subfilterEvents);
            DocumentPart docPart = new DocumentPart(parentId + "-sub", false);
            GenericSkeleton skel = new GenericSkeleton();
            this.addFrontSkeleton(skel);
            skel.append(subfilter.createRefCode().toString());
            this.addBackSkeleton(skel);
            docPart.setSkeleton(skel);
            this.queue.add(new Event(EventType.DOCUMENT_PART, docPart));
        } else {
            TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
            TextFragment tf = new TextFragment(this.buffer.toString());
            if (this.params.getUseCodeFinder()) {
                this.params.getCodeFinder().process(tf);
            }
            tu.setSourceContent(tf);
            if (this.params.getUseKeyAsName() && !Util.isEmpty(resName)) {
                tu.setName(resName);
            }
            GenericSkeleton skel = new GenericSkeleton();
            this.addFrontSkeleton(skel);
            skel.addContentPlaceholder(tu);
            this.addBackSkeleton(skel);
            tu.setSkeleton(skel);
            tu.setMimeType(MIMETYPE);
            this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        }
        return true;
    }

    private void addFrontSkeleton(GenericSkeleton skel) {
        skel.append(this.inputText.substring(this.startRead, this.startString + 1).replace("\n", this.lineBreak));
    }

    private void addBackSkeleton(GenericSkeleton skel) {
        if (this.endString < this.current) {
            skel.append(this.inputText.substring(this.endString, this.current).replace("\n", this.lineBreak));
        }
    }

    private static enum TOKEN {
        STARTOBJECT,
        ENDOBJECT,
        STARTARRAY,
        ENDARRAY,
        ENDINPUT,
        STRING,
        KEYVALUESEP,
        SEPARATOR,
        THING;

    }
}

