/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;

public class OpenXMLContentSkeletonWriter
extends GenericSkeletonWriter {
    public static final int MSWORD = 1;
    public static final int MSEXCEL = 2;
    public static final int MSPOWERPOINT = 3;
    public static final int MSWORDCHART = 4;
    public static final int MSEXCELCOMMENT = 5;
    public static final int MSWORDDOCPROPERTIES = 6;
    private int configurationType;
    private EncoderManager internalEncoderManager;
    private int nTextBoxLevel = 0;
    private boolean bInBlankText = false;
    private int nContentDepth = 0;

    public OpenXMLContentSkeletonWriter(int configurationType) {
        this.configurationType = configurationType;
        this.internalEncoderManager = new EncoderManager();
        this.internalEncoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.internalEncoderManager.setMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        this.internalEncoderManager.setDefaultOptions(null, "utf-8", "\n");
        this.internalEncoderManager.updateEncoder("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    @Override
    public String getContent(TextFragment tf, LocaleId langToUse, EncoderContext context) {
        String text = tf.getCodedText();
        this.bInBlankText = false;
        boolean bHasBlankInText = false;
        int nSurroundingCodes = 0;
        String sPreserve = "";
        if (!tf.hasCode()) {
            if (text.length() > 0) {
                String sTuff = text;
                if (this.internalEncoderManager == null) {
                    if (this.getLayer() != null) {
                        sTuff = this.getLayer().encode(text, context);
                    }
                } else {
                    sTuff = this.getLayer() == null ? this.internalEncoderManager.encode(text, context) : this.getLayer().encode(this.internalEncoderManager.encode(sTuff, context), context);
                }
                if (context == EncoderContext.SKELETON) {
                    boolean bl = bHasBlankInText = text.indexOf(32) > -1 || text.indexOf(160) > -1;
                    if (bHasBlankInText) {
                        sPreserve = " xml:space=\"preserve\"";
                    }
                    text = this.configurationType == 1 ? "<w:r><w:t" + sPreserve + ">" + sTuff + "</w:t></w:r>" : (this.configurationType == 3 ? "<a:r><a:t" + sPreserve + ">" + sTuff + "</a:t></a:r>" : sTuff);
                } else if (context.ordinal() == this.nTextBoxLevel + 1 && context.ordinal() - this.nContentDepth == 0 && this.configurationType == 1) {
                    boolean bl = bHasBlankInText = text.indexOf(32) > -1 || text.indexOf(160) > -1;
                    if (bHasBlankInText) {
                        sPreserve = " xml:space=\"preserve\"";
                    }
                    text = "<w:r><w:t" + sPreserve + ">" + sTuff + "</w:t></w:r>";
                } else {
                    text = sTuff;
                }
                return text;
            }
            return "";
        }
        List<Code> codes = tf.getCodes();
        StringBuilder tmp = new StringBuilder();
        text = tf.getCodedText();
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\ue101': {
                    tmp = this.blankEnd(context, nSurroundingCodes, tmp);
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    tmp.append(this.expandCodeContent(code, langToUse, context));
                    ++nSurroundingCodes;
                    continue block5;
                }
                case '\ue102': {
                    tmp = this.blankEnd(context, nSurroundingCodes, tmp);
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    tmp.append(this.expandCodeContent(code, langToUse, context));
                    --nSurroundingCodes;
                    continue block5;
                }
                case '\ue103': {
                    tmp = this.blankEnd(context, nSurroundingCodes, tmp);
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (code.getTagType() == TextFragment.TagType.OPENING) {
                        ++nSurroundingCodes;
                    } else if (code.getTagType() == TextFragment.TagType.CLOSING) {
                        --nSurroundingCodes;
                    }
                    tmp.append(this.expandCodeContent(code, langToUse, context));
                    continue block5;
                }
                default: {
                    if (!this.bInBlankText && nSurroundingCodes <= 0) {
                        if (context == EncoderContext.SKELETON) {
                            this.bInBlankText = true;
                            if (this.configurationType == 1) {
                                tmp.append(this.encody("<w:r><w:t xml:space=\"preserve\">", context));
                            } else if (this.configurationType == 3) {
                                tmp.append(this.encody("<a:r><a:t>", context));
                            }
                        } else if (context.ordinal() == this.nTextBoxLevel + 1 && context.ordinal() - this.nContentDepth == 0 && this.configurationType == 1) {
                            this.bInBlankText = true;
                            tmp.append(this.encody("<w:r><w:t xml:space=\"preserve\">", context));
                        }
                    }
                    if (Character.isHighSurrogate(ch)) {
                        int cp = text.codePointAt(i);
                        ++i;
                        if (this.internalEncoderManager == null) {
                            if (this.getLayer() == null) {
                                tmp.append(new String(Character.toChars(cp)));
                                continue block5;
                            }
                            tmp.append(this.getLayer().encode(cp, context));
                            continue block5;
                        }
                        if (this.getLayer() == null) {
                            tmp.append(this.internalEncoderManager.encode(cp, context));
                            continue block5;
                        }
                        tmp.append(this.getLayer().encode(this.internalEncoderManager.encode(cp, context), context));
                        continue block5;
                    }
                    if (this.internalEncoderManager == null) {
                        if (this.getLayer() == null) {
                            tmp.append(ch);
                            continue block5;
                        }
                        tmp.append(this.getLayer().encode(ch, context));
                        continue block5;
                    }
                    if (this.getLayer() == null) {
                        tmp.append(this.internalEncoderManager.encode(ch, context));
                        continue block5;
                    }
                    tmp.append(this.getLayer().encode(this.internalEncoderManager.encode(ch, context), context));
                }
            }
        }
        tmp = this.blankEnd(context, nSurroundingCodes, tmp);
        return tmp.toString();
    }

    private String encody(String s, EncoderContext context) {
        return s;
    }

    public void setNTextBoxLevel(int nTextBoxLevel) {
        this.nTextBoxLevel = nTextBoxLevel;
    }

    private StringBuilder blankEnd(EncoderContext context, int nSurroundingCodes, StringBuilder tmp) {
        if (this.bInBlankText && nSurroundingCodes <= 0) {
            if (context == EncoderContext.SKELETON) {
                this.bInBlankText = false;
                if (this.configurationType == 1) {
                    tmp.append(this.encody("</w:t></w:r>", context));
                } else if (this.configurationType == 3) {
                    tmp.append(this.encody("</a:t></a:r>", context));
                }
            } else if (context.ordinal() == this.nTextBoxLevel + 1 && context.ordinal() - this.nContentDepth == 0 && this.configurationType == 1) {
                this.bInBlankText = false;
                tmp.append(this.encody("</w:t></w:r>", context));
            }
        }
        return tmp;
    }

    @Override
    protected String getContent(ITextUnit tu, LocaleId locToUse, EncoderContext context) {
        Property prop = tu.getProperty("TextBoxLevel");
        this.nTextBoxLevel = 0;
        if (prop != null) {
            try {
                this.nTextBoxLevel = Integer.parseInt(prop.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ++this.nContentDepth;
        String result = super.getContent(tu, locToUse, context);
        --this.nContentDepth;
        return result;
    }
}

