/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.csv;

import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;

public class CSVSkeletonWriter
extends GenericSkeletonWriter {
    @Override
    public String processTextUnit(ITextUnit tu) {
        if (tu.hasProperty("qualified") && "yes".equals(tu.getProperty("qualified").getValue())) {
            return super.processTextUnit(tu);
        }
        boolean isTarget = tu.hasTarget(this.outputLoc);
        TextContainer tc = isTarget ? tu.getTarget(this.outputLoc) : tu.getSource();
        if (tc == null) {
            return super.processTextUnit(tu);
        }
        TextFragment tf = tc.getUnSegmentedContentCopy();
        String text = tf.toText();
        if (text.contains(",") || text.contains("\n")) {
            if (tc.hasBeenSegmented()) {
                tc.insert(0, new TextPart("\""));
                tc.append(new TextPart("\""));
            } else {
                tf.insert(0, new TextFragment("\""));
                tf.append("\"");
                tc.setContent(tf);
            }
        }
        return super.processTextUnit(tu);
    }
}

