/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final int SEGMENTATIONTYPE_ORIGINAL = 0;
    public static final int SEGMENTATIONTYPE_SEGMENTED = 1;
    public static final int SEGMENTATIONTYPE_NOTSEGMENTED = 2;
    public static final int SEGMENTATIONTYPE_ASNEEDED = 3;
    public static final int TARGETSTATEMODE_IGNORE = 0;
    public static final int TARGETSTATEMODE_EXTRACT = 1;
    public static final int TARGETSTATEMODE_DONOTEXTRACT = 2;
    public static final String ADDALTTRANS = "addAltTrans";
    public static final String ADDALTTRANSGMODE = "addAltTransGMode";
    private static final String USECUSTOMPARSER = "useCustomParser";
    private static final String FACTORYCLASS = "factoryClass";
    private static final String FALLBACKTOID = "fallbackToID";
    private static final String ADDTARGETLANGUAGE = "addTargetLanguage";
    private static final String OVERRIDETARGETLANGUAGE = "overrideTargetLanguage";
    private static final String ALLOWEMPTYTARGETS = "allowEmptyTargets";
    private static final String OUTPUTSEGMENTATIONTYPE = "outputSegmentationType";
    private static final String IGNOREINPUTSEGMENTATION = "ignoreInputSegmentation";
    private static final String INCLUDEEXTENSIONS = "includeExtensions";
    private static final String TARGETSTATEMODE = "targetStateMode";
    private static final String TARGETSTATEVALUE = "targetStateValue";
    private static final String INCLUDEITS = "includeIts";

    public boolean getUseCustomParser() {
        return this.getBoolean(USECUSTOMPARSER);
    }

    public void setUseCustomParser(boolean useCustomParser) {
        this.setBoolean(USECUSTOMPARSER, useCustomParser);
    }

    public String getFactoryClass() {
        return this.getString(FACTORYCLASS);
    }

    public void setFactoryClass(String factoryClass) {
        this.setString(FACTORYCLASS, factoryClass);
    }

    public boolean getEscapeGT() {
        return this.getBoolean("escapeGT");
    }

    public void setEscapeGT(boolean escapeGT) {
        this.setBoolean("escapeGT", escapeGT);
    }

    public boolean getFallbackToID() {
        return this.getBoolean(FALLBACKTOID);
    }

    public void setFallbackToID(boolean fallbackToID) {
        this.setBoolean(FALLBACKTOID, fallbackToID);
    }

    public boolean getAddTargetLanguage() {
        return this.getBoolean(ADDTARGETLANGUAGE);
    }

    public void setAddTargetLanguage(boolean addTargetLanguage) {
        this.setBoolean(ADDTARGETLANGUAGE, addTargetLanguage);
    }

    public boolean getOverrideTargetLanguage() {
        return this.getBoolean(OVERRIDETARGETLANGUAGE);
    }

    public void setOverrideTargetLanguage(boolean overrideTargetLanguage) {
        this.setBoolean(OVERRIDETARGETLANGUAGE, overrideTargetLanguage);
    }

    public int getOutputSegmentationType() {
        return this.getInteger(OUTPUTSEGMENTATIONTYPE);
    }

    public void setOutputSegmentationType(int segmentationType) {
        this.setInteger(OUTPUTSEGMENTATIONTYPE, segmentationType);
    }

    public boolean getIgnoreInputSegmentation() {
        return this.getBoolean(IGNOREINPUTSEGMENTATION);
    }

    public void setIgnoreInputSegmentation(boolean ignoreInputSegmentation) {
        this.setBoolean(IGNOREINPUTSEGMENTATION, ignoreInputSegmentation);
    }

    public boolean getAddAltTrans() {
        return this.getBoolean(ADDALTTRANS);
    }

    public void setAddAltTrans(boolean addAltTrans) {
        this.setBoolean(ADDALTTRANS, addAltTrans);
    }

    public boolean getAddAltTransGMode() {
        return this.getBoolean(ADDALTTRANSGMODE);
    }

    public void setAddAltTransGMode(boolean addAltTransGMode) {
        this.setBoolean(ADDALTTRANSGMODE, addAltTransGMode);
    }

    public boolean getIncludeExtensions() {
        return this.getBoolean(INCLUDEEXTENSIONS);
    }

    public void setIncludeExtensions(boolean includeExtensions) {
        this.setBoolean(INCLUDEEXTENSIONS, includeExtensions);
    }

    public boolean getIncludeIts() {
        return this.getBoolean(INCLUDEITS);
    }

    public void setIncludeIts(boolean includeIts) {
        this.setBoolean(INCLUDEITS, includeIts);
    }

    public boolean getAllowEmptyTargets() {
        return this.getBoolean(ALLOWEMPTYTARGETS);
    }

    public void setAllowEmptyTargets(boolean allowEmptyTargets) {
        this.setBoolean(ALLOWEMPTYTARGETS, allowEmptyTargets);
    }

    public int getTargetStateMode() {
        return this.getInteger(TARGETSTATEMODE);
    }

    public void setTargetStateMode(int targetStateMode) {
        this.setInteger(TARGETSTATEMODE, targetStateMode);
    }

    public String getTargetStateValue() {
        return this.getString(TARGETSTATEVALUE);
    }

    public void setTargetStateValue(String targetStateValue) {
        this.setString(TARGETSTATEVALUE, targetStateValue);
    }

    public boolean getQuoteModeDefined() {
        return this.getBoolean("quoteModeDefined");
    }

    protected void setQuoteModeDefined(boolean defined) {
        this.setBoolean("quoteModeDefined", defined);
    }

    public int getQuoteMode() {
        return this.getInteger("quoteMode");
    }

    protected void setQuoteMode(int quoteMode) {
        this.setInteger("quoteMode", quoteMode);
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseCustomParser(true);
        this.setFactoryClass("com.ctc.wstx.stax.WstxInputFactory");
        this.setFallbackToID(false);
        this.setEscapeGT(false);
        this.setAddTargetLanguage(true);
        this.setOverrideTargetLanguage(false);
        this.setOutputSegmentationType(0);
        this.setIgnoreInputSegmentation(false);
        this.setAddAltTrans(false);
        this.setAddAltTransGMode(true);
        this.setIncludeExtensions(true);
        this.setIncludeIts(true);
        this.setAllowEmptyTargets(false);
        this.setTargetStateMode(0);
        this.setTargetStateValue("needs-translation");
        this.setQuoteModeDefined(true);
        this.setQuoteMode(0);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USECUSTOMPARSER, "Use a custom XML stream parser", null);
        desc.add(FACTORYCLASS, "Factory class for the custom XML stream parser", null);
        desc.add(FALLBACKTOID, "Use the trans-unit id attribute for the text unit name if there is no resname", null);
        desc.add(IGNOREINPUTSEGMENTATION, "Ignore the segmentation information in the input", null);
        desc.add("escapeGT", "Escape the greater-than characters", null);
        desc.add(ADDTARGETLANGUAGE, "Add the target-language attribute if not present", null);
        desc.add(OVERRIDETARGETLANGUAGE, "Override the target language of the XLIFF document", null);
        desc.add(ALLOWEMPTYTARGETS, "Allow empty <target> elements in XLIFF document", "If set: leave the <target> element empty, do not copy source text into it");
        desc.add(OUTPUTSEGMENTATIONTYPE, "Type of output segmentation", "Indicates wether to segment or not the text content in output");
        desc.add(ADDALTTRANS, "Allow addition of new <alt-trans> elements", "Indicates wether or not to adding new <alt-trans> elements is allowed");
        desc.add(ADDALTTRANSGMODE, "Use the <g> notation in new <alt-trans> elements", "Indicates wether or not to use the <g> notation in new <alt-trans> elements");
        desc.add(INCLUDEEXTENSIONS, "Include extra information", "If set: non-standard information are included in the added <alt-trans>");
        desc.add(INCLUDEITS, "Include ITS markup", "If set: ITS markup is included");
        desc.add(TARGETSTATEMODE, "Action to do when the value of the state attribute matches the specified pattern", null);
        desc.add(TARGETSTATEVALUE, "Pattern for the state attribute value", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("XLIFF Filter Parameters", true, false);
        desc.addCheckboxPart(paramDesc.get(FALLBACKTOID));
        desc.addCheckboxPart(paramDesc.get(IGNOREINPUTSEGMENTATION));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramDesc.get("escapeGT"));
        desc.addCheckboxPart(paramDesc.get(ADDTARGETLANGUAGE));
        desc.addCheckboxPart(paramDesc.get(OVERRIDETARGETLANGUAGE));
        desc.addCheckboxPart(paramDesc.get(ALLOWEMPTYTARGETS));
        String[] values2 = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2), String.valueOf(3)};
        String[] labels2 = new String[]{"Show segments only if the input text unit is segmented", "Always show segments (even if the input text unit is not segmented)", "Never show segments (even if the input text unit is segmented)", "Show segments only if the entry is segmented and regardless how the input was"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(OUTPUTSEGMENTATIONTYPE), values2);
        lsp.setChoicesLabels(labels2);
        desc.addCheckboxPart(paramDesc.get(INCLUDEITS));
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(ADDALTTRANS));
        desc.addCheckboxPart(paramDesc.get(INCLUDEEXTENSIONS)).setMasterPart(cbp, true);
        desc.addCheckboxPart(paramDesc.get(ADDALTTRANSGMODE)).setMasterPart(cbp, true);
        desc.addSeparatorPart();
        cbp = desc.addCheckboxPart(paramDesc.get(USECUSTOMPARSER));
        desc.addTextInputPart(paramDesc.get(FACTORYCLASS)).setMasterPart(cbp, true);
        return desc;
    }
}

