/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.segmentation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.steps.segmentation.Parameters;
import net.sf.okapi.steps.segmentation.RenumberingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class SegmentationStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private ISegmenter srcSeg = null;
    private Map<LocaleId, ISegmenter> trgSegs = new HashMap<LocaleId, ISegmenter>();
    private LocaleId sourceLocale;
    private List<LocaleId> targetLocales;
    private boolean initDone;
    private String rootDir;
    private String inputRootDir;

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.targetLocales = targetLocales;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    public List<LocaleId> getTargetLocales() {
        return this.targetLocales;
    }

    public String getRootDirectory() {
        return this.rootDir;
    }

    public String getInputRootDirectory() {
        return this.inputRootDir;
    }

    @Override
    public String getName() {
        return "Segmentation";
    }

    @Override
    public String getDescription() {
        return "Apply SRX segmentation to the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.initDone = false;
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        if (this.initDone) {
            return event;
        }
        SRXDocument srxDoc = new SRXDocument();
        String src = null;
        if (this.params.getSegmentSource()) {
            src = Util.fillRootDirectoryVariable(this.params.getSourceSrxPath(), this.rootDir);
            src = Util.fillInputRootDirectoryVariable(src, this.inputRootDir);
            srxDoc.loadRules(src);
            if (srxDoc.hasWarning()) {
                this.logger.warn(srxDoc.getWarning());
            }
            if (this.params.getTrimSrcLeadingWS() != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimLeadingWhitespaces(this.params.getTrimSrcLeadingWS() == Parameters.TRIM_YES);
            }
            if (this.params.getTrimSrcTrailingWS() != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimTrailingWhitespaces(this.params.getTrimSrcTrailingWS() == Parameters.TRIM_YES);
            }
            this.srcSeg = srxDoc.compileLanguageRules(this.sourceLocale, null);
        }
        if (this.params.getSegmentTarget()) {
            String trg = Util.fillRootDirectoryVariable(this.params.getTargetSrxPath(), this.rootDir);
            trg = Util.fillInputRootDirectoryVariable(trg, this.inputRootDir);
            if (Util.isEmpty(src) || !src.equals(trg)) {
                srxDoc.loadRules(trg);
                if (srxDoc.hasWarning()) {
                    this.logger.warn(srxDoc.getWarning());
                }
                if (srxDoc.hasWarning()) {
                    this.logger.warn(srxDoc.getWarning());
                }
            }
            if (this.params.getTrimTrgLeadingWS() != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimLeadingWhitespaces(this.params.getTrimTrgLeadingWS() == Parameters.TRIM_YES);
            }
            if (this.params.getTrimTrgTrailingWS() != Parameters.TRIM_DEFAULT) {
                srxDoc.setTrimTrailingWhitespaces(this.params.getTrimTrgTrailingWS() == Parameters.TRIM_YES);
            }
            for (LocaleId targetLocale : this.targetLocales) {
                ISegmenter trgSeg = srxDoc.compileLanguageRules(targetLocale, null);
                this.trgSegs.put(targetLocale, trgSeg);
            }
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        IParameters prm;
        if ((this.params.getSegmentSource() || this.params.getSegmentTarget()) && this.params.getForcesegmentedOutput() && (prm = event.getStartDocument().getFilterParameters()) != null) {
            prm.setInteger("outputSegmentationType", 3);
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (!this.params.getSegmentSource() && !this.params.getSegmentTarget()) {
            return event;
        }
        if (this.params.getSegmentSource()) {
            if (this.params.getSegmentationStrategy() == Parameters.SegmStrategy.OVERWRITE_EXISTING || !tu.getSource().hasBeenSegmented()) {
                tu.createSourceSegmentation(this.srcSeg);
            } else if (this.params.getSegmentationStrategy() == Parameters.SegmStrategy.DEEPEN_EXISTING) {
                this.deepenSegmentation(tu.getSource(), this.srcSeg);
            }
            if (this.params.getRenumberCodes()) {
                RenumberingUtil.renumberCodesForSegmentation(tu.getSource());
            }
        }
        if (this.targetLocales != null) {
            for (LocaleId targetLocale : this.targetLocales) {
                TextContainer trgCont = tu.getTarget(targetLocale);
                ISegmenter trgSeg = this.trgSegs.get(targetLocale);
                if (this.params.getSegmentTarget() && trgCont != null) {
                    if (this.params.getSegmentationStrategy() == Parameters.SegmStrategy.OVERWRITE_EXISTING || !trgCont.hasBeenSegmented()) {
                        trgSeg.computeSegments(trgCont);
                        trgCont.getSegments().create(trgSeg.getRanges());
                    } else if (this.params.getSegmentationStrategy() == Parameters.SegmStrategy.DEEPEN_EXISTING) {
                        this.deepenSegmentation(trgCont, trgSeg);
                    }
                    if (this.params.getRenumberCodes()) {
                        RenumberingUtil.renumberCodesForSegmentation(trgCont);
                    }
                }
                if (this.params.getCopySource()) {
                    trgCont = tu.createTarget(targetLocale, false, 7);
                }
                if (!this.params.getCheckSegments() || trgCont == null) continue;
                if (trgCont.getSegments().count() != tu.getSource().getSegments().count()) {
                    this.logger.warn("Text unit id='{}': Source ({}) and target ({}) do not have the same number of segments.", tu.getId(), this.sourceLocale, targetLocale);
                    continue;
                }
                ISegments trgSegs = trgCont.getSegments();
                for (Segment seg : tu.getSource().getSegments()) {
                    if (trgSegs.get(seg.id) != null) continue;
                    this.logger.warn("Text unit id='{}': No match found for source segment id='{}' in target language '{}'", tu.getId(), seg.id, targetLocale);
                }
            }
        }
        return event;
    }

    private void deepenSegmentation(TextContainer tc, ISegmenter segmenter) {
        if (tc == null || segmenter == null) {
            this.logger.error("Parameter cannot be null");
            return;
        }
        for (int i = tc.count() - 1; i >= 0; --i) {
            TextPart part = tc.get(i);
            if (!part.isSegment()) continue;
            TextContainer segTc = new TextContainer(part);
            segmenter.computeSegments(segTc);
            segTc.getSegments().create(segmenter.getRanges());
            this.replacePart(tc, i, segTc);
        }
    }

    private void replacePart(TextContainer oldPartContainer, int index, TextContainer newPartsContainer) {
        for (int i = newPartsContainer.count() - 1; i >= 0; --i) {
            oldPartContainer.insert(index, newPartsContainer.get(i));
        }
        oldPartContainer.remove(index + newPartsContainer.count());
    }
}

