/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URLDecoder;
import net.sf.okapi.applications.rainbow.BatchLog;
import net.sf.okapi.applications.rainbow.Input;
import net.sf.okapi.applications.rainbow.Project;
import net.sf.okapi.applications.rainbow.Res;
import net.sf.okapi.applications.rainbow.UtilitiesAccess;
import net.sf.okapi.applications.rainbow.UtilityDriver;
import net.sf.okapi.applications.rainbow.lib.FormatManager;
import net.sf.okapi.applications.rainbow.lib.LanguageManager;
import net.sf.okapi.applications.rainbow.lib.Utils;
import net.sf.okapi.applications.rainbow.pipeline.IPredefinedPipeline;
import net.sf.okapi.applications.rainbow.pipeline.PipelineEditor;
import net.sf.okapi.applications.rainbow.pipeline.PipelineWrapper;
import net.sf.okapi.applications.rainbow.pipeline.PreDefinedPipelines;
import net.sf.okapi.applications.rainbow.utilities.IUtility;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.plugins.PluginsManager;
import net.sf.okapi.common.ui.BaseHelp;
import org.eclipse.swt.widgets.Shell;

public class CommandLine {
    private String appRootFolder;
    private String sharedFolder;
    private LanguageManager lm;
    private Project prj;
    private Shell shell;
    private UtilityDriver ud;
    private FilterConfigurationMapper fcMapper;
    private UtilitiesAccess utilitiesAccess;
    private BatchLog log;
    private String utilityId;
    private String pipelineFile;
    private String optionsFile;
    private boolean promptForOptions = true;
    private BaseHelp help;
    private PluginsManager pm;
    private PrintStream ps = null;
    private ExecutionContext context;
    private File logFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Shell shell, String[] args) {
        try {
            PreDefinedPipelines ppMapper;
            if (!this.setLogFile(args)) {
                this.logFile = new File(System.getProperty("user.home") + "/rainbowBatchLog.txt");
            }
            this.ps = new PrintStream(new FileOutputStream(this.logFile));
            System.setOut(this.ps);
            System.setErr(this.ps);
            this.shell = shell;
            this.printBanner();
            this.initialize();
            if (!this.parseArguments(args)) {
                int n = 1;
                return n;
            }
            IPredefinedPipeline predefinedPipeline = null;
            if (this.utilityId != null && (predefinedPipeline = (ppMapper = new PreDefinedPipelines()).create(this.utilityId)) != null) {
                this.utilityId = null;
            }
            if (this.utilityId != null) {
                this.launchUtility();
            } else if (this.pipelineFile != null) {
                this.launchPipeline(null);
            } else if (predefinedPipeline != null) {
                this.launchPipeline(predefinedPipeline);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            if (this.ps != null) {
                this.ps.close();
            }
        }
        if (this.log != null && this.log.getErrorCount() > 0) {
            return 1;
        }
        return 0;
    }

    private boolean setLogFile(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!"-log".equals(arg)) continue;
            this.logFile = new File(this.nextArg(args, ++i));
            return true;
        }
        return false;
    }

    private boolean parseArguments(String[] args) throws Exception {
        boolean continueAfter = false;
        FormatManager fm = new FormatManager();
        fm.load(null);
        this.prj = new Project(this.lm);
        this.prj.setInputRoot(0, this.appRootFolder, true);
        this.prj.setInputRoot(1, this.appRootFolder, true);
        this.prj.setInputRoot(2, this.appRootFolder, true);
        boolean setOutSearch = false;
        int inpList = -1;
        this.optionsFile = null;
        this.pipelineFile = null;
        for (int i = 0; i < args.length; ++i) {
            File f;
            Input inp;
            String arg = args[i];
            if ("-p".equals(arg)) {
                this.prj.load(this.nextArg(args, ++i));
            } else if ("-x".equals(arg)) {
                this.utilityId = this.nextArg(args, ++i);
                continueAfter = true;
            } else if ("-np".equals(arg)) {
                this.promptForOptions = false;
                this.context.setIsNoPrompt(true);
            } else if ("-h".equals(arg) || "-?".equals(arg)) {
                this.help.showWiki("Rainbow Help#Rainbow - Command Line");
            } else if ("-log".equals(arg)) {
                ++i;
            } else if ("-se".equals(arg)) {
                this.prj.setSourceEncoding(this.nextArg(args, ++i));
            } else if ("-te".equals(arg)) {
                this.prj.setTargetEncoding(this.nextArg(args, ++i));
            } else if ("-sl".equals(arg)) {
                this.prj.setSourceLanguage(LocaleId.fromString(this.nextArg(args, ++i)));
            } else if ("-tl".equals(arg)) {
                this.prj.setTargetLanguage(LocaleId.fromString(this.nextArg(args, ++i)));
            } else if ("-ir".equals(arg) || "-ir0".equals(arg)) {
                this.prj.setInputRoot(0, this.nextArg(args, ++i), true);
            } else if ("-pd".equals(arg)) {
                this.prj.setCustomParametersFolder(this.nextArg(args, ++i));
                this.prj.setUseCustomParametersFolder(true);
            } else if ("-rd".equals(arg)) {
                this.prj.setPath(Util.ensureSeparator(this.nextArg(args, ++i), false) + "project.rnb");
            } else if ("-opt".equals(arg)) {
                this.optionsFile = this.nextArg(args, ++i);
            } else if ("-pln".equals(arg)) {
                this.pipelineFile = this.nextArg(args, ++i);
                continueAfter = true;
            } else if ("-fc".equals(arg)) {
                inp = this.prj.getLastItem(inpList);
                if (inp == null) {
                    throw new RuntimeException(Res.getString("CommandLine.fsBeforeInputError"));
                }
                inp.filterConfigId = this.nextArg(args, ++i);
            } else if ("-o".equals(arg)) {
                f = new File(this.nextArg(args, ++i));
                this.prj.setOutputRoot(Util.getDirectoryName(f.getAbsolutePath()));
                this.prj.setUseOutputRoot(true);
                this.prj.pathBuilder.setUseExtension(false);
                this.prj.pathBuilder.setUseReplace(true);
                this.prj.pathBuilder.setReplace(Util.getFilename(f.getAbsolutePath(), true));
                setOutSearch = true;
            } else if (!arg.startsWith("-")) {
                if (++inpList > 2) {
                    throw new RuntimeException(Res.getString("CommandLine.tooManyInput"));
                }
                f = new File(arg);
                String[] res = fm.guessFormat(f.getAbsolutePath());
                this.prj.inputLists.get(inpList).clear();
                this.prj.setInputRoot(inpList, Util.getDirectoryName(f.getAbsolutePath()), true);
                this.prj.addDocument(inpList, f.getAbsolutePath(), res[0], null, res[1], false);
            } else {
                this.log.error(Res.getString("CommandLine.invalidCommand") + args[i]);
                continueAfter = false;
            }
            if (!setOutSearch) continue;
            inp = this.prj.getLastItem(0);
            if (inp == null) {
                throw new RuntimeException(Res.getString("CommandLine.noInput"));
            }
            this.prj.pathBuilder.setSearch(inp.relativePath);
        }
        return continueAfter;
    }

    private String nextArg(String[] args, int index) {
        if (index >= args.length) {
            throw new RuntimeException(Res.getString("CommandLine.missingParameter"));
        }
        return args[index];
    }

    private void printBanner() {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println(Res.getString("CommandLine.bannerApplication"));
        System.out.println(Res.getString("CommandLine.bannerVersion") + this.getClass().getPackage().getImplementationVersion());
        System.out.println("-------------------------------------------------------------------------------");
    }

    private void initialize() throws Exception {
        File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        this.appRootFolder = URLDecoder.decode(file.getAbsolutePath(), "utf-8");
        boolean fromJar = this.appRootFolder.endsWith(".jar");
        if (fromJar) {
            this.appRootFolder = Util.getDirectoryName(this.appRootFolder);
        }
        this.appRootFolder = Util.getDirectoryName(this.appRootFolder);
        this.sharedFolder = Utils.getOkapiSharedFolder(this.appRootFolder, fromJar);
        this.help = new BaseHelp(this.appRootFolder + File.separator + "help");
        this.log = new BatchLog();
        this.lm = new LanguageManager();
        this.lm.loadList(this.sharedFolder + File.separator + "languages.xml");
        this.fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(this.fcMapper, false, true);
        this.pm = new PluginsManager();
        this.pm.discover(new File(this.appRootFolder + File.separator + "dropins"), true);
        this.fcMapper.addFromPlugins(this.pm);
        this.utilitiesAccess = new UtilitiesAccess();
        this.utilitiesAccess.loadMenu(this.sharedFolder + File.separator + "rainbowUtilities.xml");
        this.context = new ExecutionContext();
        this.context.setApplicationName("Rainbow");
        this.context.setUiParent(this.shell);
    }

    private void launchUtility() {
        if (this.ud == null) {
            this.fcMapper.setCustomConfigurationsDirectory(this.prj.getParametersFolder());
            this.fcMapper.updateCustomConfigurations();
            this.ud = new UtilityDriver(this.log, this.fcMapper, this.utilitiesAccess, this.help, false);
        }
        this.ud.setData(this.prj, this.utilityId);
        IUtility util = this.ud.getUtility();
        if (this.optionsFile != null && util.hasParameters()) {
            File f = new File(this.optionsFile);
            util.getParameters().load(f.toURI(), true);
        }
        if (this.promptForOptions) {
            if (!this.ud.checkParameters(this.shell)) {
                return;
            }
            if (this.optionsFile != null && util.hasParameters()) {
                util.getParameters().save(this.optionsFile);
            }
        }
        this.ud.execute(this.shell);
    }

    private void launchPipeline(IPredefinedPipeline predefinedPipeline) {
        this.fcMapper.setCustomConfigurationsDirectory(this.prj.getParametersFolder());
        this.fcMapper.updateCustomConfigurations();
        PipelineWrapper wrapper = new PipelineWrapper(this.fcMapper, this.appRootFolder, this.pm, this.prj.getProjectFolder(), this.prj.getInputRoot(0), null, null, this.context);
        if (predefinedPipeline != null) {
            predefinedPipeline.setParameters(wrapper.getAvailableSteps(), this.prj.getUtilityParameters(predefinedPipeline.getId()));
            wrapper.loadPipeline(predefinedPipeline, null);
        } else {
            wrapper.load(this.pipelineFile);
        }
        if (this.promptForOptions) {
            PipelineEditor dlg = new PipelineEditor();
            int res = dlg.edit(this.shell, wrapper.getAvailableSteps(), wrapper, predefinedPipeline == null ? null : predefinedPipeline.getTitle(), this.help, null, predefinedPipeline == null ? -1 : predefinedPipeline.getInitialStepIndex());
            if (res == 0) {
                return;
            }
            if (res == 1) {
                return;
            }
        }
        wrapper.execute(this.prj);
    }
}

