/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.okapi.applications.rainbow.Input;
import net.sf.okapi.applications.rainbow.Res;
import net.sf.okapi.applications.rainbow.lib.LanguageManager;
import net.sf.okapi.applications.rainbow.lib.PathBuilder;
import net.sf.okapi.applications.rainbow.lib.Utils;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Project {
    protected ArrayList<ArrayList<Input>> inputLists;
    protected String path;
    protected PathBuilder pathBuilder;
    protected boolean isModified;
    private ArrayList<String> inputRoots;
    private ArrayList<Boolean> useCustomInputRoots;
    private Hashtable<String, String> utilityParams;
    private boolean useOutputRoot = false;
    private String outputRoot = "";
    private LocaleId sourceLanguage;
    private String sourceEncoding;
    private LocaleId targetLanguage;
    private String targetEncoding;
    private boolean useCustomParamsFolder = false;
    private String customParamsFolder = System.getProperty("user.home");
    private String lastOutputFolder;

    public Project(LanguageManager lm) {
        this.inputLists = new ArrayList();
        this.useCustomInputRoots = new ArrayList();
        this.inputRoots = new ArrayList();
        this.inputLists.add(new ArrayList());
        this.inputRoots.add(System.getProperty("user.home"));
        this.useCustomInputRoots.add(false);
        this.inputLists.add(new ArrayList());
        this.inputRoots.add(System.getProperty("user.home"));
        this.useCustomInputRoots.add(false);
        this.inputLists.add(new ArrayList());
        this.inputRoots.add(System.getProperty("user.home"));
        this.useCustomInputRoots.add(false);
        this.utilityParams = new Hashtable();
        this.pathBuilder = new PathBuilder();
        this.pathBuilder.setExtension(".out");
        this.sourceLanguage = Utils.getDefaultSourceLanguage();
        this.targetLanguage = Utils.getDefaultTargetLanguage();
        this.sourceEncoding = lm.getDefaultEncodingFromCode(this.sourceLanguage, Util.getOS());
        this.targetEncoding = lm.getDefaultEncodingFromCode(this.targetLanguage, Util.getOS());
        this.isModified = false;
    }

    public ArrayList<Input> getList(int index) {
        return this.inputLists.get(index);
    }

    private boolean adjustRootAndRelativePaths(int listIndex, String newPath) {
        String difference;
        String dir;
        String currentRoot = this.getInputRoot(listIndex);
        String newRoot = Util.longestCommonDir(currentRoot, dir = Util.getDirectoryName(newPath), !Util.isOSCaseSensitive());
        if (Util.isEmpty(newRoot)) {
            return false;
        }
        for (Input input : this.inputLists.get(listIndex)) {
            String fullPath = currentRoot + File.separator + input.relativePath;
            input.relativePath = fullPath.substring(newRoot.length() + 1);
        }
        String currentRawRoot = this.getRawInputRoot(listIndex);
        if (!currentRawRoot.equals(currentRoot) && currentRawRoot.endsWith(difference = currentRoot.substring(newRoot.length()))) {
            newRoot = currentRawRoot.substring(0, currentRawRoot.length() - difference.length());
        }
        this.setInputRoot(listIndex, newRoot, true);
        return true;
    }

    public int addDocument(int listIndex, String newPath, String sourceEncoding, String targetEncoding, String filterSettings, boolean allowDuplicates) {
        boolean ignoreCase;
        int res = 0;
        String inputRoot = this.getInputRoot(listIndex);
        if (newPath.indexOf(inputRoot) == -1) {
            if (!this.adjustRootAndRelativePaths(listIndex, newPath)) {
                return 1;
            }
            res = 3;
            inputRoot = this.getInputRoot(listIndex);
        }
        int correction = inputRoot.endsWith(File.separator) ? -1 : 0;
        newPath = newPath.substring(inputRoot.length() + correction + 1);
        boolean bl = ignoreCase = !Util.isOSCaseSensitive();
        if (!allowDuplicates) {
            for (Input tmpInp : this.inputLists.get(listIndex)) {
                if (!(ignoreCase ? tmpInp.relativePath.equalsIgnoreCase(newPath) : tmpInp.relativePath.equals(newPath))) continue;
                return 2;
            }
        }
        Input inp = new Input();
        inp.sourceEncoding = sourceEncoding == null ? "" : sourceEncoding;
        inp.targetEncoding = targetEncoding == null ? "" : targetEncoding;
        inp.filterConfigId = filterSettings == null ? "" : filterSettings;
        inp.relativePath = newPath;
        this.inputLists.get(listIndex).add(inp);
        this.isModified = true;
        return res;
    }

    public Input getItemFromRelativePath(int listIndex, String relativePath) {
        for (Input inp : this.inputLists.get(listIndex)) {
            if (!inp.relativePath.equalsIgnoreCase(relativePath)) continue;
            return inp;
        }
        return null;
    }

    public Input getLastItem(int listIndex) {
        if (this.inputLists.get(listIndex).size() == 0) {
            return null;
        }
        return this.inputLists.get(listIndex).get(this.inputLists.get(listIndex).size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String newPath) throws Exception {
        try (XMLWriter writer = null;){
            writer = new XMLWriter(newPath);
            writer.writeStartDocument();
            writer.writeStartElement("rainbowProject");
            writer.writeAttributeString("version", "4");
            int i = 0;
            for (ArrayList<Input> inputList : this.inputLists) {
                writer.writeStartElement("fileSet");
                writer.writeAttributeString("id", String.format("%d", i + 1));
                writer.writeStartElement("root");
                writer.writeAttributeString("useCustom", this.useCustomInputRoots.get(i) != false ? "1" : "0");
                writer.writeString(this.inputRoots.get(i).replace('\\', '/'));
                writer.writeEndElement();
                for (Input item : inputList) {
                    writer.writeStartElement("fi");
                    writer.writeAttributeString("fs", item.filterConfigId);
                    writer.writeAttributeString("fo", item.format);
                    writer.writeAttributeString("se", item.sourceEncoding);
                    writer.writeAttributeString("te", item.targetEncoding);
                    writer.writeString(item.relativePath.replace('\\', '/'));
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                ++i;
            }
            writer.writeStartElement("output");
            writer.writeStartElement("root");
            writer.writeAttributeString("use", this.useOutputRoot ? "1" : "0");
            writer.writeString(this.outputRoot.replace('\\', '/'));
            writer.writeEndElement();
            writer.writeStartElement("subFolder");
            writer.writeAttributeString("use", this.pathBuilder.useSubfolder() ? "1" : "0");
            writer.writeString(this.pathBuilder.getSubfolder().replace('\\', '/'));
            writer.writeEndElement();
            writer.writeStartElement("extension");
            writer.writeAttributeString("use", this.pathBuilder.useExtension() ? "1" : "0");
            writer.writeAttributeString("style", String.format("%d", this.pathBuilder.getExtensionType()));
            writer.writeString(this.pathBuilder.getExtension());
            writer.writeEndElement();
            writer.writeStartElement("replace");
            writer.writeAttributeString("use", this.pathBuilder.useReplace() ? "1" : "0");
            writer.writeAttributeString("oldText", this.pathBuilder.getSearch().replace('\\', '/'));
            writer.writeAttributeString("newText", this.pathBuilder.getReplace().replace('\\', '/'));
            writer.writeEndElement();
            writer.writeStartElement("prefix");
            writer.writeAttributeString("use", this.pathBuilder.usePrefix() ? "1" : "0");
            writer.writeString(this.pathBuilder.getPrefix());
            writer.writeEndElement();
            writer.writeStartElement("suffix");
            writer.writeAttributeString("use", this.pathBuilder.useSuffix() ? "1" : "0");
            writer.writeString(this.pathBuilder.getSuffix());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("options");
            writer.writeAttributeString("sourceLanguage", this.sourceLanguage.toString());
            writer.writeAttributeString("sourceEncoding", this.sourceEncoding);
            writer.writeAttributeString("targetLanguage", this.targetLanguage.toString());
            writer.writeAttributeString("targetEncoding", this.targetEncoding);
            writer.writeEndElement();
            writer.writeStartElement("parametersFolder");
            writer.writeAttributeString("useCustom", this.useCustomParamsFolder ? "1" : "0");
            writer.writeString(this.customParamsFolder.replace('\\', '/'));
            writer.writeEndElement();
            writer.writeStartElement("utilities");
            writer.writeAttributeString("xml:spaces", "preserve");
            for (String utilityID : this.utilityParams.keySet()) {
                writer.writeStartElement("params");
                writer.writeAttributeString("id", utilityID);
                writer.writeString(this.utilityParams.get(utilityID));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            this.isModified = false;
            this.path = newPath;
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    private Element getFirstElement(Element parent, String name) {
        NodeList nl = parent.getElementsByTagName(name);
        if (nl == null || nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    public void load(String newPath) throws Exception {
        Element elem2;
        Element elem1;
        int i;
        DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
        Fact.setValidating(false);
        File file = new File(newPath);
        Document doc = Fact.newDocumentBuilder().parse(file);
        Element rootElem = doc.getDocumentElement();
        if (!rootElem.getNodeName().equals("rainbowProject")) {
            throw new Exception(String.format(Res.getString("Project.notProjectFile"), newPath));
        }
        String tmp = rootElem.getAttribute("version");
        if (!tmp.equals("4")) {
            throw new Exception(Res.getString("Project.unsupportedVersion"));
        }
        NodeList n1 = rootElem.getElementsByTagName("fileSet");
        for (i = 0; i < n1.getLength(); ++i) {
            elem1 = (Element)n1.item(i);
            elem2 = this.getFirstElement(elem1, "root");
            if (elem2 == null) {
                throw new Exception(Res.getString("Project.rootMissing"));
            }
            this.useCustomInputRoots.set(i, !elem2.getAttribute("useCustom").equals("0"));
            this.inputRoots.set(i, Util.getTextContent(elem2).replace('/', File.separatorChar));
            NodeList n2 = elem1.getElementsByTagName("fi");
            for (int j = 0; j < n2.getLength(); ++j) {
                elem2 = (Element)n2.item(j);
                Input item = new Input();
                item.filterConfigId = elem2.getAttribute("fs");
                item.format = elem2.getAttribute("fo");
                item.sourceEncoding = elem2.getAttribute("se");
                item.targetEncoding = elem2.getAttribute("te");
                item.relativePath = Util.getTextContent(elem2).replace('/', File.separatorChar);
                this.inputLists.get(i).add(item);
            }
        }
        elem1 = this.getFirstElement(rootElem, "output");
        if (elem1 == null) {
            throw new Exception(Res.getString("Project.outputMissing"));
        }
        elem2 = this.getFirstElement(elem1, "root");
        if (elem2 != null) {
            this.useOutputRoot = elem2.getAttribute("use").equals("1");
            this.outputRoot = Util.getTextContent(elem2).replace('/', File.separatorChar);
        }
        if ((elem2 = this.getFirstElement(elem1, "subFolder")) != null) {
            this.pathBuilder.setUseSubfolder(elem2.getAttribute("use").equals("1"));
            this.pathBuilder.setSubfolder(Util.getTextContent(elem2).replace('/', File.separatorChar));
        }
        if ((elem2 = this.getFirstElement(elem1, "extension")) != null) {
            this.pathBuilder.setUseExtension(elem2.getAttribute("use").equals("1"));
            int n = Integer.valueOf(elem2.getAttribute("style"));
            if (n < 0 || n > 2) {
                n = 2;
            }
            this.pathBuilder.setExtensionType(n);
            this.pathBuilder.setExtension(Util.getTextContent(elem2));
        }
        if ((elem2 = this.getFirstElement(elem1, "replace")) != null) {
            this.pathBuilder.setUseReplace(elem2.getAttribute("use").equals("1"));
            this.pathBuilder.setSearch(elem2.getAttribute("oldText").replace('/', File.separatorChar));
            this.pathBuilder.setReplace(elem2.getAttribute("newText").replace('/', File.separatorChar));
        }
        if ((elem2 = this.getFirstElement(elem1, "prefix")) != null) {
            this.pathBuilder.setUsePrefix(elem2.getAttribute("use").equals("1"));
            this.pathBuilder.setPrefix(Util.getTextContent(elem2));
        }
        if ((elem2 = this.getFirstElement(elem1, "suffix")) != null) {
            this.pathBuilder.setUseSuffix(elem2.getAttribute("use").equals("1"));
            this.pathBuilder.setSuffix(Util.getTextContent(elem2));
        }
        if ((elem1 = this.getFirstElement(rootElem, "options")) == null) {
            throw new Exception(Res.getString("Project.optionsMissing"));
        }
        this.sourceLanguage = LocaleId.fromString(elem1.getAttribute("sourceLanguage"));
        this.targetLanguage = LocaleId.fromString(elem1.getAttribute("targetLanguage"));
        this.sourceEncoding = elem1.getAttribute("sourceEncoding");
        this.targetEncoding = elem1.getAttribute("targetEncoding");
        elem1 = this.getFirstElement(rootElem, "parametersFolder");
        if (elem1 == null) {
            throw new Exception(Res.getString("Project.paramFolderMissing"));
        }
        this.useCustomParamsFolder = elem1.getAttribute("useCustom").equals("1");
        this.customParamsFolder = Util.getTextContent(elem1).replace('/', File.separatorChar);
        elem1 = this.getFirstElement(rootElem, "utilities");
        if (elem1 != null) {
            n1 = rootElem.getElementsByTagName("params");
            for (i = 0; i < n1.getLength(); ++i) {
                elem2 = (Element)n1.item(i);
                this.utilityParams.put(elem2.getAttribute("id"), Util.getTextContent(elem2));
            }
        }
        this.isModified = false;
        this.path = file.getAbsolutePath();
    }

    public void setInputRoot(int listIndex, String newRoot, boolean useCustom) {
        if (newRoot == null || newRoot.length() == 0) {
            useCustom = false;
        }
        if (useCustom) {
            if (!this.useCustomInputRoots.get(listIndex).booleanValue()) {
                this.isModified = true;
            }
            this.useCustomInputRoots.set(listIndex, true);
            if (!this.inputRoots.get(listIndex).equals(newRoot)) {
                if (!Util.validateVariables(newRoot, true, true, false)) {
                    throw new RuntimeException(Res.getString("MainForm.badVariables"));
                }
                this.inputRoots.set(listIndex, newRoot);
                this.isModified = true;
            }
        } else if (this.useCustomInputRoots.get(listIndex).booleanValue()) {
            this.useCustomInputRoots.set(listIndex, false);
            this.isModified = true;
        }
    }

    public String getInputRoot(int listIndex) {
        String rootDir;
        String string = rootDir = this.path == null ? System.getProperty("user.home") : Util.getDirectoryName(this.path);
        if (this.useCustomInputRoots.get(listIndex).booleanValue()) {
            try {
                return Util.expandPath(this.inputRoots.get(listIndex), rootDir, null);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return rootDir;
    }

    public String getRawInputRoot(int listIndex) {
        if (this.useCustomInputRoots.get(listIndex).booleanValue()) {
            return this.inputRoots.get(listIndex);
        }
        return this.getInputRoot(listIndex);
    }

    public String getInputRootDisplay(int listIndex) {
        if (this.useCustomInputRoots.get(listIndex).booleanValue()) {
            return Res.getString("Project.customPrefix") + this.inputRoots.get(listIndex);
        }
        return Res.getString("Project.autoPrefix") + (this.path == null ? System.getProperty("user.home") : Util.getDirectoryName(this.path));
    }

    public boolean useCustomeInputRoot(int listIndex) {
        return this.useCustomInputRoots.get(listIndex);
    }

    public void setUseOutputRoot(boolean value) {
        if (this.useOutputRoot != value) {
            this.useOutputRoot = value;
            this.isModified = true;
        }
    }

    public boolean getUseOutputRoot() {
        return this.useOutputRoot;
    }

    public void setOutputRoot(String newRoot) {
        if (!this.outputRoot.equals(newRoot)) {
            this.outputRoot = newRoot;
            this.isModified = true;
        }
    }

    public String getOutputRoot() {
        return this.outputRoot;
    }

    public void setSourceLanguage(LocaleId newLanguage) {
        if (!this.sourceLanguage.equals(newLanguage)) {
            this.sourceLanguage = newLanguage;
            this.isModified = true;
        }
    }

    public LocaleId getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceEncoding(String newEncoding) {
        if (!this.sourceEncoding.equals(newEncoding)) {
            this.sourceEncoding = newEncoding;
            this.isModified = true;
        }
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setTargetLanguage(LocaleId newLanguage) {
        if (!this.targetLanguage.equals(newLanguage)) {
            this.targetLanguage = newLanguage;
            this.isModified = true;
        }
    }

    public LocaleId getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetEncoding(String newEncoding) {
        if (!this.targetEncoding.equals(newEncoding)) {
            this.targetEncoding = newEncoding;
            this.isModified = true;
        }
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public void setCustomParametersFolder(String newParametersFolder) {
        File file = new File(newParametersFolder);
        if (!file.isAbsolute()) {
            newParametersFolder = file.getAbsolutePath();
        }
        if (!this.customParamsFolder.equals(newParametersFolder)) {
            this.customParamsFolder = newParametersFolder;
            this.isModified = true;
        }
    }

    public boolean useCustomParametersFolder() {
        return this.useCustomParamsFolder;
    }

    public void setUseCustomParametersFolder(boolean value) {
        if (this.useCustomParamsFolder != value) {
            this.useCustomParamsFolder = value;
            this.isModified = true;
        }
    }

    public String getParametersFolder() {
        return this.getParametersFolder(this.useCustomParamsFolder, false);
    }

    public String getParametersFolder(boolean displayMode) {
        return this.getParametersFolder(this.useCustomParamsFolder, displayMode);
    }

    public String getParametersFolder(boolean useCustom, boolean displayMode) {
        if (useCustom) {
            return this.customParamsFolder;
        }
        String prjFolder = this.path;
        String folder = "";
        if (prjFolder == null) {
            if (displayMode) {
                folder = Res.getString("Project.autoPrefix");
            }
            folder = folder + System.getProperty("user.home");
        } else {
            if (displayMode) {
                folder = Res.getString("Project.autoPrefix");
            }
            folder = folder + Util.getDirectoryName(prjFolder);
        }
        return folder;
    }

    public String buildTargetPath(int listIndex, String relativeSourcePath) {
        String inputRoot = this.getInputRoot(listIndex);
        return this.pathBuilder.getPath(inputRoot + File.separator + relativeSourcePath, inputRoot, this.useOutputRoot ? this.outputRoot : null, this.sourceLanguage.toString(), this.targetLanguage.toString());
    }

    public String buildRelativeTargetPath(int listIndex, String relativeSourcePath) {
        String inputRoot = this.getInputRoot(listIndex);
        String tmp = this.pathBuilder.getPath(inputRoot + File.separator + relativeSourcePath, inputRoot, this.useOutputRoot ? this.outputRoot : null, this.sourceLanguage.toString(), this.targetLanguage.toString());
        if (this.useOutputRoot) {
            return tmp.substring(inputRoot.length());
        }
        return tmp.substring(this.outputRoot.length());
    }

    public String buildOutputRoot(int listIndex) {
        if (this.useOutputRoot) {
            String out = this.outputRoot;
            if (this.pathBuilder.useSubfolder()) {
                out = out + File.separator + this.pathBuilder.getSubfolder();
            }
            return out;
        }
        return this.getInputRoot(listIndex);
    }

    public String buildSourceEncoding(Input item) {
        return item.sourceEncoding.length() == 0 ? this.sourceEncoding : item.sourceEncoding;
    }

    public String buildTargetEncoding(Input item) {
        return item.targetEncoding.length() == 0 ? this.targetEncoding : item.targetEncoding;
    }

    public String[] getInputPaths(int listIndex) {
        String[] inputs = new String[this.inputLists.get(listIndex).size()];
        int i = -1;
        for (Input item : this.inputLists.get(listIndex)) {
            inputs[++i] = this.getInputRoot(listIndex) + File.separator + item.relativePath;
        }
        return inputs;
    }

    public String getUtilityParameters(String utilityID) {
        if (!this.utilityParams.containsKey(utilityID)) {
            return "";
        }
        return this.utilityParams.get(utilityID);
    }

    public void setUtilityParameters(String utilityID, String parameters) {
        String prev = this.utilityParams.get(utilityID);
        if (Util.isEmpty(prev)) {
            this.isModified = true;
        } else if (!prev.equals(parameters)) {
            this.isModified = true;
        }
        this.utilityParams.put(utilityID, parameters);
    }

    public String getLastOutputFolder() {
        return this.lastOutputFolder;
    }

    public void setLastOutpoutFolder(String value) {
        this.lastOutputFolder = value;
    }

    public String getProjectFolder() {
        if (this.path == null) {
            return System.getProperty("user.home");
        }
        return Util.getDirectoryName(this.path);
    }

    public PathBuilder getPathBuilder() {
        return this.pathBuilder;
    }
}

