/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.packages.rtf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import net.sf.okapi.applications.rainbow.packages.BaseWriter;
import net.sf.okapi.applications.rainbow.packages.rtf.LayerProvider;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.ILayerProvider;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class Writer
extends BaseWriter {
    private static final String EXTENSION = ".rtf";
    private ISkeletonWriter skelWriter;
    private ILayerProvider layer;
    private PrintWriter writer;

    public void setSkeletonWriter(ISkeletonWriter skelWriter) {
        if (skelWriter == null) {
            throw new InvalidParameterException("You cannot use the RTF writer with no skeleton writer.\nThe filter you are trying to use may be incompatible with an RTF output.");
        }
        this.skelWriter = skelWriter;
        if (this.skelWriter instanceof GenericSkeletonWriter) {
            ((GenericSkeletonWriter)this.skelWriter).setReferentCopies(2);
        }
    }

    @Override
    public String getPackageType() {
        return "rtf";
    }

    @Override
    public String getReaderClass() {
        return "none";
    }

    @Override
    public void writeStartPackage() {
        this.manifest.setSourceLocation("work");
        this.manifest.setTargetLocation("work");
        this.manifest.setOriginalLocation("original");
        this.manifest.setDoneLocation("done");
        super.writeStartPackage();
    }

    @Override
    public void createOutput(int docID, String relativeSourcePath, String relativeTargetPath, String sourceEncoding, String targetEncoding, String filtersettings, IParameters filterParams, EncoderManager encoderManager) {
        this.encoderManager = encoderManager;
        this.relativeWorkPath = relativeSourcePath;
        this.relativeWorkPath = this.relativeWorkPath + EXTENSION;
        super.createOutput(docID, relativeSourcePath, relativeTargetPath, sourceEncoding, targetEncoding, filtersettings, filterParams);
        String path = this.manifest.getRoot() + File.separator + (this.manifest.getSourceLocation().length() == 0 ? "" : this.manifest.getSourceLocation() + File.separator) + this.relativeWorkPath;
        Util.createDirectories(path);
    }

    @Override
    public void close() {
        if (this.skelWriter != null) {
            this.skelWriter.close();
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        super.setOptions(locale, defaultEncoding);
        this.layer = new LayerProvider();
        this.layer.setOptions(null, this.encoding, null);
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public Event handleEvent(Event event) {
        try {
            switch (event.getEventType()) {
                case START_DOCUMENT: {
                    this.processStartDocument((StartDocument)event.getResource());
                    break;
                }
                case END_DOCUMENT: {
                    this.processEndDocument((Ending)event.getResource());
                    this.close();
                    break;
                }
                case START_SUBDOCUMENT: {
                    this.processStartSubDocument((StartSubDocument)event.getResource());
                    break;
                }
                case END_SUBDOCUMENT: {
                    this.processEndSubDocument((Ending)event.getResource());
                    break;
                }
                case START_GROUP: 
                case START_SUBFILTER: {
                    this.processStartGroup((StartGroup)event.getResource());
                    break;
                }
                case END_GROUP: 
                case END_SUBFILTER: {
                    this.processEndGroup((Ending)event.getResource());
                    break;
                }
                case TEXT_UNIT: {
                    this.processTextUnit(event.getTextUnit());
                    break;
                }
                case DOCUMENT_PART: {
                    this.processDocumentPart((DocumentPart)event.getResource());
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return event;
    }

    public IParameters getOptions() {
        return null;
    }

    public void setOptions(IParameters options) {
    }

    private void processStartDocument(StartDocument resource) {
        try {
            Util.createDirectories(this.outputPath);
            this.writer = new PrintWriter(this.outputPath, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.writer.write("{\\rtf1\\ansi\\ansicpg1252\\uc1\\deff1 \n{\\fonttbl \n{\\f1 \\fmodern\\fcharset0\\fprq1 Courier New;}\n{\\f2 \\fswiss\\fcharset0\\fprq2 Arial;}\n{\\f3 \\froman\\fcharset0\\fprq2 Times New Roman;}}\n{\\colortbl \\red0\\green0\\blue0;\\red0\\green0\\blue0;\\red0\\green0\\blue255;\\red0\\green255\\blue255;\\red0\\green255\\blue0;\\red255\\green0\\blue255;\\red255\\green0\\blue0;\\red255\\green255\\blue0;\\red255\\green255\\blue255;\\red0\\green0\\blue128;\\red0\\green128\\blue128;\\red0\\green128\\blue0;\\red128\\green0\\blue128;\\red128\\green0\\blue0;\\red128\\green128\\blue0;\\red128\\green128\\blue128;\\red192\\green192\\blue192;}\n{\\stylesheet \n{\\s0 \\sb80\\slmult1\\widctlpar\\fs20\\f1 \\snext0 Normal;}\n{\\cs1 \\additive \\v\\cf12\\sub\\f1 tw4winMark;}\n{\\cs2 \\additive \\cf4\\fs40\\f1 tw4winError;}\n{\\cs3 \\additive \\f1\\cf11 tw4winPopup;}\n{\\cs4 \\additive \\f1\\cf10 tw4winJump;}\n{\\cs5 \\additive \\cf15\\f1\\lang1024\\noproof tw4winExternal;}\n{\\cs6 \\additive \\cf6\\f1\\lang1024\\noproof tw4winInternal;}\n{\\cs7 \\additive \\cf2 tw4winTerm;}\n{\\cs8 \\additive \\cf13\\f1\\lang1024\\noproof DO_NOT_TRANSLATE;}\n{\\cs9 \\additive Default Paragraph Font;}{\\cs15 \\additive \\v\\f1\\cf12\\sub tw4winMark;}}\n\\paperw11907\\paperh16840\\viewkind4\\viewscale100\\pard\\plain\\s0\\sb80\\slmult1\\widctlpar\\fs20\\f1 \n{\\cs5\\f1\\cf15\\lang1024 ");
        this.writer.write(this.skelWriter.processStartDocument(this.trgLoc, this.encoding, this.layer, this.encoderManager, resource));
    }

    private void processEndDocument(Ending resource) {
        this.writer.write(this.skelWriter.processEndDocument(resource));
        this.writer.write("}}\n");
        this.writer.close();
        if (this.manifest != null) {
            this.manifest.addDocument(this.docID, this.relativeWorkPath, this.relativeSourcePath, this.relativeTargetPath, this.sourceEncoding, this.targetEncoding, this.filterID, "rtf");
        }
    }

    private void processStartSubDocument(StartSubDocument resource) throws IOException {
        this.writer.write(this.skelWriter.processStartSubDocument(resource));
    }

    private void processEndSubDocument(Ending resource) throws IOException {
        this.writer.write(this.skelWriter.processEndSubDocument(resource));
    }

    private void processStartGroup(StartGroup resource) throws IOException {
        this.writer.write(this.skelWriter.processStartGroup(resource));
    }

    private void processEndGroup(Ending resource) throws IOException {
        this.writer.write(this.skelWriter.processEndGroup(resource));
    }

    private void processTextUnit(ITextUnit tu) {
        super.writeTMXEntries(tu);
        this.writer.write(this.skelWriter.processTextUnit(tu));
    }

    private void processDocumentPart(DocumentPart resource) throws IOException {
        this.writer.write(this.skelWriter.processDocumentPart(resource));
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return this.skelWriter;
    }
}

