/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.packages;

import java.io.File;
import java.io.OutputStream;
import net.sf.okapi.applications.rainbow.packages.IWriter;
import net.sf.okapi.applications.rainbow.packages.Manifest;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public abstract class BaseWriter
implements IWriter {
    protected Manifest manifest = new Manifest();
    protected int docID;
    protected String inputRoot;
    protected String relativeWorkPath;
    protected String relativeSourcePath;
    protected String relativeTargetPath;
    protected String sourceEncoding;
    protected String targetEncoding;
    protected String filterID;
    protected TMXWriter tmxWriterApproved;
    protected String tmxPathApproved;
    protected TMXWriter tmxWriterUnApproved;
    protected String tmxPathUnApproved;
    protected TMXWriter tmxWriterAlternate;
    protected String tmxPathAlternate;
    protected TMXWriter tmxWriterLeverage;
    protected String tmxPathLeverage;
    protected LocaleId trgLoc;
    protected String encoding;
    protected String outputPath;
    protected boolean preSegmented;
    protected String creationTool;
    protected EncoderManager encoderManager;

    public BaseWriter() {
        this.manifest.setReaderClass(this.getReaderClass());
    }

    @Override
    public void cancel() {
    }

    @Override
    public void setInformation(LocaleId sourceLocale, LocaleId targetLocale, String projectID, String outputFolder, String packageID, String sourceRoot, boolean preSegmented, String creationTool) {
        this.manifest.setSourceLanguage(sourceLocale);
        this.trgLoc = targetLocale;
        this.manifest.setTargetLanguage(this.trgLoc);
        this.manifest.setProjectID(projectID);
        this.manifest.setRoot(outputFolder);
        this.manifest.setPackageID(packageID);
        this.manifest.setPackageType(this.getPackageType());
        this.inputRoot = sourceRoot;
        this.preSegmented = preSegmented;
        this.creationTool = creationTool;
    }

    public void setEncoderManager(EncoderManager encoderManager) {
        this.encoderManager = encoderManager;
    }

    @Override
    public void writeStartPackage() {
        Util.createDirectories(this.manifest.getRoot());
        String tmp = this.manifest.getSourceLocation();
        if (tmp != null && tmp.length() > 0) {
            Util.createDirectories(this.manifest.getRoot() + File.separator + tmp + File.separator);
        }
        if ((tmp = this.manifest.getTargetLocation()) != null && tmp.length() > 0) {
            Util.createDirectories(this.manifest.getRoot() + File.separator + tmp + File.separator);
        }
        if ((tmp = this.manifest.getOriginalLocation()) != null && tmp.length() > 0) {
            Util.createDirectories(this.manifest.getRoot() + File.separator + tmp + File.separator);
        }
        if (this.tmxPathApproved == null) {
            this.tmxPathApproved = this.manifest.getRoot() + File.separator + "approved.tmx";
        }
        this.tmxWriterApproved = new TMXWriter(this.tmxPathApproved);
        this.tmxWriterApproved.writeStartDocument(this.manifest.getSourceLanguage(), this.manifest.getTargetLanguage(), this.creationTool, null, null, null, null);
        if (this.tmxPathUnApproved == null) {
            this.tmxPathUnApproved = this.manifest.getRoot() + File.separator + "unapproved.tmx";
        }
        this.tmxWriterUnApproved = new TMXWriter(this.tmxPathUnApproved);
        this.tmxWriterUnApproved.writeStartDocument(this.manifest.getSourceLanguage(), this.manifest.getTargetLanguage(), this.creationTool, null, null, null, null);
        if (this.tmxPathAlternate == null) {
            this.tmxPathAlternate = this.manifest.getRoot() + File.separator + "alternate.tmx";
        }
        this.tmxWriterAlternate = new TMXWriter(this.tmxPathAlternate);
        this.tmxWriterAlternate.writeStartDocument(this.manifest.getSourceLanguage(), this.manifest.getTargetLanguage(), this.creationTool, null, null, null, null);
        this.tmxWriterAlternate.setAltTranslationOption("SourceDoc");
        if (this.tmxPathLeverage == null) {
            this.tmxPathLeverage = this.manifest.getRoot() + File.separator + "leverage.tmx";
        }
        this.tmxWriterLeverage = new TMXWriter(this.tmxPathLeverage);
        this.tmxWriterLeverage.writeStartDocument(this.manifest.getSourceLanguage(), this.manifest.getTargetLanguage(), this.creationTool, null, null, null, null);
    }

    @Override
    public void writeEndPackage(boolean createZip) {
        File file;
        if (this.manifest != null) {
            this.manifest.Save();
        }
        this.tmxWriterApproved.writeEndDocument();
        this.tmxWriterApproved.close();
        if (this.tmxWriterApproved.getItemCount() == 0) {
            file = new File(this.tmxPathApproved);
            file.delete();
        }
        this.tmxWriterUnApproved.writeEndDocument();
        this.tmxWriterUnApproved.close();
        if (this.tmxWriterUnApproved.getItemCount() == 0) {
            file = new File(this.tmxPathUnApproved);
            file.delete();
        }
        this.tmxWriterAlternate.writeEndDocument();
        this.tmxWriterAlternate.close();
        if (this.tmxWriterAlternate.getItemCount() == 0) {
            file = new File(this.tmxPathAlternate);
            file.delete();
        }
        this.tmxWriterLeverage.writeEndDocument();
        this.tmxWriterLeverage.close();
        if (this.tmxWriterLeverage.getItemCount() == 0) {
            file = new File(this.tmxPathLeverage);
            file.delete();
        }
        if (createZip && this.manifest != null) {
            FileUtil.zipDirectory(this.manifest.getRoot() + "/", null);
        }
    }

    public void createOutput(int docID, String relativeSourcePath, String relativeTargetPath, String sourceEncoding, String targetEncoding, String filterID, IParameters filterParams) {
        if (relativeSourcePath == null) {
            throw new NullPointerException();
        }
        if (relativeTargetPath == null) {
            throw new NullPointerException();
        }
        if (sourceEncoding == null) {
            throw new NullPointerException();
        }
        if (targetEncoding == null) {
            throw new NullPointerException();
        }
        if (filterID == null) {
            throw new NullPointerException();
        }
        this.docID = docID;
        this.relativeSourcePath = relativeSourcePath;
        this.relativeTargetPath = relativeTargetPath;
        this.sourceEncoding = sourceEncoding;
        this.targetEncoding = targetEncoding;
        this.filterID = filterID;
        String subFolder = this.manifest.getOriginalLocation();
        if (subFolder == null || subFolder.length() == 0) {
            return;
        }
        String inputPath = this.inputRoot + File.separator + relativeSourcePath;
        String docPrefix = String.format("%d.", docID);
        String destination = this.manifest.getRoot() + File.separator + subFolder + File.separator + docPrefix + "ori";
        StreamUtil.copy(inputPath, destination, false);
        String paramsCopy = this.manifest.getRoot() + File.separator + subFolder + File.separator + docPrefix + "fprm";
        if (filterParams != null) {
            filterParams.save(paramsCopy);
        }
        String outputPath = this.manifest.getRoot() + File.separator + (this.manifest.getSourceLocation().length() == 0 ? "" : this.manifest.getSourceLocation() + File.separator) + this.relativeWorkPath;
        this.setOptions(this.trgLoc, targetEncoding);
        this.setOutput(outputPath);
    }

    @Override
    public void createCopies(int docID, String relativeSourcePath) {
        if (relativeSourcePath == null) {
            throw new NullPointerException();
        }
        String inputPath = this.inputRoot + File.separator + relativeSourcePath;
        String outputPath = this.manifest.getRoot() + File.separator + (this.manifest.getSourceLocation().length() == 0 ? "" : this.manifest.getSourceLocation() + File.separator) + relativeSourcePath;
        String subFolder = this.manifest.getOriginalLocation();
        if (subFolder != null && subFolder.length() > 0) {
            String docPrefix = String.format("%d.", docID);
            String destination = this.manifest.getRoot() + File.separator + subFolder + File.separator + docPrefix + "ori";
            StreamUtil.copy(inputPath, destination, false);
        }
        Util.createDirectories(outputPath);
        StreamUtil.copy(inputPath, outputPath, false);
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTMXEntries(ITextUnit tu) {
        TextContainer tc = tu.getTarget(this.trgLoc);
        if (tc == null || tc.isEmpty()) {
            return;
        }
        if (tu.getSource().isEmpty() || tu.getSource().hasText(false) && !tc.hasText(false)) {
            return;
        }
        boolean done = false;
        if (tu.hasTargetProperty(this.trgLoc, "approved") && tu.getTargetProperty(this.trgLoc, "approved").getValue().equals("yes")) {
            this.tmxWriterApproved.writeItem(tu, null);
            done = true;
        }
        if (!done) {
            this.tmxWriterUnApproved.writeItem(tu, null);
        }
        TextContainer altCont = tu.getTarget(this.trgLoc);
        ISegments srcSegs = tu.getSource().getSegments();
        for (Segment seg : altCont.getSegments()) {
            Segment srcSeg = srcSegs.get(seg.id);
            if (srcSeg == null) continue;
            this.writeAltTranslations(seg.getAnnotation(AltTranslationsAnnotation.class), srcSeg.text);
        }
        TextFragment srcOriginal = tu.getSource().contentIsOneSegment() ? tu.getSource().getFirstContent() : tu.getSource().getUnSegmentedContentCopy();
        this.writeAltTranslations(altCont.getAnnotation(AltTranslationsAnnotation.class), srcOriginal);
        this.writeScoredItem(tu);
    }

    private void writeAltTranslations(AltTranslationsAnnotation ann, TextFragment srcOriginal) {
        if (ann == null) {
            return;
        }
        for (AltTranslation alt : ann) {
            if (alt.getFromOriginal()) {
                this.tmxWriterAlternate.writeAlternate(alt, srcOriginal);
                continue;
            }
            this.tmxWriterLeverage.writeAlternate(alt, srcOriginal);
        }
    }

    @Override
    public void writeScoredItem(ITextUnit item) {
    }
}

