/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.RenumberingUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filterwriter.TMXContent;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class TMXWriter {
    private static final String ATTR_NAMES = ";lang;tuid;o-encoding;datatype;usagecount;lastusagedate;creationtool;creationtoolversion;creationdate;creationid;changedate;segtype;changeid;o-tmf;srclang;";
    private static final String CREATIONID = "creationid";
    private static final String FROMALTERNATE = "FromAlternate!";
    private XMLWriter writer;
    private TMXContent tmxCont = new TMXContent();
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private int itemCount;
    private Pattern exclusionPattern = null;
    private Pattern altTransInclusionPattern = null;
    private Hashtable<String, String> mtAttribute;
    private Hashtable<String, String> altAttribute;
    private boolean useMTPrefix = true;
    private boolean writeAllPropertiesAsAttributes;
    private boolean expandDuplicateProps = false;
    private String propValueSep = ", ";
    private boolean generateUUID = false;
    private boolean normalizeCodeIds = false;

    public TMXWriter(String path) {
        this.setPath(path);
    }

    public TMXWriter(XMLWriter writer) {
        this.setXmlWriter(writer);
    }

    protected void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must be set");
        }
        this.setWriteAllPropertiesAsAttributes(false);
        this.writer = new XMLWriter(path);
        this.mtAttribute = new Hashtable();
        this.mtAttribute.put(CREATIONID, "MT!");
        this.altAttribute = new Hashtable();
        this.altAttribute.put(CREATIONID, FROMALTERNATE);
    }

    protected void setXmlWriter(XMLWriter writer) {
        this.setWriteAllPropertiesAsAttributes(false);
        this.writer = writer;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setTradosWorkarounds(boolean value) {
        this.tmxCont.setTradosWorkarounds(value);
    }

    public void setLetterCodedMode(boolean value, boolean zeroBased) {
        this.tmxCont.setLetterCodedMode(value, zeroBased);
    }

    public void setExclusionOption(String pattern) {
        this.exclusionPattern = Util.isEmpty(pattern) ? null : Pattern.compile(pattern);
    }

    public void setAltTranslationOption(String pattern) {
        this.altTransInclusionPattern = Util.isEmpty(pattern) ? null : Pattern.compile(pattern);
    }

    public void setQuoteMode(int quoteMode) {
        this.tmxCont.setQuoteMode(quoteMode);
    }

    public void setUseMTPrefix(boolean useMTPrefix) {
        this.useMTPrefix = useMTPrefix;
    }

    public void writeStartDocument(LocaleId sourceLocale, LocaleId targetLocale, String creationTool, String creationToolVersion, String segType, String originalTMFormat, String dataType) {
        if (sourceLocale == null) {
            throw new NullPointerException("sourceLocale null");
        }
        if (targetLocale == null) {
            throw new NullPointerException("targetLocale null");
        }
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        if (this.tmxCont.getLetterCodedMode()) {
            creationTool = "OmegaT";
        }
        this.writer.writeStartDocument();
        this.writer.writeStartElement("tmx");
        this.writer.writeAttributeString("version", "1.4");
        this.writer.writeStartElement("header");
        this.writer.writeAttributeString("creationtool", creationTool == null ? "unknown" : creationTool);
        this.writer.writeAttributeString("creationtoolversion", creationToolVersion == null ? "unknown" : creationToolVersion);
        this.writer.writeAttributeString("segtype", segType == null ? "paragraph" : segType);
        this.writer.writeAttributeString("o-tmf", originalTMFormat == null ? "unknown" : originalTMFormat);
        this.writer.writeAttributeString("adminlang", "en");
        this.writer.writeAttributeString("srclang", this.srcLoc.toBCP47());
        this.writer.writeAttributeString("datatype", dataType == null ? "unknown" : dataType);
        this.writer.writeEndElement();
        this.writer.writeStartElement("body");
        this.writer.writeLineBreak();
    }

    public void writeEndDocument() {
        this.writer.writeEndElementLineBreak();
        this.writer.writeEndElementLineBreak();
        this.writer.writeEndDocument();
    }

    public void writeItem(ITextUnit tu, Map<String, String> attributes) {
        if (!tu.hasTarget(this.trgLoc)) {
            return;
        }
        ISegments srcSegs = tu.getSourceSegments();
        ISegments trgSegs = tu.getTargetSegments(this.trgLoc);
        String tuId = tu.getId();
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = trgSegs.get(srcSeg.id);
            if (trgSeg == null || trgSeg.text.isEmpty()) continue;
            this.writeTU(srcSeg.text, trgSeg.text, String.format("%s_s%s", tuId, srcSeg.id), attributes);
        }
    }

    public void writeAlternates(ITextUnit tu, LocaleId trgLoc) {
        TextContainer tc = tu.getTarget(trgLoc);
        if (tc == null) {
            return;
        }
        if (!tc.hasBeenSegmented()) {
            AltTranslationsAnnotation atAnn = tc.getAnnotation(AltTranslationsAnnotation.class);
            if (atAnn != null) {
                for (AltTranslation at : atAnn) {
                    TextFragment trgFrag;
                    TextFragment srcFrag = at.getSource().getFirstContent();
                    if (srcFrag.isEmpty()) {
                        srcFrag = tu.getSource().getFirstContent();
                    }
                    if ((trgFrag = at.getTarget().getFirstContent()).isEmpty()) continue;
                    this.writeTU(srcFrag, trgFrag, null, null, trgLoc);
                }
            }
            return;
        }
        for (Segment seg : tc.getSegments()) {
            AltTranslationsAnnotation atAnn = seg.getAnnotation(AltTranslationsAnnotation.class);
            if (atAnn == null) continue;
            for (AltTranslation at : atAnn) {
                TextFragment trgFrag;
                TextFragment srcFrag = at.getSource().getFirstContent();
                if (srcFrag.isEmpty()) {
                    Segment srcSeg = tu.getSource().getSegments().get(seg.id);
                    if (srcSeg == null) continue;
                    srcFrag = srcSeg.text;
                }
                if ((trgFrag = at.getTarget().getFirstContent()).isEmpty()) continue;
                this.writeTU(srcFrag, trgFrag, null, null, trgLoc);
            }
        }
    }

    public void writeAlternate(AltTranslation alt, TextFragment srcOriginal) {
        TextFragment srcFrag;
        if (this.altTransInclusionPattern != null) {
            String ori = alt.getOrigin();
            if (ori == null) {
                ori = "";
            }
            if (!this.altTransInclusionPattern.matcher(ori).matches()) {
                return;
            }
        }
        if ((srcFrag = alt.getSource().getFirstContent()).isEmpty()) {
            srcFrag = srcOriginal;
        }
        if (this.useMTPrefix && alt.fromMT() && !srcFrag.getCodedText().startsWith("MT!")) {
            srcFrag = srcFrag.clone();
            srcFrag.setCodedText("MT! " + srcFrag.getCodedText());
        }
        TextFragment trgFrag = alt.getTarget().getFirstContent();
        this.writeTU(srcFrag, trgFrag, null, alt.fromMT() ? this.mtAttribute : (alt.getFromOriginal() ? this.altAttribute : null), alt.getTargetLocale());
    }

    public void writeTU(TextFragment source, TextFragment target, String tuid, Map<String, String> attributes) {
        this.writeTU(source, target, tuid, attributes, null);
    }

    public void writeTU(TextFragment source, TextFragment target, String tuid, Map<String, String> attributes, LocaleId altTrgLoc) {
        if (this.exclusionPattern != null && this.exclusionPattern.matcher(source.getCodedText()).matches()) {
            return;
        }
        ++this.itemCount;
        this.writer.writeStartElement("tu");
        if (!Util.isEmpty(tuid)) {
            this.writer.writeAttributeString("tuid", tuid);
        }
        this.writer.writeLineBreak();
        if (attributes != null && attributes.size() > 0) {
            for (String name : attributes.keySet()) {
                if (ATTR_NAMES.contains(";" + name + ";")) continue;
                this.writer.writeStartElement("prop");
                this.writer.writeAttributeString("type", name);
                this.writer.writeString(attributes.get(name));
                this.writer.writeEndElementLineBreak();
            }
        }
        this.writer.writeStartElement("tuv");
        this.writer.writeAttributeString("xml:lang", this.srcLoc.toBCP47());
        this.writer.writeStartElement("seg");
        this.writer.writeRawXML(this.tmxCont.setContent(source).toString());
        this.writer.writeEndElement();
        this.writer.writeEndElementLineBreak();
        if (target != null) {
            this.writer.writeStartElement("tuv");
            this.writer.writeAttributeString("xml:lang", altTrgLoc != null ? altTrgLoc.toBCP47() : this.trgLoc.toBCP47());
            if (attributes != null && attributes.containsKey(CREATIONID)) {
                this.writer.writeAttributeString(CREATIONID, attributes.get(CREATIONID));
            }
            this.writer.writeStartElement("seg");
            this.writer.writeRawXML(this.tmxCont.setContent(target).toString());
            this.writer.writeEndElement();
            this.writer.writeEndElementLineBreak();
        }
        this.writer.writeEndElementLineBreak();
    }

    public void writeTUFull(ITextUnit item) {
        this.writeTUFull(item, this.srcLoc);
    }

    public void writeTUFull(ITextUnit item, LocaleId sourceLocId) {
        String tuid;
        if (item == null) {
            throw new NullPointerException();
        }
        ++this.itemCount;
        if (this.generateUUID) {
            tuid = UUID.randomUUID().toString();
        } else {
            tuid = item.getName();
            if (Util.isEmpty(tuid)) {
                tuid = String.format("autoID%d", this.itemCount);
            }
        }
        IAlignedSegments alignedSegments = item.getAlignedSegments();
        TextContainer srcCont = item.getVariantSources().get(this.trgLoc);
        Set<LocaleId> locales = item.getTargetLocales();
        Set<String> names = item.getPropertyNames();
        if (srcCont.isEmpty()) {
            boolean nothingToWrite = true;
            for (LocaleId loc : locales) {
                TextContainer trgCont = item.getTarget(loc);
                if (trgCont.isEmpty()) continue;
                nothingToWrite = false;
            }
            if (nothingToWrite) {
                return;
            }
        }
        Iterator<Segment> variantSegments = alignedSegments.iterator(this.trgLoc);
        if (this.normalizeCodeIds) {
            RenumberingUtil.renumberTextUnitCodes(item, this.trgLoc);
        }
        while (variantSegments.hasNext()) {
            Segment srcSeg = variantSegments.next();
            this.writer.writeStartElement("tu");
            if (srcCont.contentIsOneSegment()) {
                this.writer.writeAttributeString("tuid", tuid);
            } else {
                this.writer.writeAttributeString("tuid", String.format("%s_%s", tuid, srcSeg.id));
            }
            if (this.isWriteAllPropertiesAsAttributes()) {
                this.writeAllPropertiesAsAttibutes(this.writer, names, item);
            }
            this.writer.writeLineBreak();
            this.writeResourceLevelProperties(names, item, srcSeg.text);
            this.writeTUV(srcSeg.text, sourceLocId, srcCont);
            for (LocaleId loc : locales) {
                Segment trgSeg = null;
                TextContainer trgCont = item.getTarget(loc);
                trgSeg = alignedSegments.getCorrespondingTarget(srcSeg, loc);
                if (trgSeg == null || trgSeg.text.isEmpty()) continue;
                this.writeTUV(trgSeg.text, loc, trgCont);
            }
            this.writer.writeEndElementLineBreak();
            this.writer.flush();
        }
    }

    protected void writeResourceLevelProperties(Set<String> names, ITextUnit item, TextFragment srcSegment) {
        for (String name : names) {
            if (ATTR_NAMES.contains(";" + name + ";")) continue;
            this.writeProp(name, item.getProperty(name).getValue());
        }
    }

    protected void writeProp(String name, String value) {
        if (this.expandDuplicateProps) {
            StringTokenizer st = new StringTokenizer(value, this.propValueSep, false);
            while (st.hasMoreTokens()) {
                this.writer.writeStartElement("prop");
                this.writer.writeAttributeString("type", name);
                this.writer.writeString(st.nextToken());
                this.writer.writeEndElementLineBreak();
            }
        } else {
            this.writer.writeStartElement("prop");
            this.writer.writeAttributeString("type", name);
            this.writer.writeString(value);
            this.writer.writeEndElementLineBreak();
        }
    }

    protected void writeAllPropertiesAsAttibutes(XMLWriter writer, Set<String> names, ITextUnit item) {
        for (String name : names) {
            if (!ATTR_NAMES.contains(";" + name + ";") || name.equals("tuid")) continue;
            writer.writeAttributeString(name, item.getProperty(name).getValue());
        }
    }

    protected void writeAllPropertiesAsAttibutes(XMLWriter writer, Set<String> names, TextContainer item) {
        for (String name : names) {
            if (!ATTR_NAMES.contains(";" + name + ";") || name.equals("tuid")) continue;
            writer.writeAttributeString(name, item.getProperty(name).getValue());
        }
    }

    protected void writeTUV(TextFragment frag, LocaleId locale, TextContainer contForProp) {
        this.writer.writeStartElement("tuv");
        this.writer.writeAttributeString("xml:lang", locale.toBCP47());
        if (this.isWriteAllPropertiesAsAttributes() && contForProp != null) {
            Set<String> names = contForProp.getPropertyNames();
            names.remove("lang");
            this.writeAllPropertiesAsAttibutes(this.writer, names, contForProp);
        }
        if (!this.isWriteAllPropertiesAsAttributes() && contForProp != null) {
            boolean propWritten = false;
            Set<String> names = contForProp.getPropertyNames();
            for (String name : names) {
                if (ATTR_NAMES.contains(";" + name + ";")) continue;
                this.writer.writeLineBreak();
                this.writer.writeStartElement("prop");
                this.writer.writeAttributeString("type", name);
                this.writer.writeString(contForProp.getProperty(name).getValue());
                this.writer.writeEndElement();
                propWritten = true;
            }
            if (propWritten) {
                this.writer.writeLineBreak();
            }
        }
        this.writer.writeStartElement("seg");
        this.writer.writeRawXML(this.tmxCont.setContent(frag).toString());
        this.writer.writeEndElement();
        this.writer.writeEndElementLineBreak();
    }

    public void setWriteAllPropertiesAsAttributes(boolean writeAllPropertiesAsAttributes) {
        this.writeAllPropertiesAsAttributes = writeAllPropertiesAsAttributes;
    }

    public boolean isWriteAllPropertiesAsAttributes() {
        return this.writeAllPropertiesAsAttributes;
    }

    public void setExpandDuplicateProps(boolean expandDuplicateProps) {
        this.expandDuplicateProps = expandDuplicateProps;
    }

    public void setPropValueSep(String propValueSep) {
        this.propValueSep = propValueSep;
    }

    public void setGenerateUUID(boolean generateUUID) {
        this.generateUUID = generateUUID;
    }

    public void setNormalizeCodeIds(boolean normalizeCodeIds) {
        this.normalizeCodeIds = normalizeCodeIds;
    }

    public LocaleId getSrcLoc() {
        return this.srcLoc;
    }

    public void setSrcLoc(LocaleId srcLoc) {
        this.srcLoc = srcLoc;
    }

    public LocaleId getTrgLoc() {
        return this.trgLoc;
    }

    public void setTrgLoc(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }
}

