/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupEventBuilder;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.properties.Parameters;
import net.sf.okapi.filters.properties.Res;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class PropertiesFilter
implements IFilter {
    private static final int RESULT_END = 0;
    private static final int RESULT_ITEM = 1;
    private static final int RESULT_DATA = 2;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private BufferedReader reader;
    private boolean canceled;
    private String encoding;
    private ITextUnit tuRes;
    private LinkedList<Event> queue;
    private String textLine;
    private long lineSince;
    private long position;
    private int tuId;
    private Pattern keyConditionPattern;
    private String lineBreak;
    private int parseState = 0;
    private GenericSkeleton skel;
    private String docName;
    private boolean hasUTF8BOM;
    private EncoderManager encoderManager;
    private LocaleId srcLocale;
    private IFilter sf;
    private IFilterConfigurationMapper fcMapper;
    private int sectionIndex;
    private RawDocument input;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
                this.docName = null;
            }
            this.parseState = 0;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_properties";
    }

    @Override
    public String getDisplayName() {
        return "Properties Filter";
    }

    @Override
    public String getMimeType() {
        return "text/x-properties";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/x-properties", this.getClass().getName(), "Java Properties", "Java properties files (Output used \\uHHHH escapes)", null, ".properties;"));
        list.add(new FilterConfiguration(this.getName() + "-outputNotEscaped", "text/x-properties", this.getClass().getName(), "Java Properties (Output not escaped)", "Java properties files (Characters in the output encoding are not escaped)", "outputNotEscaped.fprm"));
        list.add(new FilterConfiguration(this.getName() + "-skypeLang", "text/x-properties", this.getClass().getName(), "Skype Language Files", "Skype language properties files (including support for HTML codes)", "skypeLang.fprm", ".lang;"));
        list.add(new FilterConfiguration(this.getName() + "-html-subfilter", "text/x-properties", this.getClass().getName(), "Properties with complex HTML Content", "Java Property content processed by an HTML subfilter", "html-subfilter.fprm"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.parseState > 0;
    }

    @Override
    public Event next() {
        int n;
        if (this.canceled) {
            this.parseState = 0;
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
        }
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        boolean resetBuffer = true;
        do {
            n = this.readItem(resetBuffer);
            switch (n) {
                case 2: {
                    resetBuffer = false;
                    break;
                }
                case 1: {
                    if (this.sf != null) {
                        this.processWithSubfilter(this.tuRes.getName(), this.tuRes);
                        return this.queue.poll();
                    }
                    return new Event(EventType.TEXT_UNIT, this.tuRes);
                }
                default: {
                    resetBuffer = true;
                }
            }
        } while (n > 0);
        Ending ending = new Ending("ed");
        ending.setSkeleton(this.skel);
        this.parseState = 0;
        return new Event(EventType.END_DOCUMENT, ending);
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.parseState = 1;
        this.canceled = false;
        this.srcLocale = input.getSourceLocale();
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        this.encoding = input.getEncoding();
        try {
            this.reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.encoding), e);
        }
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        this.tuId = 0;
        this.sectionIndex = 0;
        this.lineSince = 0L;
        this.position = 0L;
        this.keyConditionPattern = this.params.isUseKeyCondition() ? Pattern.compile(this.params.getKeyCondition()) : null;
        if (this.params.isUseCodeFinder()) {
            this.params.codeFinder.compile();
        }
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument("sd");
        startDoc.setName(this.docName);
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLocale(input.getSourceLocale());
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setType("text/x-properties");
        startDoc.setMimeType("text/x-properties");
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        if (!Util.isEmpty(this.params.getSubfilter())) {
            this.sf = this.fcMapper.createFilter(this.params.getSubfilter(), this.sf);
            if (this.sf == null) {
                throw new OkapiBadFilterInputException("Unkown subfilter: " + this.params.getSubfilter());
            }
        }
    }

    private int readItem(boolean resetBuffer) {
        try {
            if (resetBuffer) {
                this.skel = new GenericSkeleton();
            }
            StringBuilder keyBuffer = new StringBuilder();
            StringBuilder textBuffer = new StringBuilder();
            String value = "";
            String key = "";
            String note = "";
            boolean isMultiline = false;
            int startText = 0;
            long lS = -1L;
            while (true) {
                if (!this.getNextLine()) {
                    return 0;
                }
                String tmp = Util.trimStart(this.textLine, "\t\r\n \f");
                if (isMultiline) {
                    value = value + tmp;
                } else {
                    boolean isComment;
                    if (tmp.length() == 0) {
                        this.skel.append(this.textLine);
                        this.skel.append(this.lineBreak);
                        continue;
                    }
                    boolean bl = isComment = tmp.charAt(0) == '#' || tmp.charAt(0) == '!';
                    if (isComment) {
                        tmp = tmp.substring(1);
                    }
                    if (this.params.isExtraComments() && !isComment) {
                        if (tmp.charAt(0) == ';') {
                            isComment = true;
                            tmp = tmp.substring(1);
                        } else if (tmp.startsWith("//")) {
                            isComment = true;
                            tmp = tmp.substring(2);
                        }
                    }
                    if (isComment) {
                        this.params.locDir.process(tmp);
                        this.skel.append(this.textLine);
                        this.skel.append(this.lineBreak);
                        if (!this.params.isCommentsAreNotes()) continue;
                        if (note.length() > 0) {
                            note = note + "\n";
                        }
                        note = note + tmp;
                        continue;
                    }
                    boolean bEscape = false;
                    int n = 0;
                    for (int i = 0; i < tmp.length(); ++i) {
                        if (bEscape) {
                            bEscape = false;
                            continue;
                        }
                        if (tmp.charAt(i) == '\\') {
                            bEscape = true;
                            continue;
                        }
                        if (tmp.charAt(i) != ':' && tmp.charAt(i) != '=' && !Character.isWhitespace(tmp.charAt(i))) continue;
                        n = i;
                        break;
                    }
                    if (n == 0) {
                        n = tmp.length();
                    }
                    key = tmp.substring(0, n);
                    boolean bEmpty = true;
                    boolean bCheckEqual = true;
                    for (int i = n; i < tmp.length(); ++i) {
                        if (bCheckEqual && (tmp.charAt(i) == ':' || tmp.charAt(i) == '=')) {
                            bCheckEqual = false;
                            continue;
                        }
                        if (Character.isWhitespace(tmp.charAt(i))) continue;
                        n = i;
                        bEmpty = false;
                        break;
                    }
                    if (bEmpty) {
                        n = tmp.length();
                    }
                    value = tmp.substring(n);
                    startText = n + (this.textLine.length() - tmp.length());
                    lS = this.position - ((long)this.textLine.length() + (this.lineSince - 1L)) + (long)startText;
                    this.lineSince = 0L;
                }
                if (!value.endsWith("\\")) break;
                int n = 0;
                for (int i = value.length() - 1; i > -1 && value.charAt(i) == '\\'; --i) {
                    ++n;
                }
                if (n % 2 == 0) break;
                value = value.substring(0, value.length() - 1);
                isMultiline = true;
                if (keyBuffer.length() == 0) {
                    keyBuffer.append(this.textLine.substring(0, startText));
                    startText = 0;
                }
                textBuffer.append(this.textLine.substring(startText));
            }
            boolean extract = true;
            if (this.params.locDir.isWithinScope()) {
                extract = this.params.locDir.isLocalizable(true);
            } else if (this.keyConditionPattern != null) {
                if (this.params.isExtractOnlyMatchingKey()) {
                    if (!this.keyConditionPattern.matcher(key).matches()) {
                        extract = false;
                    }
                } else if (this.keyConditionPattern.matcher(key).matches()) {
                    extract = false;
                }
            } else {
                extract = this.params.locDir.localizeOutside();
            }
            if (extract) {
                this.tuRes = new TextUnit(String.valueOf(++this.tuId), this.unescape(value));
                this.tuRes.setName(key);
                this.tuRes.setMimeType("text/x-properties");
                this.tuRes.setPreserveWhitespaces(true);
                if (note.length() > 0) {
                    this.tuRes.setProperty(new Property("note", note, true));
                }
            }
            if (extract) {
                if (keyBuffer.length() == 0) {
                    keyBuffer.append(this.textLine.substring(0, startText));
                }
            } else {
                this.skel.append(keyBuffer.toString());
                this.skel.append(textBuffer.toString());
                this.skel.append(this.textLine);
                this.skel.append(this.lineBreak);
                return 2;
            }
            this.skel.append(keyBuffer.toString());
            this.skel.addContentPlaceholder(this.tuRes, null);
            this.skel.append(this.lineBreak);
            if (this.params.isUseCodeFinder() && this.sf == null) {
                this.params.codeFinder.process(this.tuRes.getSource().getFirstContent());
            }
            this.tuRes.setSkeleton(this.skel);
            this.tuRes.setSourceProperty(new Property("start", String.valueOf(lS), true));
            return 1;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean getNextLine() throws IOException {
        this.textLine = this.reader.readLine();
        if (this.textLine != null) {
            ++this.lineSince;
            this.position += (long)(this.textLine.length() + this.lineBreak.length());
        }
        return this.textLine != null;
    }

    private String unescape(String text) {
        if (text.indexOf(92) == -1) {
            return text;
        }
        StringBuilder tmpText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\\') {
                switch (text.charAt(i + 1)) {
                    case 'u': {
                        if (i + 5 < text.length()) {
                            try {
                                int nTmp = Integer.parseInt(text.substring(i + 2, i + 6), 16);
                                tmpText.append((char)nTmp);
                            }
                            catch (Exception e) {
                                this.logger.warn(Res.getString("INVALID_UESCAPE"), (Object)text.substring(i + 2, i + 6));
                            }
                            i += 5;
                            break;
                        }
                        this.logger.warn(Res.getString("INVALID_UESCAPE"), (Object)text.substring(i + 2));
                        break;
                    }
                    case 'n': {
                        if (this.params.isConvertLFandTab()) {
                            tmpText.append("\n");
                        } else {
                            tmpText.append("\\n");
                        }
                        ++i;
                        break;
                    }
                    case 't': {
                        if (this.params.isConvertLFandTab()) {
                            tmpText.append("\t");
                        } else {
                            tmpText.append("\\t");
                        }
                        ++i;
                        break;
                    }
                    default: {
                        tmpText.append("\\" + text.charAt(++i));
                        break;
                    }
                }
                continue;
            }
            tmpText.append(text.charAt(i));
        }
        return tmpText.toString();
    }

    private void processWithSubfilter(String parentId, ITextUnit parentTu) {
        if (this.encoderManager != null) {
            this.encoderManager.setDefaultOptions(this.params, this.encoding, this.lineBreak);
            this.encoderManager.updateEncoder("text/x-properties");
        }
        SubFilter subfilter = new SubFilter(this.sf, this.encoderManager.getEncoder(), ++this.sectionIndex, parentId, parentTu.getName());
        subfilter.open(new RawDocument(parentTu.getSource().toString(), this.srcLocale));
        if (this.sf.getName().startsWith("okf_html") || this.sf.getName().startsWith("okf_xmlstream")) {
            AbstractMarkupEventBuilder eb = (AbstractMarkupEventBuilder)((AbstractMarkupFilter)this.sf).getEventBuilder();
            eb.initializeCodeFinder(this.params.isUseCodeFinder(), this.params.getCodeFinder().getRules());
        }
        while (subfilter.hasNext()) {
            Event e = subfilter.next();
            this.queue.add(e);
        }
        subfilter.close();
        this.queue.add(subfilter.createRefEvent(parentTu));
    }
}

