/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import com.ibm.icu.text.RuleBasedBreakIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.exceptions.OkapiException;

class Placeholder {
    static final char GRAPHEME_CLUSTER = '\ue010';
    static final char WORD_BOUNDARY = '\ue011';
    static final char WORD_NON_BOUNDARY = '\ue012';
    static final char START_BEFORE = '\ue013';
    static final char END_BEFORE = '\ue014';
    static final char START_AFTER = '\ue015';
    static final char END_AFTER = '\ue016';
    static final char BASE = '\ue020';
    static final String AREA_MARKERS = String.format("[%s%s%s%s]", Character.valueOf('\ue013'), Character.valueOf('\ue014'), Character.valueOf('\ue015'), Character.valueOf('\ue016'));
    private static final String GC_RBBI_RULES = "$CR          = [\\p{Grapheme_Cluster_Break = CR}];$LF          = [\\p{Grapheme_Cluster_Break = LF}];$Control     = [\\p{Grapheme_Cluster_Break = Control}];$Extend      = [\\p{Grapheme_Cluster_Break = Extend}];$SpacingMark = [\\p{Grapheme_Cluster_Break = SpacingMark}];$L       = [\\p{Grapheme_Cluster_Break = L}];$V       = [\\p{Grapheme_Cluster_Break = V}];$T       = [\\p{Grapheme_Cluster_Break = T}];$LV      = [\\p{Grapheme_Cluster_Break = LV}];$LVT     = [\\p{Grapheme_Cluster_Break = LVT}];!!chain;!!forward;$CR $LF;$L ($L | $V | $LV | $LVT) {700};($LV | $V) ($V | $T) {700};($LVT | $T) $T {700};[^$Control $CR $LF] $Extend {700};[^$Control $CR $LF] $SpacingMark {700};!!reverse;!!safe_reverse;!!safe_forward;";
    private static final String RBBI_RULES = "!!chain;!!forward;%s{%d};!!reverse;!!safe_reverse;!!safe_forward;";
    private static final RuleBasedBreakIterator GC_RBBI = new RuleBasedBreakIterator("$CR          = [\\p{Grapheme_Cluster_Break = CR}];$LF          = [\\p{Grapheme_Cluster_Break = LF}];$Control     = [\\p{Grapheme_Cluster_Break = Control}];$Extend      = [\\p{Grapheme_Cluster_Break = Extend}];$SpacingMark = [\\p{Grapheme_Cluster_Break = SpacingMark}];$L       = [\\p{Grapheme_Cluster_Break = L}];$V       = [\\p{Grapheme_Cluster_Break = V}];$T       = [\\p{Grapheme_Cluster_Break = T}];$LV      = [\\p{Grapheme_Cluster_Break = LV}];$LVT     = [\\p{Grapheme_Cluster_Break = LVT}];!!chain;!!forward;$CR $LF;$L ($L | $V | $LV | $LVT) {700};($LV | $V) ($V | $T) {700};($LVT | $T) $T {700};[^$Control $CR $LF] $Extend {700};[^$Control $CR $LF] $SpacingMark {700};!!reverse;!!safe_reverse;!!safe_forward;");
    private int index;
    private int lexemId;
    private char value;
    private Set<Character> charSet = new TreeSet<Character>();
    private Pattern phPattern;
    private RuleBasedBreakIterator iterator;

    public static Placeholder createGraphemeCluster(int lexemId) {
        return new Placeholder('\ue010', GC_RBBI, lexemId);
    }

    public static RuleBasedBreakIterator createPhIterator(String pattern, int lexemId) {
        return new RuleBasedBreakIterator(String.format(RBBI_RULES, pattern, lexemId));
    }

    public Placeholder(char value, RuleBasedBreakIterator iterator, int lexemId) {
        this.index = -1;
        this.lexemId = lexemId;
        this.setValue(value);
        this.setIterator(iterator);
    }

    public Placeholder(int index, RuleBasedBreakIterator iterator, int lexemId) {
        this.index = index;
        this.lexemId = lexemId;
        this.setValue((char)(57376 + index));
        this.setIterator(iterator);
    }

    private void setIterator(RuleBasedBreakIterator iterator) {
        if (iterator == null) {
            throw new OkapiException("Iterator not set for placeholder");
        }
        this.iterator = iterator;
    }

    private void setValue(char value) {
        this.value = value;
        this.phPattern = Pattern.compile(this.toString());
    }

    public int getIndex() {
        return this.index;
    }

    private void addChars(String chars) {
        for (char c : chars.toCharArray()) {
            this.charSet.add(Character.valueOf(c));
        }
    }

    public String getChars() {
        return this.escapeSpecChars(StringUtil.charsToString(this.charSet));
    }

    private String escapeSpecChars(String chars) {
        chars = chars.replace("\\", "\\\\)");
        chars = chars.replace("[", "\\[");
        chars = chars.replace("]", "\\]");
        chars = chars.replace("(", "\\(");
        chars = chars.replace(")", "\\)");
        return chars;
    }

    public Pattern getPhPattern() {
        return this.phPattern;
    }

    public String toString() {
        return Character.toString(this.value);
    }

    public RuleBasedBreakIterator getIterator() {
        return this.iterator;
    }

    public void processText(String codedText) {
        int start = 0;
        int end = 0;
        this.iterator.setText(codedText);
        end = start = this.iterator.first();
        while ((end = this.iterator.next()) != -1 && start < end) {
            int status = this.iterator.getRuleStatus();
            if (status == this.lexemId) {
                String match = codedText.substring(start, end);
                this.addChars(match);
            }
            start = end;
        }
    }
}

