/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.writer;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.lib.tkit.writer.Parameters;

public class BeanEventWriter
implements IFilterWriter {
    private OkapiJsonSession persiSession = new OkapiJsonSession(true);
    private LocaleId targetLocale;
    private Parameters params = new Parameters();
    private String outputPath;
    private OutputStream outputStream;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.targetLocale = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
        Util.createDirectories(this.outputPath);
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                return this.processStartBatch(event);
            }
            case START_DOCUMENT: {
                return this.processStartDocument(event);
            }
            case END_BATCH_ITEM: {
                return this.processEndBatchItem(event);
            }
            case TEXT_UNIT: {
                return this.processTextUnit(event);
            }
            case NO_OP: {
                return event;
            }
        }
        this.persiSession.serialize(event);
        return event;
    }

    @Override
    public void close() {
        if (this.persiSession != null) {
            this.persiSession.end();
        }
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void cancel() {
        this.close();
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    protected Event processStartBatch(Event event) {
        this.persiSession.setDescription(this.params.getMessage());
        this.persiSession.serialize(event);
        return event;
    }

    protected Event processStartDocument(Event event) {
        if (!Util.isEmpty(this.outputPath)) {
            try {
                this.persiSession.start(new FileOutputStream(this.outputPath));
            }
            catch (FileNotFoundException e) {
                throw new OkapiIOException(String.format("Cannot create event serialization file '%s'", this.outputPath), e);
            }
        } else if (this.outputStream != null) {
            this.persiSession.start(this.outputStream);
        } else {
            throw new OkapiIOException("Output path or stream not defined for event writer");
        }
        StartDocument resource = event.getStartDocument();
        if (resource.getAnnotations() instanceof Annotations) {
            Annotations anns = (Annotations)resource.getAnnotations();
            for (IAnnotation ann : anns) {
                if (ann instanceof Serializable) {
                    this.persiSession.setAnnotation(ann);
                }
                anns.remove(ann.getClass());
            }
        }
        this.persiSession.serialize(event);
        return event;
    }

    protected Event processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        Event ev = new Event(EventType.TEXT_UNIT, tu.clone());
        if (this.params.isRemoveTarget() && this.targetLocale != null) {
            tu.removeTarget(this.targetLocale);
        }
        this.persiSession.serialize(event);
        return ev;
    }

    protected Event processEndBatchItem(Event event) {
        Ending ending = event.getEnding();
        if (ending != null) {
            for (IAnnotation ann : ending.getAnnotations()) {
                if (!(ann instanceof Serializable)) continue;
                this.persiSession.setAnnotation(ann);
            }
        }
        this.persiSession.serialize(event);
        this.close();
        return event;
    }
}

