/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.filters.plaintext.ui.OptionsTab;
import net.sf.okapi.filters.plaintext.ui.common.FilterParametersEditor;
import net.sf.okapi.filters.table.Parameters;
import net.sf.okapi.filters.table.ui.AddModifyColumnDefPage;
import net.sf.okapi.filters.table.ui.ColumnsTab;
import net.sf.okapi.filters.table.ui.TableTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Widget;

@EditorFor(value=Parameters.class)
public class Editor
extends FilterParametersEditor {
    @Override
    protected void createPages(TabFolder pageContainer) {
        this.addPage("Table", TableTab.class);
        this.addPage("Columns", ColumnsTab.class);
        this.addPage("Options", OptionsTab.class);
        this.addSpeaker(TableTab.class, "btnCSV");
        this.addSpeaker(TableTab.class, "btnTSV");
        this.addSpeaker(TableTab.class, "btnFWC");
        this.addSpeaker(TableTab.class, "header");
        this.addSpeaker(TableTab.class, "body");
        this.addSpeaker(TableTab.class, "trim");
        this.addSpeaker(OptionsTab.class, "allow");
    }

    @Override
    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    protected String getCaption() {
        return "Table Filter Parameters";
    }

    @Override
    protected void interop(Widget speaker) {
        Control btnCSV = this.findControl(TableTab.class, "btnCSV");
        Control btnFWC = this.findControl(TableTab.class, "btnFWC");
        Control header = this.findControl(TableTab.class, "header");
        Control body = this.findControl(TableTab.class, "body");
        Control start = this.findControl(AddModifyColumnDefPage.class, "start");
        Control lstart = this.findControl(AddModifyColumnDefPage.class, "lstart");
        Control end = this.findControl(AddModifyColumnDefPage.class, "end");
        Control lend = this.findControl(AddModifyColumnDefPage.class, "lend");
        Composite columns = this.findPage(ColumnsTab.class);
        Control all = this.findControl(ColumnsTab.class, "all");
        Control defs = this.findControl(ColumnsTab.class, "defs");
        Control trim = this.findControl(TableTab.class, "trim");
        Control allow = this.findControl(OptionsTab.class, "allow");
        Control lead = this.findControl(OptionsTab.class, "lead");
        Control trail = this.findControl(OptionsTab.class, "trail");
        SWTUtil.enableIfSelected(start, btnFWC);
        SWTUtil.enableIfSelected(lstart, btnFWC);
        SWTUtil.enableIfSelected(end, btnFWC);
        SWTUtil.enableIfSelected(lend, btnFWC);
        SWTUtil.disableIfNotSelected(start, btnFWC);
        SWTUtil.disableIfNotSelected(lstart, btnFWC);
        SWTUtil.disableIfNotSelected(end, btnFWC);
        SWTUtil.disableIfNotSelected(lend, btnFWC);
        if (speaker == allow && SWTUtil.getSelected(trim) && SWTUtil.getSelected(btnCSV)) {
            Dialogs.showWarning(this.getShell(), "You cannot unselect this check-box while the \"Table/CSV actions/Exclude leading/trailing white spaces from extracted text\" box is on.", null);
        }
        if (speaker == body && (SWTUtil.getDisabled(header) || SWTUtil.getNotSelected(header))) {
            Dialogs.showWarning(this.getShell(), "You cannot unselect this check-box, otherwise there's noting to extract from the table.", null);
        }
        if (speaker == body && SWTUtil.getNotSelected(body) && SWTUtil.getSelected(header)) {
            Dialogs.showWarning(this.getShell(), "The Columns tab will be disabled as you're extracting the header only.", null);
        }
        if (SWTUtil.getSelected(btnCSV)) {
            SWTUtil.selectIfSelected(allow, trim);
            SWTUtil.selectIfSelected(lead, trim);
            SWTUtil.selectIfSelected(trail, trim);
            SWTUtil.unselectIfNotSelected(allow, trim);
            SWTUtil.unselectIfNotSelected(lead, trim);
            SWTUtil.unselectIfNotSelected(trail, trim);
            SWTUtil.enableIfSelected(allow, trim);
            SWTUtil.enableIfSelected(lead, trim);
            SWTUtil.enableIfSelected(trail, trim);
            SWTUtil.disableIfNotSelected(allow, trim);
            SWTUtil.disableIfNotSelected(lead, trim);
            SWTUtil.disableIfNotSelected(trail, trim);
            SWTUtil.disableIfNotSelected(allow, trim);
            SWTUtil.disableIfNotSelected(lead, trim);
            SWTUtil.disableIfNotSelected(trail, trim);
            SWTUtil.enableIfSelected(allow, trim);
        } else {
            SWTUtil.setEnabled(allow, true);
        }
        SWTUtil.enableIfSelected(columns, body);
        if (SWTUtil.getSelected(body) && !SWTUtil.getSelected(defs)) {
            SWTUtil.setSelected(all, true);
        }
        SWTUtil.disableIfNotSelected(columns, body);
        if (SWTUtil.getEnabled(columns)) {
            this.pageInterop(ColumnsTab.class, speaker);
        }
    }

    @Override
    protected String getWikiPage() {
        return "Table Filter";
    }
}

