/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.BaseMarker;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.its.ITSItems;
import net.sf.okapi.lib.xliff2.its.IWithITSAttributes;

public class AMarker
extends BaseMarker
implements IWithITSAttributes {
    public static final String TYPE_DEFAULT = "generic";
    private String value;
    private String ref;
    private String translate;
    private ITSItems itsItems;

    public AMarker(AMarker original) {
        super(original);
        this.value = original.value;
        this.ref = original.ref;
        this.translate = original.translate;
        if (original.hasITSItem()) {
            this.setITSItems(new ITSItems(original.itsItems));
        }
    }

    public AMarker(String id, boolean opening, String type) {
        this(id, opening, type, null);
    }

    public AMarker(String id, boolean opening, String type, String value) {
        if (id == null) {
            throw new InvalidParameterException("Id cannot be null.");
        }
        this.id = id;
        this.tagType = opening ? TagType.OPENING : TagType.CLOSING;
        this.internalId = AMarker.makeInternalId(this.id, this.tagType);
        this.setType(type);
        this.setValue(value);
    }

    @Override
    public void setType(String type) {
        int n;
        if (type == null) {
            type = TYPE_DEFAULT;
        } else if (";generic;comment;term;".indexOf(";" + type + ";") == -1 && ((n = type.indexOf(58)) == -1 || n == 0 || n == type.length() - 1)) {
            throw new InvalidParameterException(String.format("Invalid value '%s' for an annotation type.", type));
        }
        this.type = type;
    }

    @Override
    public void setTagType(TagType markerType) {
        if (markerType == TagType.STANDALONE) {
            throw new InvalidParameterException("The marker type of an annotation cannot be place-holder.");
        }
        this.tagType = markerType;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTranslate() {
        return this.translate;
    }

    public void setTranslate(String translate) {
        if (translate != null && !translate.equals("yes") && !translate.equals("no")) {
            throw new InvalidParameterException(String.format("Invalid value '%s' (must be 'yes' or 'no')", translate));
        }
        this.translate = translate;
    }

    @Override
    public boolean equals(BaseMarker marker) {
        if (marker == null) {
            throw new NullPointerException("The parameter of Code.equals() must not be null.");
        }
        if (this == marker) {
            return true;
        }
        if (!(marker instanceof AMarker)) {
            return false;
        }
        AMarker anno = (AMarker)marker;
        if (Util.compareAllowingNull(this.type, anno.getType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.id, anno.getId()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.ref, anno.getRef()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.value, anno.getValue()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.internalId, anno.getInternalId()) != 0) {
            return false;
        }
        return Util.compareAllowingNull(this.translate, anno.getTranslate()) == 0;
    }

    @Override
    public boolean isAnnotation() {
        return true;
    }

    @Override
    public boolean isCode() {
        return false;
    }

    @Override
    public boolean hasITSItem() {
        if (this.itsItems == null) {
            return false;
        }
        return !this.itsItems.isEmpty();
    }

    @Override
    public ITSItems getITSItems() {
        if (this.itsItems == null) {
            this.itsItems = new ITSItems();
        }
        return this.itsItems;
    }

    @Override
    public void setITSItems(ITSItems itsItems) {
        this.itsItems = itsItems;
    }
}

