/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff2.its.DataCategory;
import net.sf.okapi.lib.xliff2.its.IITSItem;

public class LocQualityIssue
extends DataCategory {
    private static final String TYPES = ";terminology;mistranslation;omission;untranslated;addition;duplication;inconsistency;grammar;legal;register;locale-specific-content;locale-violation;style;characters;misspelling;typographical;formatting;inconsistent-entities;numbers;markup;pattern-problem;whitespace;internationalization;length;non-conformance;uncategorized;other;";
    private String type;
    private String comment;
    private Double severity;
    private String profileRef;
    private boolean enabled = true;
    private String unresolvedGroupRef;

    public LocQualityIssue() {
    }

    public LocQualityIssue(String comment) {
        this.setComment(comment);
    }

    @Override
    public String getDataCategoryName() {
        return "localization-quality-issue";
    }

    @Override
    public void validate() {
        if (this.comment == null && this.type == null) {
            throw new RuntimeException("LQI must have at least comment or type defined.");
        }
    }

    @Override
    public IITSItem createCopy() {
        LocQualityIssue newItem = new LocQualityIssue(this.comment);
        newItem.setAnnotatorRef(this.getAnnotatorRef());
        newItem.enabled = this.enabled;
        newItem.profileRef = this.profileRef;
        newItem.severity = this.severity;
        newItem.type = this.type;
        newItem.unresolvedGroupRef = this.unresolvedGroupRef;
        return newItem;
    }

    @Override
    public boolean hasUnresolvedGroup() {
        return this.unresolvedGroupRef != null;
    }

    public String getUnresolvedGroupRef() {
        return this.unresolvedGroupRef;
    }

    public void setUnresolvedGroupRef(String unresolvedGroupRef) {
        this.unresolvedGroupRef = unresolvedGroupRef;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null && TYPES.indexOf(";" + type + ";") == -1) {
            throw new InvalidParameterException(String.format("The string '%s' is not a valid type.", type));
        }
        this.type = type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Double getSeverity() {
        return this.severity;
    }

    public void setSeverity(double severity) {
        if (severity < 0.0 || severity > 100.0) {
            throw new InvalidParameterException(String.format("The value '%f' is out of range.", severity));
        }
        this.severity = severity;
    }

    public String getProfileRef() {
        return this.profileRef;
    }

    public void setProfileRef(String profileRef) {
        this.profileRef = profileRef;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

