/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.io.FileCachedInputStream;

public class StreamUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            int len;
            out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return out.toByteArray();
    }

    public static void copy(File in, OutputStream out) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(in);
            StreamUtil.copy((InputStream)inputStream, out);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
            }
        }
    }

    public static String streamAsString(InputStream in, String encoding) {
        BufferedReader reader = null;
        StringBuilder tmp = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, encoding));
            tmp = new StringBuilder();
            char[] buf = new char[2048];
            int count = 0;
            while ((count = reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
            }
        }
        return Util.normalizeNewlines(tmp.toString());
    }

    public static String streamUtf8AsString(InputStream in) {
        return StreamUtil.streamAsString(in, "UTF-8");
    }

    public static InputStream stringAsStream(String str, String encoding) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(str.getBytes(encoding));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return is;
    }

    public static long calcCRC(InputStream in) {
        CheckedInputStream cis = new CheckedInputStream(in, new CRC32());
        byte[] buf = new byte[1024];
        try {
            while (cis.read(buf) >= 0) {
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return cis.getChecksum().getValue();
    }

    public static void copy(ReadableByteChannel inChannel, WritableByteChannel outChannel) {
        StreamUtil.copy(inChannel, outChannel, true);
    }

    public static void copy(ReadableByteChannel inChannel, WritableByteChannel outChannel, boolean closeChannels) {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        try {
            while (inChannel.read(buffer) != -1) {
                buffer.flip();
                outChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                outChannel.write(buffer);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            buffer.clear();
            buffer = null;
            try {
                if (inChannel != null && closeChannels) {
                    inChannel.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
            try {
                if (outChannel != null && !(outChannel instanceof FileCachedInputStream) && closeChannels) {
                    outChannel.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static void copy(InputStream in, File outputFile) {
        FileOutputStream outputStream = null;
        try {
            if (!outputFile.exists()) {
                Util.createDirectories(outputFile.getAbsolutePath());
                outputFile.createNewFile();
            }
            outputStream = new FileOutputStream(outputFile);
            StreamUtil.copy(in, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
            }
        }
    }

    public static void copy(InputStream is, String outputPath) {
        ReadableByteChannel inChannel = null;
        FileChannel outChannel = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(outputPath));
            inChannel = Channels.newChannel(is);
            outChannel = outputStream.getChannel();
            StreamUtil.copy(inChannel, outChannel);
        }
        catch (FileNotFoundException e) {
            throw new OkapiIOException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream outputStream) {
        ReadableByteChannel inChannel = null;
        WritableByteChannel outChannel = null;
        try {
            inChannel = Channels.newChannel(is);
            outChannel = Channels.newChannel(outputStream);
            StreamUtil.copy(inChannel, outChannel);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static void copy(File in, File out) {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(in);
            outputStream = new FileOutputStream(out);
            inChannel = inputStream.getChannel();
            outChannel = outputStream.getChannel();
            StreamUtil.copy(inChannel, outChannel);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static void copy(String fromPath, String toPath, boolean move) {
        FileChannel ic = null;
        FileChannel oc = null;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            Util.createDirectories(toPath);
            inputStream = new FileInputStream(fromPath);
            outputStream = new FileOutputStream(toPath);
            ic = inputStream.getChannel();
            oc = outputStream.getChannel();
            StreamUtil.copy(ic, oc);
            if (move) {
                ic.close();
                ic = null;
                File file = new File(fromPath);
                file.delete();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static FileCachedInputStream createResettableStream(InputStream is, int bufferSize) throws IOException {
        FileCachedInputStream ifcis;
        try {
            ifcis = new FileCachedInputStream(bufferSize);
            StreamUtil.copy(Channels.newChannel(is), ifcis);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error copying inputstream to FileCachedInputStream", e);
        }
        finally {
            is.close();
        }
        ifcis.mark(Integer.MAX_VALUE);
        return ifcis;
    }

    public boolean isCompressed(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

