/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.SimplifierRulesAnnotaton;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.Custom;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class FilterUtil {
    public static final Event createCodeSimplifierEvent(String rules) {
        Custom cr = new Custom();
        SimplifierRulesAnnotaton a = new SimplifierRulesAnnotaton();
        try {
            SimplifierRules.validate(rules);
        }
        catch (ParseException e) {
            throw new OkapiBadFilterInputException("Code simplifier rules are not valid.", e);
        }
        a.setRules(rules);
        cr.setAnnotation(a);
        return new Event(EventType.CUSTOM, cr);
    }

    public static IFilter createFilter(String configId) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        return fcMapper.createFilter(configId);
    }

    public static IFilter createFilter(Class<? extends IFilter> filterClass, String configId) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        fcMapper.addConfigurations(filterClass.getName());
        return fcMapper.createFilter(configId);
    }

    public static IFilter createFilter(String configId, URL ... customConfigs) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        for (URL customConfig : customConfigs) {
            FilterUtil.addCustomConfig(fcMapper, customConfig);
        }
        IFilter filter = fcMapper.createFilter(configId);
        filter.setFilterConfigurationMapper(fcMapper);
        return filter;
    }

    public static String addCustomConfig(FilterConfigurationMapper fcMapper, URL customConfig) {
        String configId = null;
        try {
            String path = customConfig.toURI().getPath();
            String root = Util.getDirectoryName(path) + File.separator;
            configId = Util.getFilename(path, false);
            fcMapper.setCustomConfigurationsDirectory(root);
            fcMapper.addCustomConfiguration(configId);
            fcMapper.updateCustomConfigurations();
        }
        catch (URISyntaxException e) {
            throw new OkapiIOException(e);
        }
        return configId;
    }

    public static IFilter createFilter(URL customConfig) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        return fcMapper.createFilter(FilterUtil.addCustomConfig(fcMapper, customConfig));
    }
}

