/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.idml.IDMLSkeleton;
import net.sf.okapi.filters.idml.NodeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class IDMLFilterWriter
implements IFilterWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DocumentBuilder docBuilder;
    private String outputPath;
    private LocaleId trgLoc;
    private ZipFile zipOriginal;
    private ZipOutputStream zipOutStream;
    private File tempFile;
    private byte[] buffer;
    private Transformer xformer;
    private ZipEntry entry;
    private Document doc;
    private int group;
    private Stack<IReferenceable> referents;
    private ArrayList<String> storiesLeft;
    private StringBuilder xml;
    private boolean reconstructing;
    private OutputStream outputStream;

    public IDMLFilterWriter() {
        try {
            DocumentBuilderFactory docFact = DocumentBuilderFactory.newInstance();
            docFact.setValidating(false);
            try {
                docFact.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docFact.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException e) {
                this.logger.warn("Unsupported DocumentBuilderFactory feature. Possible security vulnerabilities.", e);
            }
            this.docBuilder = docFact.newDocumentBuilder();
            this.xformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error initializing.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        try {
            this.zipOriginal = null;
            if (this.zipOutStream == null) {
                return;
            }
            this.zipOutStream.close();
            this.zipOutStream = null;
            this.buffer = null;
            if (this.tempFile != null) {
                StreamUtil.copy((InputStream)new FileInputStream(this.tempFile), this.outputPath);
                this.tempFile.delete();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing IDML outpiut.\n" + e.getMessage(), e);
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public String getName() {
        return "IDMLFilterWriter";
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_GROUP: 
            case START_SUBFILTER: {
                this.processStartGroup(event.getStartGroup());
                break;
            }
            case END_GROUP: 
            case END_SUBFILTER: {
                this.processEndGroup(event.getEndGroup());
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void processStartDocument(StartDocument res) {
        try {
            IDMLSkeleton skel = (IDMLSkeleton)res.getSkeleton();
            this.zipOriginal = skel.getOriginal();
            this.group = 0;
            this.referents = new Stack();
            this.storiesLeft = new ArrayList();
            this.reconstructing = false;
            this.tempFile = null;
            boolean useTemp = false;
            OutputStream os = this.outputStream;
            if (this.outputStream == null) {
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("~okapi-22_idmlTmpZip_", null);
                    os = new FileOutputStream(this.tempFile.getAbsolutePath());
                } else {
                    Util.createDirectories(this.outputPath);
                    os = new FileOutputStream(this.outputPath);
                }
            }
            this.zipOutStream = new ZipOutputStream(os);
            this.buffer = new byte[2048];
            Enumeration<? extends ZipEntry> entries = this.zipOriginal.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                if (entry.getName().endsWith(".xml") && entry.getName().startsWith("Stories/")) {
                    this.storiesLeft.add(entry.getName());
                    continue;
                }
                this.zipOutStream.putNextEntry(new ZipEntry(entry.getName()));
                InputStream input = this.zipOriginal.getInputStream(entry);
                while ((len = input.read(this.buffer)) > 0) {
                    this.zipOutStream.write(this.buffer, 0, len);
                }
                input.close();
                this.zipOutStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating output IDML.\n" + e.getMessage(), e);
        }
    }

    private void processEndDocument() {
        try {
            if (this.storiesLeft != null) {
                Enumeration<? extends ZipEntry> entries = this.zipOriginal.entries();
                while (entries.hasMoreElements()) {
                    int len;
                    ZipEntry entry = entries.nextElement();
                    if (!this.storiesLeft.contains(entry.getName())) continue;
                    this.zipOutStream.putNextEntry(new ZipEntry(entry.getName()));
                    InputStream input = this.zipOriginal.getInputStream(entry);
                    while ((len = input.read(this.buffer)) > 0) {
                        this.zipOutStream.write(this.buffer, 0, len);
                    }
                    input.close();
                    this.zipOutStream.closeEntry();
                    this.storiesLeft.remove(entry.getName());
                }
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writting out non-extracted stories.", e);
        }
        this.close();
    }

    private void processTextUnit(ITextUnit tu) {
        if (tu.isReferent()) {
            this.referents.push(tu);
        } else {
            while (!this.referents.isEmpty()) {
                this.mergeTextUnit((ITextUnit)this.referents.pop());
            }
            this.mergeTextUnit(tu);
        }
    }

    private void mergeTextUnit(ITextUnit tu) {
        block12: {
            TextFragment tf;
            IDMLSkeleton skel = (IDMLSkeleton)tu.getSkeleton();
            TextContainer tc = tu.getTarget(this.trgLoc);
            if (tc == null) {
                tc = tu.getSource();
            }
            if ((tf = tc.getUnSegmentedContentCopy()).isEmpty() && !tu.getSource().isEmpty()) {
                tf = tu.getSource().getUnSegmentedContentCopy();
            }
            String ctext = tf.getCodedText();
            ctext = Util.escapeToXML(ctext, 3, false, null);
            tf.setCodedText(ctext);
            if (!this.reconstructing) {
                this.xml = new StringBuilder("<r>");
            }
            this.reconstructing = skel.getForced();
            TextFragment[] res = skel.getMovedParts();
            if (res != null && res[0] != null) {
                this.xml.append(res[0].toText());
            }
            this.xml.append(tf.toText());
            if (res != null && res[1] != null) {
                this.xml.append(res[1].toText());
            }
            if (this.reconstructing) {
                return;
            }
            this.xml.append("</r>");
            try {
                Document tmpDoc = this.docBuilder.parse(new InputSource(new StringReader(this.xml.toString())));
                Document docWhereToImport = skel.getScopeNode().getOwnerDocument();
                DocumentFragment docFrag = docWhereToImport.createDocumentFragment();
                Node imp = docWhereToImport.importNode(tmpDoc.getDocumentElement(), true);
                while (imp.hasChildNodes()) {
                    docFrag.appendChild(imp.removeChild(imp.getFirstChild()));
                }
                HashMap<String, Node> map = this.collectLiveReferents(skel);
                Node node = skel.getScopeNode();
                while (node.hasChildNodes()) {
                    node.removeChild(node.getFirstChild());
                }
                node.appendChild(docFrag);
                if (map == null) break block12;
                NodeList list = ((Element)node).getElementsByTagName("SKLREF");
                while (list.getLength() > 0) {
                    Element marker = (Element)list.item(0);
                    String key = marker.getAttribute("id");
                    Node original = map.get(key);
                    if (original == null) {
                        this.logger.error("Missing original node for a reference in text unit id='{}'.", (Object)tu.getId());
                        break;
                    }
                    Element parent = (Element)marker.getParentNode();
                    parent.replaceChild(original, marker);
                }
            }
            catch (Throwable e) {
                this.logger.error("Error when parsing XML of text unit id='{}'.\n{}", (Object)tu.getId(), (Object)e.getMessage());
            }
        }
    }

    private HashMap<String, Node> collectLiveReferents(IDMLSkeleton skel) {
        if (!skel.hasReferences()) {
            return null;
        }
        HashMap<String, Node> map = new HashMap<String, Node>();
        Element elem = (Element)skel.getTopNode();
        HashMap<String, NodeReference> refs = skel.getReferences();
        for (String key : refs.keySet()) {
            NodeReference ref = refs.get(key);
            NodeList list = elem.getElementsByTagName(ref.name);
            Node ori = list.item(ref.position).cloneNode(true);
            map.put(key, ori);
        }
        return map;
    }

    private void processStartGroup(StartGroup res) {
        this.reconstructing = false;
        this.xml = null;
        ++this.group;
        IDMLSkeleton skel = (IDMLSkeleton)res.getSkeleton();
        if (skel == null) {
            return;
        }
        this.entry = skel.getEntry();
        this.doc = skel.getDocument();
    }

    private void processEndGroup(Ending ending) {
        while (!this.referents.isEmpty()) {
            this.mergeTextUnit((ITextUnit)this.referents.pop());
        }
        --this.group;
        try {
            if (this.group != 1) {
                return;
            }
            DOMSource source = new DOMSource(this.doc);
            this.zipOutStream.putNextEntry(new ZipEntry(this.entry.getName()));
            StreamResult result = new StreamResult(this.zipOutStream);
            this.xformer.transform(source, result);
            this.zipOutStream.closeEntry();
            this.storiesLeft.remove(this.entry.getName());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing out the story.\n" + e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw new OkapiIOException("Error transforming the story output.\n" + e.getMessage(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new OkapiIOException("Transform configuration error.\n" + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new OkapiIOException("Transformation error.\n" + e.getMessage(), e);
        }
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }
}

