/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openoffice;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    private static final String EXTRACTNOTES = "extractNotes";
    private static final String EXTRACTREFERENCES = "extractReferences";
    private static final String CONVERTSPACESTABS = "convertSpacesTabs";
    private static final String EXTRACTMETADATA = "extractMetadata";

    @Override
    public void reset() {
        super.reset();
        this.setExtractNotes(false);
        this.setExtractReferences(false);
        this.setConvertSpacesTabs(false);
        this.setSimplifierRules(null);
        this.setExtractMetadata(true);
    }

    public boolean getExtractNotes() {
        return this.getBoolean(EXTRACTNOTES);
    }

    public void setExtractNotes(boolean extractNotes) {
        this.setBoolean(EXTRACTNOTES, extractNotes);
    }

    public boolean getExtractReferences() {
        return this.getBoolean(EXTRACTREFERENCES);
    }

    public void setExtractReferences(boolean extractReferences) {
        this.setBoolean(EXTRACTREFERENCES, extractReferences);
    }

    public boolean getConvertSpacesTabs() {
        return this.getBoolean(CONVERTSPACESTABS);
    }

    public void setConvertSpacesTabs(boolean convertSpacesTabs) {
        this.setBoolean(CONVERTSPACESTABS, convertSpacesTabs);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    public boolean getExtractMetadata() {
        return this.getBoolean(EXTRACTMETADATA);
    }

    public void setExtractMetadata(boolean extractMetadata) {
        this.setBoolean(EXTRACTMETADATA, extractMetadata);
    }
}

