/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.Collections;

class AttributeStripper {
    AttributeStripper() {
    }

    protected static StartElement stripStartElementAttributeValues(XMLEventFactory eventFactory, StartElement startElement, Set<String> strippableAttributeValues) {
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        Iterator<Attribute> currentAttributesIterator = startElement.getAttributes();
        while (currentAttributesIterator.hasNext()) {
            Attribute attribute = currentAttributesIterator.next();
            if (strippableAttributeValues.contains(attribute.getName().getLocalPart())) continue;
            newAttributes.add(attribute);
        }
        return eventFactory.createStartElement(startElement.getName(), newAttributes.iterator(), startElement.getNamespaces());
    }

    static class RevisionAttributeStripper
    extends AttributeStripper {
        private static final Set<String> PARAGRAPH_REVISION_ATTRIBUTES = Collections.newHashSet(RevisionStrippableAttribute.RPR.getValue(), RevisionStrippableAttribute.DEL.getValue(), RevisionStrippableAttribute.R.getValue(), RevisionStrippableAttribute.P.getValue(), RevisionStrippableAttribute.R_DEFAULT.getValue());
        private static final Set<String> RUN_REVISION_ATTRIBUTES = Collections.newHashSet(RevisionStrippableAttribute.RPR.getValue(), RevisionStrippableAttribute.DEL.getValue(), RevisionStrippableAttribute.R.getValue());
        private static final Set<String> TABLE_ROW_REVISION_ATTRIBUTES = Collections.newHashSet(RevisionStrippableAttribute.RPR.getValue(), RevisionStrippableAttribute.DEL.getValue(), RevisionStrippableAttribute.R.getValue(), RevisionStrippableAttribute.TR.getValue());
        private static final Set<String> SECTION_PROPERTIES_REVISION_ATTRIBUTES = Collections.newHashSet(RevisionStrippableAttribute.RPR.getValue(), RevisionStrippableAttribute.DEL.getValue(), RevisionStrippableAttribute.R.getValue(), RevisionStrippableAttribute.SECT.getValue());

        RevisionAttributeStripper() {
        }

        static StartElement stripParagraphRevisionAttributes(XMLEventFactory eventFactory, StartElement startElement) {
            return RevisionAttributeStripper.stripStartElementAttributeValues(eventFactory, startElement, PARAGRAPH_REVISION_ATTRIBUTES);
        }

        static StartElement stripRunRevisionAttributes(XMLEventFactory eventFactory, StartElement startElement) {
            return RevisionAttributeStripper.stripStartElementAttributeValues(eventFactory, startElement, RUN_REVISION_ATTRIBUTES);
        }

        static StartElement stripTableRowRevisionAttributes(XMLEventFactory eventFactory, StartElement startElement) {
            return RevisionAttributeStripper.stripStartElementAttributeValues(eventFactory, startElement, TABLE_ROW_REVISION_ATTRIBUTES);
        }

        static StartElement stripSectionPropertiesRevisionAttributes(XMLEventFactory eventFactory, StartElement startElement) {
            return RevisionAttributeStripper.stripStartElementAttributeValues(eventFactory, startElement, SECTION_PROPERTIES_REVISION_ATTRIBUTES);
        }

        private static enum RevisionStrippableAttribute implements StrippableAttribute
        {
            RPR("rsidRPr"),
            DEL("rsidDel"),
            R("rsidR"),
            SECT("rsidSect"),
            P("rsidP"),
            R_DEFAULT("rsidRDefault"),
            TR("rsidTr");

            private String value;

            private RevisionStrippableAttribute(String value) {
                this.value = value;
            }

            @Override
            public String getValue() {
                return this.value;
            }
        }
    }

    static class GeneralAttributeStripper
    extends AttributeStripper {
        private static final Set<String> GENERAL_ATTRIBUTES = GeneralStrippableAttribute.getValues();

        GeneralAttributeStripper() {
        }

        static StartElement stripGeneralAttributes(XMLEventFactory eventFactory, StartElement startElement) {
            return GeneralAttributeStripper.stripStartElementAttributeValues(eventFactory, startElement, GENERAL_ATTRIBUTES);
        }

        private static enum GeneralStrippableAttribute implements StrippableAttribute
        {
            SPELLING_ERROR("err");

            private String value;

            private GeneralStrippableAttribute(String value) {
                this.value = value;
            }

            @Override
            public String getValue() {
                return this.value;
            }

            static Set<String> getValues() {
                HashSet<String> values = new HashSet<String>(GeneralStrippableAttribute.values().length);
                for (GeneralStrippableAttribute generalStrippableAttribute : GeneralStrippableAttribute.values()) {
                    values.add(generalStrippableAttribute.getValue());
                }
                return values;
            }
        }
    }

    static interface StrippableAttribute {
        public String getValue();
    }
}

