/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.UnstyledText;
import net.sf.okapi.filters.openxml.XMLEvents;

public class BlockTextUnitMapper {
    private static final int DEFAULT_CODE_STACK_POPS_LIMIT = 0;
    private static final int UNUSED_RUN_POSITION_VALUE = -1;
    private static final String NESTED_ID_GENERATOR_PREFIX = "sub";
    private Block block;
    private IdGenerator id;
    private int nextCodeId = 1;
    private Deque<RunCode> runCodeStack = new ArrayDeque<RunCode>();
    private List<ITextUnit> textUnits;
    private Map<Integer, XMLEvents> codeMap = new HashMap<Integer, XMLEvents>();
    private List<ITextUnit> referentTus = new ArrayList<ITextUnit>();

    BlockTextUnitMapper(Block block, IdGenerator id) {
        this.block = block;
        this.id = id;
    }

    public List<ITextUnit> getTextUnits() {
        if (this.textUnits == null) {
            this.textUnits = this.process();
        }
        return this.textUnits;
    }

    public List<ITextUnit> process() {
        if (this.block.getChunks().size() <= 2) {
            for (XMLEvents xMLEvents : this.block.getChunks()) {
                if (!(xMLEvents instanceof Run)) continue;
                throw new IllegalStateException("Unexpected structure");
            }
            return Collections.emptyList();
        }
        TextUnit textUnit = new TextUnit(this.id.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment textFragment = new TextFragment();
        textUnit.setSource(new TextContainer(textFragment));
        List<Chunk> chunks = this.block.getChunks().subList(1, this.block.getChunks().size() - 1);
        boolean runHasText = false;
        for (Chunk chunk : chunks) {
            if (chunk instanceof Run) {
                runHasText |= this.processRun(textFragment, (Run)chunk, textUnit);
                continue;
            }
            if (chunk instanceof RunContainer) {
                RunContainer rc = (RunContainer)chunk;
                if (rc.getRuns().isEmpty()) {
                    this.addIsolatedCode(textFragment, chunk);
                    continue;
                }
                Code openCode = this.addOpenCode(textFragment, rc);
                int savedFormattingCodeDepth = this.runCodeStack.size();
                for (int nestedRunPosition = 0; nestedRunPosition < rc.getRuns().size(); ++nestedRunPosition) {
                    runHasText |= this.processNestedRun(textFragment, rc.getRuns(), textUnit, nestedRunPosition, savedFormattingCodeDepth);
                }
                this.popRunCodesToDepth(textFragment, savedFormattingCodeDepth);
                this.addClosedCode(textFragment, rc, openCode);
                continue;
            }
            this.addIsolatedCode(textFragment, chunk);
        }
        this.popAllRunCodes(textFragment);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>();
        tus.addAll(this.referentTus);
        if (runHasText || !this.referentTus.isEmpty()) {
            BlockSkeleton skel = new BlockSkeleton(this.block, this.codeMap);
            skel.setParent(textUnit);
            textUnit.setSkeleton(skel);
            tus.add(textUnit);
        }
        return tus;
    }

    private boolean processNestedRun(TextFragment tf, List<Run> runs, ITextUnit textUnit, int runPosition, int codeStackPopsLimit) {
        this.referentTus.addAll(this.processNestedBlocks(runs.get(runPosition), textUnit.getId()));
        return this.addRun(tf, codeStackPopsLimit, runPosition, runs.get(runPosition), runPosition + 1 < runs.size() ? runs.get(runPosition + 1) : null);
    }

    private boolean processRun(TextFragment tf, Run run, ITextUnit textUnit) {
        this.referentTus.addAll(this.processNestedBlocks(run, textUnit.getId()));
        return this.addRun(tf, 0, -1, run, null);
    }

    private List<ITextUnit> processNestedBlocks(Run run, String parentId) {
        IdGenerator nestedIds = new IdGenerator(parentId, NESTED_ID_GENERATOR_PREFIX);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>();
        for (Textual textual : run.getNestedTextualItems()) {
            if (textual instanceof Block) {
                BlockTextUnitMapper nestedMapper = new BlockTextUnitMapper((Block)textual, nestedIds);
                tus.addAll(nestedMapper.process());
                continue;
            }
            if (!(textual instanceof UnstyledText)) continue;
            TextUnit tu = new TextUnit(nestedIds.createId(), ((UnstyledText)textual).getText());
            tu.setPreserveWhitespaces(true);
            tus.add(tu);
        }
        for (ITextUnit tu : tus) {
            tu.setIsReferent(true);
        }
        return tus;
    }

    private boolean addRun(TextFragment tf, int codeStackPopsLimit, int runPosition, Run run, Run nextRun) {
        if (!run.containsText()) {
            this.addIsolatedCode(tf, run);
            return false;
        }
        RunProperties rp = run.getProperties();
        while (this.runCodeStack.size() > codeStackPopsLimit && !this.runCodeStack.isEmpty() && !this.runCodeStack.peekFirst().runProperties.isSubsetOf(rp)) {
            this.addCloseCode(tf, this.runCodeStack.pop());
        }
        if (0 == runPosition && null != nextRun && !nextRun.getProperties().equals(rp) && !nextRun.getProperties().isSubsetOf(rp) || (0 < runPosition || 0 < rp.count()) && (this.runCodeStack.isEmpty() || !this.runCodeStack.peekFirst().runProperties.equals(rp))) {
            RunCode rc = new RunCode(rp);
            this.runCodeStack.push(rc);
            this.addOpenCode(tf, rc);
        }
        this.addRunContent(tf, run);
        return true;
    }

    private void addRunContent(TextFragment tf, Run run) {
        for (XMLEvents xMLEvents : run.getBodyChunks()) {
            if (xMLEvents instanceof Run.RunText) {
                this.addText(tf, ((Run.RunText)xMLEvents).getText());
                continue;
            }
            this.addIsolatedCode(tf, xMLEvents);
        }
    }

    private void popRunCodesToDepth(TextFragment tf, int desiredDepth) {
        while (this.runCodeStack.size() > desiredDepth) {
            this.addCloseCode(tf, this.runCodeStack.pop());
        }
    }

    private void popAllRunCodes(TextFragment tf) {
        while (!this.runCodeStack.isEmpty()) {
            this.addCloseCode(tf, this.runCodeStack.pop());
        }
    }

    private void addText(TextFragment tf, String text) {
        tf.append(text);
    }

    private Code addOpenCode(TextFragment tf, RunContainer rc) {
        Code code = new Code(TextFragment.TagType.OPENING, RunContainer.Type.HYPERLINK.getValue());
        code.setData("<" + RunContainer.Type.HYPERLINK.getValue() + this.nextCodeId + ">");
        code.setId(this.nextCodeId);
        tf.append(code);
        this.codeMap.put(this.nextCodeId, rc);
        this.runCodeStack.push(new RunCode(rc.getDefaultRunProperties()));
        return code;
    }

    private void addClosedCode(TextFragment tf, RunContainer rc, Code openCode) {
        Code code = new Code(TextFragment.TagType.CLOSING, openCode.getType());
        code.setData("</" + RunContainer.Type.HYPERLINK.getValue() + openCode.getId() + ">");
        code.setId(openCode.getId());
        this.runCodeStack.pop();
        tf.append(code);
    }

    private void addOpenCode(TextFragment tf, RunCode rc) {
        Code code = new Code(TextFragment.TagType.OPENING, "run");
        code.setId(rc.codeId);
        code.setData("<run" + code.getId() + ">");
        this.codeMap.put(rc.codeId, rc.runProperties);
        tf.append(code);
    }

    private void addCloseCode(TextFragment tf, RunCode rc) {
        Code code = new Code(TextFragment.TagType.CLOSING, "run");
        code.setId(rc.codeId);
        code.setData("</run" + code.getId() + ">");
        tf.append(code);
    }

    private void addIsolatedCode(TextFragment tf, XMLEvents events) {
        int codeId = this.nextCodeId++;
        this.codeMap.put(codeId, events);
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "x", this.getCodeData(events, codeId));
        code.setId(codeId);
        tf.append(code);
    }

    private String getCodeData(XMLEvents codeEvents, int codeId) {
        if (codeEvents instanceof Run) {
            return "<run" + codeId + "/>";
        }
        return "<tags" + codeId + "/>";
    }

    class RunCode {
        public RunProperties runProperties;
        public int codeId;

        RunCode(RunProperties runProperties) {
            this.runProperties = runProperties;
            this.codeId = BlockTextUnitMapper.this.nextCodeId++;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.codeId + ", " + this.runProperties + ")";
        }
    }
}

