/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperStrategy;

class ElementSkipperFactory {
    private static final String SKIPPABLE_BOOKMARK_NAME = "_GoBack";

    ElementSkipperFactory() {
    }

    static ElementSkipper createGeneralElementSkipper(ElementSkipper.SkippableElement ... skippableElements) {
        return new ElementSkipper.GeneralElementSkipper(new ElementSkipperStrategy.GeneralElementSkipperStrategy(ElementSkipperFactory.getSkippableElementValues(skippableElements)));
    }

    static ElementSkipper createGeneralElementSkipper(ConditionalParameters conditionalParameters, ElementSkipper.SkippableElement ... skippableElements) {
        Set<String> skippableElementSet = ElementSkipperFactory.getSkippableElementValues(skippableElements);
        if (conditionalParameters.getCleanupAggressively()) {
            skippableElementSet.add(ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_COMPLEX_SCRIPT_BOLD.getValue());
            skippableElementSet.add(ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_CHARACTER_SPACING.getValue());
            skippableElementSet.add(ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_COMPLEX_SCRIPT_FONT_SIZE.getValue());
            skippableElementSet.add(ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_CHARACTER_WIDTH.getValue());
        }
        return new ElementSkipper.GeneralElementSkipper(new ElementSkipperStrategy.GeneralElementSkipperStrategy(skippableElementSet));
    }

    static ElementSkipper createBookmarkElementSkipper(ElementSkipper.SkippableElement ... skippableElements) {
        return new ElementSkipper.BookmarkElementSkipper(new ElementSkipperStrategy.BookmarkElementSkipperStrategy(ElementSkipperFactory.getSkippableElementValues(skippableElements), SKIPPABLE_BOOKMARK_NAME));
    }

    private static Set<String> getSkippableElementValues(ElementSkipper.SkippableElement ... skippableElements) {
        if (0 == skippableElements.length) {
            return Collections.emptySet();
        }
        HashSet<String> skippableElementValues = new HashSet<String>(skippableElements.length);
        for (ElementSkipper.SkippableElement skippableElement : skippableElements) {
            skippableElementValues.add(skippableElement.getValue());
        }
        return skippableElementValues;
    }
}

