/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

abstract class ElementSkipperStrategy {
    protected Set<String> skippableElementValues;

    protected ElementSkipperStrategy(Set<String> skippableElementValues) {
        this.skippableElementValues = skippableElementValues;
    }

    abstract boolean isSkippableElement(StartElement var1);

    abstract void skipElement(XMLEventReader var1, StartElement var2) throws XMLStreamException;

    static class BookmarkElementSkipperStrategy
    extends GeneralElementSkipperStrategy {
        private String bookmarkName;
        private String bookmarkId;

        BookmarkElementSkipperStrategy(Set<String> skippableElementValues, String bookmarkName) {
            super(skippableElementValues);
            this.bookmarkName = bookmarkName;
        }

        @Override
        boolean isSkippableElement(StartElement startElement) {
            return ElementSkipper.BookmarkElementSkipper.isBookmarkStartElement(startElement) && this.bookmarkName.equals(XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_NAME)) || ElementSkipper.BookmarkElementSkipper.isBookmarkEndElement(startElement) && Objects.equals(this.bookmarkId, XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_ID));
        }

        @Override
        void skipElement(XMLEventReader eventReader, StartElement startElement) throws XMLStreamException {
            super.skipElement(eventReader, startElement);
            if (ElementSkipper.BookmarkElementSkipper.isBookmarkStartElement(startElement)) {
                this.bookmarkId = XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_ID);
                return;
            }
            this.bookmarkId = null;
        }
    }

    static class GeneralElementSkipperStrategy
    extends ElementSkipperStrategy {
        GeneralElementSkipperStrategy(Set<String> skippableElementValues) {
            super(skippableElementValues);
        }

        static void skipElementEvents(XMLEventReader eventReader, StartElement startElement) throws XMLStreamException {
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (!XMLEventHelpers.isEndElement(e, startElement)) continue;
                return;
            }
            throw new IllegalStateException("Unexpected structure");
        }

        @Override
        boolean isSkippableElement(StartElement startElement) {
            return this.skippableElementValues.contains(startElement.getName().getLocalPart());
        }

        @Override
        void skipElement(XMLEventReader eventReader, StartElement startElement) throws XMLStreamException {
            GeneralElementSkipperStrategy.skipElementEvents(eventReader, startElement);
        }
    }
}

