/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.BlockPropertyFactory;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class MarkupComponentParser {
    MarkupComponentParser() {
    }

    static MarkupComponent parseEmptyElementMarkupComponent(XMLEventReader eventReader, XMLEventFactory eventFactory, StartElement startElement) throws XMLStreamException {
        if (!eventReader.hasNext()) {
            throw new IllegalStateException("Unexpected structure");
        }
        XMLEvent nextEvent = eventReader.nextEvent();
        if (!XMLEventHelpers.isEndElement(nextEvent, startElement)) {
            throw new IllegalStateException("Unexpected structure");
        }
        return MarkupComponentFactory.createEmptyElementMarkupComponent(eventFactory, startElement, nextEvent.asEndElement());
    }

    static MarkupComponent parseBlockProperties(XMLEventReader eventReader, XMLEventFactory eventFactory, StartElement startElement, ElementSkipper elementSkipper) throws XMLStreamException {
        ArrayList<BlockProperty> properties = new ArrayList<BlockProperty>();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (XMLEventHelpers.isEndElement(event, startElement)) {
                return MarkupComponentFactory.createBlockProperties(eventFactory, startElement, event.asEndElement(), properties);
            }
            if (!event.isStartElement()) continue;
            if (elementSkipper.isSkippableElement(event.asStartElement())) {
                elementSkipper.skipElement(eventReader, event.asStartElement());
                continue;
            }
            properties.add(BlockPropertyFactory.createBlockProperty(MarkupComponentParser.gatherEventsWithRevisionPropertiesSkipper(eventReader, event.asStartElement(), elementSkipper)));
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private static List<XMLEvent> gatherEventsWithRevisionPropertiesSkipper(XMLEventReader eventReader, StartElement startElement, ElementSkipper elementSkipper) throws XMLStreamException {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(startElement);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement() && elementSkipper.isSkippableElement(event.asStartElement())) {
                elementSkipper.skipElement(eventReader, event.asStartElement());
                continue;
            }
            events.add(event);
            if (!XMLEventHelpers.isEndElement(event, startElement)) continue;
            return events;
        }
        throw new IllegalStateException("Unexpected structure");
    }
}

