/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

public class RunFonts {
    static final QName RUN_FONTS = Namespaces.WordProcessingML.getQName("rFonts");
    private static final int MAX_NUMBER_OF_EVENTS = 2;
    private static final int MAX_NUMBER_OF_CONTENT_CATEGORIES = 4;
    private XMLEventFactory eventFactory;
    private StartElement startElement;
    private EnumMap<ContentCategory, String> fonts;

    RunFonts(XMLEventFactory eventFactory, StartElement startElement, EnumMap<ContentCategory, String> fonts) {
        this.eventFactory = eventFactory;
        this.startElement = startElement;
        this.fonts = fonts;
    }

    static RunFonts build(XMLEventFactory eventFactory, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        EnumMap<ContentCategory, String> fonts = new EnumMap<ContentCategory, String>(ContentCategory.class);
        for (ContentCategory contentCategory : ContentCategory.values()) {
            fonts.put(contentCategory, XMLEventHelpers.getAttributeValue(startElement, contentCategory.getValue()));
        }
        ElementSkipper.GeneralElementSkipper.skipElementEvents(eventReader, startElement);
        return new RunFonts(eventFactory, startElement, fonts);
    }

    boolean canBeMerged(RunFonts runFonts) {
        for (ContentCategory category : ContentCategory.values()) {
            if (ContentCategory.HINT == category || this.canContentCategoriesBeMerged(this.fonts.get((Object)category), runFonts.fonts.get((Object)category))) continue;
            return false;
        }
        return true;
    }

    private boolean canContentCategoriesBeMerged(String category1, String category2) {
        return category1 == null && category2 != null || category1 != null && category2 == null || Objects.equals(category1, category2);
    }

    RunFonts merge(RunFonts runFonts) {
        EnumMap<ContentCategory, String> newFonts = new EnumMap<ContentCategory, String>(ContentCategory.class);
        for (ContentCategory category : ContentCategory.values()) {
            newFonts.put(category, this.mergeContentCategories(this.fonts.get((Object)category), runFonts.fonts.get((Object)category)));
        }
        this.fonts = newFonts;
        return this;
    }

    private String mergeContentCategories(String category1, String category2) {
        return category1 != null ? category1 : category2;
    }

    List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
        events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes(), this.startElement.getNamespaces()));
        events.add(this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces()));
        return events;
    }

    private Iterator<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(4);
        for (ContentCategory category : ContentCategory.values()) {
            String value = this.fonts.get((Object)category);
            if (value == null) continue;
            attributes.add(this.eventFactory.createAttribute("w", Namespaces.WordProcessingML.getURI(), category.getValue().getLocalPart(), value));
        }
        return attributes.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunFonts runFonts = (RunFonts)o;
        return Objects.equals(this.fonts, runFonts.fonts);
    }

    public int hashCode() {
        return Objects.hash(this.fonts);
    }

    private static enum ContentCategory {
        ASCII("ascii"),
        ASCII_THEME("asciiTheme"),
        HIGH_ANSI("hAnsi"),
        HIGH_ANSI_THEME("hAnsiTheme"),
        COMPLEX_SCRIPT("cs"),
        COMPLEX_SCRIPT_THEME("cstheme"),
        EAST_ASIAN("eastAsia"),
        EAST_ASIAN_THEME("eastAsiaTheme"),
        HINT("hint");

        private QName value;

        private ContentCategory(String value) {
            this.value = Namespaces.WordProcessingML.getQName(value);
        }

        public QName getValue() {
            return this.value;
        }
    }
}

