/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.UnstyledText;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunParser.class);
    private StartElement startEvent;
    private XMLEventReader events;
    private XMLEventFactory eventFactory;
    private ConditionalParameters params;
    private StyleDefinitions styleDefinitions;
    private EndElement endEvent;
    private RunProperties runProperties = RunProperties.emptyRunProperties();
    private List<Chunk> runBodyChunks = new ArrayList<Chunk>();
    private List<XMLEvent> currentMarkupChunk = new ArrayList<XMLEvent>();
    private QName textName = null;
    private boolean isTextPreservingWhitespace = false;
    private StringBuilder textContent = new StringBuilder();
    private boolean hadAnyText = false;
    private boolean hadNonWhitespaceText = false;
    private List<Textual> nestedTextualItems = new ArrayList<Textual>();
    private boolean containsNestedItems = false;
    private IdGenerator nestedTextualIds;
    private int complexCodeDepth = 0;
    private boolean hasComplexCodes;
    private String runStyle;

    RunParser(StartElement startEvent, XMLEventReader events, XMLEventFactory eventFactory, IdGenerator nestedTextualIds, ConditionalParameters params, StyleDefinitions styleDefinitions) {
        this.startEvent = startEvent;
        this.events = events;
        this.eventFactory = eventFactory;
        this.nestedTextualIds = nestedTextualIds;
        this.params = params;
        this.styleDefinitions = styleDefinitions;
    }

    RunParser parse() throws XMLStreamException {
        this.log("startRun: " + this.startEvent);
        this.startEvent = AttributeStripper.RevisionAttributeStripper.stripRunRevisionAttributes(this.eventFactory, this.startEvent);
        XMLEvent firstChild = this.events.nextTag();
        if (XMLEventHelpers.isRunPropsStartEvent(firstChild)) {
            this.processRunProps(firstChild.asStartElement(), this.events);
        } else {
            if (XMLEventHelpers.isEndElement(firstChild, this.startEvent)) {
                return this.endRun(firstChild.asEndElement());
            }
            this.processRunBody(firstChild, this.events);
        }
        while (this.events.hasNext()) {
            XMLEvent e = this.events.nextEvent();
            this.log("processRun: " + e);
            if (XMLEventHelpers.isEndElement(e, this.startEvent)) {
                return this.endRun(e.asEndElement());
            }
            this.processRunBody(e, this.events);
        }
        throw new IllegalStateException("Invalid content? Unterminated run");
    }

    QName getTextName() {
        return this.textName;
    }

    private void processRunProps(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        this.runProperties = new RunPropertiesParser(startEvent, events, this.params, this.eventFactory).parse();
        RunProperty.RunStyleProperty runStyleProperty = this.runProperties.getRunStyleProperty();
        this.runStyle = null == runStyleProperty ? null : runStyleProperty.getRunStyle();
    }

    private RunParser endRun(EndElement e) throws XMLStreamException {
        this.flushText();
        this.flushMarkupChunk();
        this.endEvent = e;
        if (!this.hadNonWhitespaceText && this.params.getCleanupAggressively()) {
            this.runProperties = RunProperties.copiedRunProperties(this.runProperties, true, false, false);
        }
        return this;
    }

    Run build() throws XMLStreamException {
        return new Run(this.startEvent, this.endEvent, this.runProperties, this.runBodyChunks, this.nestedTextualItems);
    }

    public String toString() {
        try {
            return "RunParser for " + this.build().toString();
        }
        catch (XMLStreamException e) {
            return "RunParser (" + e.getMessage() + ")";
        }
    }

    boolean canMerge(RunParser otherRunParser, String paragraphStyle) {
        if (Namespaces.Math.containsName(this.startEvent.getName())) {
            return false;
        }
        if (this.containsNestedItems || otherRunParser.containsNestedItems) {
            return false;
        }
        if (this.hasComplexCodes || otherRunParser.hasComplexCodes) {
            return false;
        }
        if (this.runProperties.count() == 0 && otherRunParser.runProperties.count() == 0) {
            return true;
        }
        return this.canRunPropertiesBeMerged(otherRunParser, paragraphStyle);
    }

    private boolean canRunPropertiesBeMerged(RunParser otherRunParser, String paragraphStyle) {
        if (this.runProperties == otherRunParser.runProperties) {
            return true;
        }
        RunProperties currentProperties = this.styleDefinitions.getCombinedRunProperties(paragraphStyle, this.runStyle, this.runProperties);
        RunProperties otherProperties = this.styleDefinitions.getCombinedRunProperties(paragraphStyle, otherRunParser.runStyle, otherRunParser.runProperties);
        if (currentProperties.count() != otherProperties.count()) {
            return false;
        }
        int numberOfMatchedProperties = 0;
        block0: for (RunProperty currentProperty : currentProperties.getProperties()) {
            QName currentPropertyStartElementName = currentProperty.getName();
            for (RunProperty otherProperty : otherProperties.getProperties()) {
                QName otherPropertyStartElementName = otherProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                if (currentProperty instanceof MergeableRunProperty && otherProperty instanceof MergeableRunProperty ? !((MergeableRunProperty)((Object)currentProperty)).canBeMerged((MergeableRunProperty)((Object)otherProperty)) : !currentProperty.canBeReplaced(otherProperty)) {
                    return false;
                }
                ++numberOfMatchedProperties;
                continue block0;
            }
        }
        return numberOfMatchedProperties >= currentProperties.count();
    }

    void merge(RunParser other) throws XMLStreamException {
        this.mergeRunProperties(other);
        ArrayList<XMLEvent> newBodyEvents = new ArrayList<XMLEvent>();
        XMLEventHelpers.addChunksToList(newBodyEvents, this.runBodyChunks);
        this.isTextPreservingWhitespace |= other.isTextPreservingWhitespace;
        XMLEventHelpers.addChunksToList(newBodyEvents, other.runBodyChunks);
        this.runBodyChunks.clear();
        XMLListEventReader events = new XMLListEventReader(newBodyEvents);
        while (events.hasNext()) {
            this.addRunBody(events.nextEvent(), events);
        }
        this.flushText();
        this.flushMarkupChunk();
    }

    private void mergeRunProperties(RunParser otherRunParser) {
        if (0 == this.runProperties.count() && 0 == otherRunParser.runProperties.count()) {
            return;
        }
        List<RunProperty> mergeableRunProperties = this.runProperties.getMergeableRunProperties();
        if (0 == mergeableRunProperties.size()) {
            this.runProperties = otherRunParser.runProperties;
            return;
        }
        List<RunProperty> otherMergeableRunProperties = otherRunParser.runProperties.getMergeableRunProperties();
        if (0 == otherMergeableRunProperties.size()) {
            return;
        }
        if (mergeableRunProperties.size() >= otherMergeableRunProperties.size()) {
            List<RunProperty> remainedOtherMergeableRunProperties = this.mergeMergeableRunProperties(mergeableRunProperties, otherMergeableRunProperties);
            this.runProperties.getProperties().addAll(remainedOtherMergeableRunProperties);
            return;
        }
        List<RunProperty> remainedOtherMergeableRunProperties = this.mergeMergeableRunProperties(otherMergeableRunProperties, mergeableRunProperties);
        otherRunParser.runProperties.getProperties().addAll(remainedOtherMergeableRunProperties);
        this.runProperties = otherRunParser.runProperties;
    }

    private List<RunProperty> mergeMergeableRunProperties(List<RunProperty> mergeableRunProperties, List<RunProperty> otherMergeableRunProperties) {
        ArrayList<RunProperty> remainedOtherMergeableRunProperties = new ArrayList<RunProperty>(otherMergeableRunProperties);
        block0: for (RunProperty runProperty : mergeableRunProperties) {
            QName currentPropertyStartElementName = runProperty.getName();
            Iterator remainedOtherMergeableRunPropertyIterator = remainedOtherMergeableRunProperties.iterator();
            while (remainedOtherMergeableRunPropertyIterator.hasNext()) {
                RunProperty otherRunProperty = (RunProperty)remainedOtherMergeableRunPropertyIterator.next();
                QName otherPropertyStartElementName = otherRunProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                ((MergeableRunProperty)((Object)runProperty)).merge((MergeableRunProperty)((Object)otherRunProperty));
                remainedOtherMergeableRunPropertyIterator.remove();
                continue block0;
            }
        }
        return remainedOtherMergeableRunProperties;
    }

    private void processRunBody(XMLEvent e, XMLEventReader events) throws XMLStreamException {
        if (XMLEventHelpers.isParagraphStartEvent(e)) {
            this.log("Nested block start event: " + e);
            this.flushText();
            BlockParser nestedBlockParser = new BlockParser(e.asStartElement(), events, this.eventFactory, this.params, this.nestedTextualIds, this.styleDefinitions);
            Block nested = nestedBlockParser.parse();
            this.containsNestedItems = true;
            if (nested.hasTranslatableRunContent()) {
                this.addToMarkupChunk(this.eventFactory.createCharacters(TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
                this.nestedTextualItems.add(nested);
            } else {
                for (XMLEvent nestedEvent : nested.getEvents()) {
                    this.addToMarkupChunk(nestedEvent);
                }
                for (Chunk chunk : nested.getChunks()) {
                    if (chunk instanceof Run) {
                        this.nestedTextualItems.addAll(((Run)chunk).getNestedTextualItems());
                        continue;
                    }
                    if (!(chunk instanceof RunContainer)) continue;
                    for (Run run : ((RunContainer)chunk).getRuns()) {
                        this.nestedTextualItems.addAll(run.getNestedTextualItems());
                    }
                }
            }
        } else if (XMLEventHelpers.isComplexCodeStart(e)) {
            ++this.complexCodeDepth;
            this.hasComplexCodes = true;
            this.addToMarkupChunk(e);
            while (events.hasNext()) {
                e = (XMLEvent)events.next();
                this.addToMarkupChunk(e);
                if (XMLEventHelpers.isComplexCodeEnd(e)) {
                    if (--this.complexCodeDepth > 0) continue;
                    break;
                }
                if (!XMLEventHelpers.isComplexCodeStart(e)) continue;
                ++this.complexCodeDepth;
            }
        } else {
            this.addRunBody(this.processTranslatableAttributes(e), events);
        }
    }

    private XMLEvent processTranslatableAttributes(XMLEvent e) {
        if (!e.isStartElement()) {
            return e;
        }
        StartElement startEl = e.asStartElement();
        if (XMLEventHelpers.isGraphicsProperty(startEl) && !this.params.getTranslateWordExcludeGraphicMetaData()) {
            startEl = this.processTranslatableAttribute(startEl, "name");
        } else if (XMLEventHelpers.isTextPath(startEl)) {
            startEl = this.processTranslatableAttribute(startEl, "string");
        }
        return startEl;
    }

    private StartElement processTranslatableAttribute(StartElement startEl, String attrName) {
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = startEl.getAttributes();
        boolean dirty = false;
        while (it.hasNext()) {
            Attribute a = it.next();
            if (a.getName().getLocalPart().equals(attrName)) {
                this.containsNestedItems = true;
                this.nestedTextualItems.add(new UnstyledText(a.getValue()));
                newAttrs.add(this.eventFactory.createAttribute(a.getName(), TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
                dirty = true;
                continue;
            }
            newAttrs.add(a);
        }
        return dirty ? this.eventFactory.createStartElement(startEl.getName(), newAttrs.iterator(), startEl.getNamespaces()) : startEl;
    }

    private void addRunBody(XMLEvent e, XMLEventReader events) throws XMLStreamException {
        if (XMLEventHelpers.isTextStartEvent(e)) {
            this.flushMarkupChunk();
            this.processText(e.asStartElement(), events);
        } else if (this.params.getAddTabAsCharacter() && XMLEventHelpers.isTabStartEvent(e)) {
            this.flushMarkupChunk();
            this.addRawText("\t", e.asStartElement(), events);
        } else if (this.params.getAddLineSeparatorCharacter() && XMLEventHelpers.isLineBreakStartEvent(e)) {
            this.flushMarkupChunk();
            this.addRawText("\n", e.asStartElement(), events);
        } else if (e.isStartElement() && this.isStrippableRunBodyElement(e.asStartElement())) {
            ElementSkipper.GeneralElementSkipper.skipElementEvents(events, e.asStartElement());
        } else if (this.params.getReplaceNoBreakHyphenTag() && XMLEventHelpers.isNoBreakHyphenStartEvent(e)) {
            this.flushMarkupChunk();
            this.addRawText("-", e.asStartElement(), events);
        } else if (this.params.getIgnoreSoftHyphenTag() && XMLEventHelpers.isSoftHyphenStartEvent(e)) {
            ElementSkipper.GeneralElementSkipper.skipElementEvents(events, e.asStartElement());
        } else if (!XMLEventHelpers.isWhitespace(e) || this.inPreservingWhitespaceElement()) {
            this.flushText();
            this.isTextPreservingWhitespace = false;
            this.addToMarkupChunk(e);
        }
    }

    private boolean inPreservingWhitespaceElement() {
        XMLEvent e;
        return this.currentMarkupChunk.size() > 0 && (e = this.currentMarkupChunk.get(this.currentMarkupChunk.size() - 1)) instanceof StartElement && XMLEventHelpers.hasPreserveWhitespace(e.asStartElement());
    }

    private void processText(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        this.hadAnyText = true;
        boolean bl = this.isTextPreservingWhitespace = this.isTextPreservingWhitespace ? true : XMLEventHelpers.hasPreserveWhitespace(startEvent);
        if (this.textName == null) {
            this.textName = startEvent.getName();
        }
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            if (XMLEventHelpers.isEndElement(e, startEvent)) {
                return;
            }
            if (!e.isCharacters()) continue;
            String text = e.asCharacters().getData();
            if (text.trim().length() > 0) {
                this.hadNonWhitespaceText = true;
            }
            this.textContent.append(text);
        }
    }

    private void flushText() {
        if (this.hadAnyText) {
            this.runBodyChunks.add(new Run.RunText(this.createTextStart(), this.eventFactory.createCharacters(this.textContent.toString()), this.eventFactory.createEndElement(this.textName, null)));
            this.textContent.setLength(0);
            this.hadAnyText = false;
        }
    }

    private StartElement createTextStart() {
        return this.eventFactory.createStartElement(this.textName, this.isTextPreservingWhitespace && !Namespaces.DrawingML.containsName(this.textName) ? Collections.singleton(this.eventFactory.createAttribute("xml", Namespaces.XML.getURI(), "space", "preserve")).iterator() : null, null);
    }

    private boolean isStrippableRunBodyElement(StartElement el) {
        return el.getName().equals(XMLEventHelpers.CACHED_PAGE_BREAK);
    }

    private void addRawText(String text, StartElement startEl, XMLEventReader events) throws XMLStreamException {
        this.hadAnyText = true;
        this.textContent.append(text);
        if (startEl != null) {
            ElementSkipper.GeneralElementSkipper.skipElementEvents(events, startEl);
        }
        if (this.textName == null) {
            this.textName = new QName(startEl.getName().getNamespaceURI(), "t", startEl.getName().getPrefix());
        }
    }

    private void addToMarkupChunk(XMLEvent event) {
        this.currentMarkupChunk.add(event);
    }

    private void flushMarkupChunk() {
        if (this.currentMarkupChunk.size() > 0) {
            this.runBodyChunks.add(new Run.RunMarkup().addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupChunk)));
            this.currentMarkupChunk = new ArrayList<XMLEvent>();
        }
    }

    private void log(String s) {
        LOGGER.debug(s);
    }

    class XMLListEventReader
    implements XMLEventReader {
        private Iterator<XMLEvent> events;

        XMLListEventReader(Iterable<XMLEvent> events) {
            this.events = events.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.events.hasNext();
        }

        @Override
        public XMLEvent nextEvent() {
            return this.events.next();
        }

        @Override
        public void remove() {
            this.events.remove();
        }

        @Override
        public XMLEvent nextTag() throws XMLStreamException {
            XMLEvent e = this.nextEvent();
            while (e != null) {
                if (e.isStartElement() || e.isEndElement()) {
                    return e;
                }
                if (!XMLEventHelpers.isWhitespace(e)) {
                    throw new IllegalStateException("Unexpected event: " + e);
                }
                e = this.nextEvent();
            }
            return null;
        }

        @Override
        public XMLEvent peek() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getElementText() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws XMLStreamException {
        }

        @Override
        public Object next() {
            return this.events.next();
        }
    }
}

