/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.ReplaceableRunProperty;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

public abstract class RunProperty
implements Property,
ReplaceableRunProperty {
    private boolean isHidden = false;

    RunProperty(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof RunProperty)) {
            return false;
        }
        return this.equalsProperty((RunProperty)o);
    }

    protected abstract boolean equalsProperty(RunProperty var1);

    public abstract int hashCode();

    @Override
    public abstract List<XMLEvent> getEvents();

    @Override
    public boolean canBeReplaced(ReplaceableRunProperty runProperty) {
        return this.equalsProperty((RunProperty)runProperty);
    }

    @Override
    public ReplaceableRunProperty replace(ReplaceableRunProperty runProperty) {
        return runProperty;
    }

    @Override
    public abstract QName getName();

    static class FontsRunProperty
    extends RunProperty
    implements MergeableRunProperty {
        private RunFonts runFonts;

        public FontsRunProperty(RunFonts runFonts, boolean shouldBeHidden) {
            super(shouldBeHidden);
            this.runFonts = runFonts;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.runFonts.getEvents();
        }

        @Override
        public QName getName() {
            return this.getEvents().get(0).asStartElement().getName();
        }

        @Override
        public boolean canBeMerged(MergeableRunProperty runProperty) {
            if (!(runProperty instanceof FontsRunProperty)) {
                return false;
            }
            return this.runFonts.canBeMerged(((FontsRunProperty)runProperty).runFonts);
        }

        @Override
        public MergeableRunProperty merge(MergeableRunProperty runProperty) {
            this.runFonts = this.runFonts.merge(((FontsRunProperty)runProperty).runFonts);
            return this;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof FontsRunProperty)) {
                return false;
            }
            return this.runFonts.equals(((FontsRunProperty)runProperty).runFonts);
        }

        @Override
        public int hashCode() {
            return this.runFonts.hashCode();
        }

        public String toString() {
            return FontsRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class AttributeRunProperty
    extends RunProperty {
        private Attribute attr;

        AttributeRunProperty(Attribute attr, boolean isHidden) {
            super(isHidden);
            this.attr = attr;
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof AttributeRunProperty)) {
                return false;
            }
            return XMLEventHelpers.attrEquals(this.attr, ((AttributeRunProperty)rp).attr);
        }

        @Override
        public int hashCode() {
            return this.attr.hashCode();
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public QName getName() {
            return this.attr.getName();
        }

        public String toString() {
            return "AttributeRunProperty(" + this.attr + ")";
        }
    }

    static class ToggleRunProperty
    extends GenericRunProperty {
        private boolean value;

        ToggleRunProperty(List<XMLEvent> events, boolean isHidden) {
            super(events, isHidden);
            this.value = XMLEventHelpers.getBooleanAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE);
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof ToggleRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.getEvents().get(0), runProperty.getEvents().get(0)) && Objects.equals(this.value, ((ToggleRunProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public String toString() {
            return ToggleRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class RunStyleProperty
    extends GenericRunProperty {
        private String runStyle;

        RunStyleProperty(List<XMLEvent> events, boolean isHidden) {
            super(events, isHidden);
            this.runStyle = XMLEventHelpers.getAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }

        public String getRunStyle() {
            return this.runStyle;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof RunStyleProperty)) {
                return false;
            }
            return Objects.equals(this.runStyle, ((RunStyleProperty)runProperty).runStyle);
        }

        @Override
        public int hashCode() {
            return this.runStyle.hashCode();
        }

        @Override
        public String toString() {
            return RunStyleProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class GenericRunProperty
    extends RunProperty {
        private List<XMLEvent> events = new ArrayList<XMLEvent>();

        GenericRunProperty(List<XMLEvent> events, boolean isHidden) {
            super(isHidden);
            this.events.addAll(events);
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof GenericRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.events, ((GenericRunProperty)rp).events);
        }

        @Override
        public int hashCode() {
            return this.events.hashCode();
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.events;
        }

        @Override
        public QName getName() {
            return this.events.get(0).asStartElement().getName();
        }

        public String toString() {
            return "GenericRunProperty(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }
}

