/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentFilterBasedPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringsDenormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedStringPartHandler
extends ContentFilterBasedPartHandler {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private SharedStringMap sharedStringMap;
    private File rewrittenStringsTable;

    public SharedStringPartHandler(OpenXMLZipFile zipFile, ZipEntry entry, SharedStringMap sharedStringMap, ConditionalParameters cparams) {
        super(new OpenXMLContentFilter(cparams), cparams, zipFile, entry);
        this.sharedStringMap = sharedStringMap;
    }

    @Override
    public Event open(String docId, String subDocId, LocaleId srcLang) throws IOException {
        try {
            SharedStringsDenormalizer deno = new SharedStringsDenormalizer(this.zipFile.getEventFactory(), this.sharedStringMap);
            XMLEventReader reader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8));
            this.rewrittenStringsTable = File.createTempFile("sharedStrings", ".xml");
            XMLEventWriter writer = this.zipFile.getOutputFactory().createXMLEventWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.rewrittenStringsTable), StandardCharsets.UTF_8));
            deno.process(reader, writer);
            this.contentFilter.setUpConfig(ParseType.MSEXCEL);
            this.contentFilter.setPartName(this.entry.getName());
            this.contentFilter.setExcelVisibleSharedStrings(new SomeStringsExcluded());
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.rewrittenStringsTable));
            return this.openContentFilter(is, docId, subDocId, srcLang);
        }
        catch (XMLStreamException e) {
            throw new OkapiBadFilterInputException(e);
        }
    }

    @Override
    public void close() {
        super.close();
        if (!this.rewrittenStringsTable.delete()) {
            this.LOGGER.warn("Couldn't clean up temp file.");
        }
    }

    class SomeStringsExcluded
    implements SharedStringVisibilityStrategy {
        SomeStringsExcluded() {
        }

        @Override
        public boolean isVisible(int stringIndex) {
            return SharedStringPartHandler.this.sharedStringMap.isStringVisible(stringIndex);
        }
    }

    static interface SharedStringVisibilityStrategy {
        public boolean isVisible(int var1);
    }
}

