/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.BlockTextUnitMapper;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

public class StyledTextPartHandler
implements OpenXMLPartHandler {
    private OpenXMLZipFile zipFile;
    private ZipEntry entry;
    private ConditionalParameters params;
    private XMLEventFactory eventFactory;
    private String partName;
    private StyleDefinitions styleDefinitions;
    private ElementSkipper tablePropertiesChangeElementSkipper;
    private ElementSkipper noElementSkipper;
    private ElementSkipper revisionPropertyChangeElementSkipper;
    private IdGenerator documentPartId;
    private IdGenerator textUnitId;
    private IdGenerator nestedBlockId;
    private XMLEventReader xmlReader;
    private List<Event> filterEvents = new ArrayList<Event>();
    private Iterator<Event> filterEventIterator;
    private String docId;
    private String subDocId;
    private List<XMLEvent> documentPartEvents = new ArrayList<XMLEvent>();
    private Markup markup = new Block.BlockMarkup();

    StyledTextPartHandler(ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry, StyleDefinitions styleDefinitions) {
        this(cparams, zipFile.getEventFactory(), entry.getName(), styleDefinitions);
        this.zipFile = zipFile;
        this.entry = entry;
    }

    StyledTextPartHandler(ConditionalParameters cparams, XMLEventFactory eventFactory, String partName, StyleDefinitions styleDefinitions) {
        this.params = cparams;
        this.eventFactory = eventFactory;
        this.partName = partName;
        this.styleDefinitions = styleDefinitions;
        this.tablePropertiesChangeElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(ElementSkipper.RevisionPropertySkippableElement.TABLE_PROPERTIES_CHANGE);
        this.noElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(new ElementSkipper.SkippableElement[0]);
        this.revisionPropertyChangeElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(ElementSkipper.RevisionPropertySkippableElement.SECTION_PROPERTIES_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_GRID_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_PROPERTIES_EXCEPTIONS_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_ROW_PROPERTIES_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_CELL_PROPERTIES_CHANGE);
        this.documentPartId = new IdGenerator(partName, "dp");
        this.textUnitId = new IdGenerator(partName, "tu");
        this.nestedBlockId = new IdGenerator(null);
    }

    @Override
    public Event open(String docId, String subDocId, LocaleId srcLang) throws IOException, XMLStreamException {
        this.docId = docId;
        this.subDocId = subDocId;
        this.xmlReader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        return this.open(docId, subDocId, this.xmlReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event open(String docId, String subDocId, XMLEventReader xmlReader) throws XMLStreamException {
        this.xmlReader = xmlReader;
        try {
            this.process();
        }
        finally {
            if (xmlReader != null) {
                xmlReader.close();
            }
        }
        return this.createStartSubDocumentEvent(docId, subDocId);
    }

    private Event createStartSubDocumentEvent(String docId, String subDocId) {
        StartSubDocument sd = new StartSubDocument(docId, subDocId);
        sd.setName(this.partName);
        if (this.zipFile != null) {
            ZipSkeleton zs = new ZipSkeleton(this.zipFile.getZip(), this.entry);
            sd.setSkeleton(zs);
        }
        ConditionalParameters clonedParams = this.params.clone();
        clonedParams.nFileType = ParseType.MSWORD;
        sd.setFilterParameters(clonedParams);
        return new Event(EventType.START_SUBDOCUMENT, sd);
    }

    private void process() throws XMLStreamException {
        while (this.xmlReader.hasNext()) {
            XMLEvent e = this.xmlReader.nextEvent();
            if (XMLEventHelpers.isParagraphStartEvent(e)) {
                this.flushDocumentPart();
                Block block = new BlockParser(e.asStartElement(), this.xmlReader, this.eventFactory, this.params, this.nestedBlockId, this.styleDefinitions).parse();
                if (block.isHidden()) {
                    this.documentPartEvents.addAll(block.getEvents());
                    continue;
                }
                BlockTextUnitMapper mapper = new BlockTextUnitMapper(block, this.textUnitId);
                if (mapper.getTextUnits().isEmpty()) {
                    this.addBlockChunksToDocumentPart(block.getChunks());
                    continue;
                }
                for (ITextUnit tu : mapper.getTextUnits()) {
                    this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
                }
                continue;
            }
            if (XMLEventHelpers.isBlockMarkupStartEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createStartMarkupComponent(this.eventFactory, e.asStartElement()));
                continue;
            }
            if (XMLEventHelpers.isTablePropertiesStartEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentParser.parseBlockProperties(this.xmlReader, this.eventFactory, e.asStartElement(), this.tablePropertiesChangeElementSkipper));
                continue;
            }
            if (XMLEventHelpers.isTextBodyPropertiesStartEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentParser.parseBlockProperties(this.xmlReader, this.eventFactory, e.asStartElement(), this.noElementSkipper));
                continue;
            }
            if (XMLEventHelpers.isBlockMarkupEndEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                continue;
            }
            if (e.isStartElement() && this.revisionPropertyChangeElementSkipper.isSkippableElement(e.asStartElement())) {
                this.revisionPropertyChangeElementSkipper.skipElement(this.xmlReader, e.asStartElement());
                continue;
            }
            if (XMLEventHelpers.isSectionPropertiesStartEvent(e)) {
                e = AttributeStripper.RevisionAttributeStripper.stripSectionPropertiesRevisionAttributes(this.eventFactory, e.asStartElement());
            } else if (XMLEventHelpers.isTableRowStartEvent(e)) {
                e = AttributeStripper.RevisionAttributeStripper.stripTableRowRevisionAttributes(this.eventFactory, e.asStartElement());
            }
            this.addEventToDocumentPart(e);
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private void addEventToDocumentPart(XMLEvent e) {
        this.documentPartEvents.add(e);
    }

    private void addMarkupComponentToDocumentPart(MarkupComponent markupComponent) {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList<XMLEvent>();
        }
        this.markup.addComponent(markupComponent);
    }

    private void addBlockChunksToDocumentPart(List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            if (chunk instanceof Markup) {
                for (MarkupComponent markupComponent : ((Markup)chunk).getComponents()) {
                    this.addMarkupComponentToDocumentPart(markupComponent);
                }
                continue;
            }
            this.documentPartEvents.addAll(chunk.getEvents());
        }
    }

    private void flushDocumentPart() {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList<XMLEvent>();
        }
        if (!this.markup.getComponents().isEmpty()) {
            DocumentPart documentPart = new DocumentPart(this.documentPartId.createId(), false);
            documentPart.setSkeleton(new MarkupSkeleton(this.markup));
            this.markup = new Block.BlockMarkup();
            this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        }
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

