/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.filters.openxml.XMLEvents;

public class XMLEventSerializer {
    private StringBuilder sb = new StringBuilder();
    private XMLEncoder elementEncoder = new XMLEncoder("UTF-8", "\n", true, true, false, XMLEncoder.QuoteMode.UNESCAPED);
    private XMLEncoder attrEncoder = new XMLEncoder("UTF-8", "\n", true, true, false, XMLEncoder.QuoteMode.ALL);
    private StartElement pendingStartElement;

    public static String serialize(XMLEvent event) {
        return XMLEventSerializer.serialize(Collections.singletonList(event));
    }

    public static String serialize(XMLEvents events) {
        return XMLEventSerializer.serialize(events.getEvents());
    }

    public static String serialize(List<XMLEvent> events) {
        return new XMLEventSerializer().addAll(events).toString();
    }

    public XMLEventSerializer add(XMLEvents events) {
        return this.addAll(events.getEvents());
    }

    public XMLEventSerializer addAll(List<XMLEvent> events) {
        for (XMLEvent e : events) {
            this.add(e);
        }
        return this;
    }

    public XMLEventSerializer add(XMLEvent e) {
        if (this.pendingStartElement != null) {
            if (e.isEndElement() && this.pendingStartElement.getName().equals(e.asEndElement().getName())) {
                this.flushPendingStartElement(true);
                return this;
            }
            this.flushPendingStartElement(false);
        }
        switch (e.getEventType()) {
            case 1: {
                this.addStartElement(e.asStartElement());
                break;
            }
            case 4: {
                this.addCharacters(e.asCharacters());
                break;
            }
            case 2: {
                this.addEndElement(e.asEndElement());
                break;
            }
        }
        return this;
    }

    private void addStartElement(StartElement e) {
        this.pendingStartElement = e;
    }

    private void writeStartElement(StartElement e) {
        Iterator<Attribute> attrs = e.getAttributes();
        Iterator<Namespace> ns = e.getNamespaces();
        QName name = e.getName();
        this.sb.append('<');
        XMLEventSerializer.addName(name, this.sb);
        while (ns.hasNext()) {
            Namespace namespace = ns.next();
            this.sb.append(" xmlns");
            if (!"".equals(namespace.getPrefix())) {
                this.sb.append(":").append(namespace.getPrefix());
            }
            this.sb.append("=\"").append(namespace.getNamespaceURI()).append("\"");
        }
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            this.sb.append(' ');
            XMLEventSerializer.addName(attr.getName(), this.sb);
            this.sb.append("=\"").append(this.escapeAttrValue(attr.getValue())).append("\"");
        }
    }

    private static void addName(QName name, StringBuilder buffer) {
        String prefix = name.getPrefix();
        if (prefix != null && !"".equals(prefix)) {
            buffer.append(prefix).append(":");
        }
        buffer.append(name.getLocalPart());
    }

    private String escapeAttrValue(String v) {
        return this.attrEncoder.encode(v, EncoderContext.INLINE);
    }

    private void flushPendingStartElement(boolean isSingleton) {
        if (this.pendingStartElement == null) {
            return;
        }
        this.writeStartElement(this.pendingStartElement);
        if (isSingleton) {
            this.sb.append("/>");
        } else {
            this.sb.append(">");
        }
        this.pendingStartElement = null;
    }

    private void addEndElement(EndElement e) {
        QName name = e.getName();
        this.sb.append("</");
        XMLEventSerializer.addName(name, this.sb);
        this.sb.append(">");
    }

    private void addCharacters(Characters e) {
        this.sb.append(this.elementEncoder.encode(e.getData(), EncoderContext.TEXT));
    }

    public String toString() {
        this.flushPendingStartElement(false);
        return this.sb.toString();
    }
}

