/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.CTagCommon;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;

public class CTag
extends Tag {
    protected CTagCommon cc = null;
    private String data;
    private boolean initialWithData;
    private String dataRef;
    private Directionality dataDir = Directionality.AUTO;
    private String disp;
    private String equiv = "";
    private String subFlows;
    private CanReorder canReorder = CanReorder.YES;

    CTag(CTagCommon cc, TagType tagType, String id, String data) {
        this.cc = cc == null ? new CTagCommon(id) : cc;
        this.tagType = tagType;
        this.data = data;
    }

    public CTag(TagType tagType, String id, String data) {
        this(null, tagType, id, data);
    }

    CTag(CTag opposite, String data) {
        switch (opposite.tagType) {
            case CLOSING: {
                this.tagType = TagType.OPENING;
                break;
            }
            case OPENING: {
                this.tagType = TagType.CLOSING;
                break;
            }
            default: {
                throw new InvalidParameterException("Counterpart must be an opening or closing tag.");
            }
        }
        this.cc = opposite.cc;
        this.data = data;
    }

    CTag(CTag original, CTag opposite) {
        super(original);
        this.cc = opposite == null ? new CTagCommon(original.cc) : opposite.cc;
        this.data = original.data;
        this.dataDir = original.dataDir;
        this.dataRef = original.dataRef;
        this.initialWithData = original.initialWithData;
        this.canReorder = original.canReorder;
        this.disp = original.disp;
        this.equiv = original.equiv;
        this.subFlows = original.subFlows;
    }

    @Override
    public boolean equals(Tag tag) {
        if (tag == null) {
            return false;
        }
        if (this == tag) {
            return true;
        }
        if (!(tag instanceof CTag)) {
            return false;
        }
        CTag ctag = (CTag)tag;
        if (this.tagType.compareTo(ctag.getTagType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.getId(), ctag.getId()) != 0) {
            return false;
        }
        if (!this.cc.equals(ctag.cc)) {
            return false;
        }
        if (Util.compareAllowingNull(this.data, ctag.getData()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.dataRef, ctag.getDataRef()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.subFlows, ctag.getSubFlows()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.disp, ctag.getDisp()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.equiv, ctag.getEquiv()) != 0) {
            return false;
        }
        if (!this.getCanReorder().equals((Object)ctag.getCanReorder())) {
            return false;
        }
        if (this.initialWithData != ctag.initialWithData) {
            return false;
        }
        return this.dataDir == ctag.dataDir;
    }

    @Override
    public boolean isCode() {
        return true;
    }

    @Override
    public boolean isMarker() {
        return false;
    }

    @Override
    public String getId() {
        return this.cc.getId();
    }

    @Override
    public String getType() {
        return this.cc.getType();
    }

    @Override
    public void setType(String type) {
        this.cc.setType(type);
    }

    public String getSubType() {
        return this.cc.getSubType();
    }

    public void setSubType(String subType) {
        this.cc.setSubType(subType);
    }

    public boolean getCanCopy() {
        return this.cc.getCanCopy();
    }

    public void setCanCopy(boolean canCopy) {
        this.cc.setCanCopy(canCopy);
    }

    public boolean getCanOverlap() {
        return this.cc.getCanOverlap();
    }

    public void setCanOverlap(boolean canOverlap) {
        this.cc.setCanOverlap(canOverlap);
    }

    public boolean getCanDelete() {
        return this.cc.getCanDelete();
    }

    public void setCanDelete(boolean canDelete) {
        this.cc.setCanDelete(canDelete);
    }

    public CanReorder getCanReorder() {
        if (this.tagType == TagType.CLOSING && this.canReorder == CanReorder.FIRSTNO) {
            return CanReorder.NO;
        }
        return this.canReorder;
    }

    public void setCanReorder(CanReorder canReorder) {
        this.canReorder = canReorder;
        if (canReorder != CanReorder.YES) {
            this.setCanDelete(false);
            this.setCanCopy(false);
        }
    }

    public String getCopyOf() {
        return this.cc.getCopyOf();
    }

    public void setCopyOf(String id) {
        this.cc.setCopyOf(id);
    }

    public boolean hasData() {
        return !Util.isNoE(this.data);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getDataRef() {
        return this.dataRef;
    }

    public void setDataRef(String dataRef) {
        this.dataRef = dataRef;
    }

    public boolean isInitialWithData() {
        return this.initialWithData;
    }

    public void setInitialWithData(boolean initialWithData) {
        this.initialWithData = initialWithData;
    }

    public Directionality getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(Directionality dir) {
        this.dataDir = dir;
    }

    public String getDisp() {
        return this.disp;
    }

    public void setDisp(String disp) {
        this.disp = disp;
    }

    public String getEquiv() {
        return this.equiv;
    }

    public void setEquiv(String equiv) {
        if (equiv == null) {
            this.equiv = "";
        }
        this.equiv = equiv;
    }

    public String getSubFlows() {
        return this.subFlows;
    }

    public void setSubFlows(String subFlows) {
        if (subFlows == null) {
            this.subFlows = null;
            return;
        }
        String[] ids = subFlows.split("[\\t\\n ]+", -1);
        String value = "";
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.isEmpty()) {
                if (!value.isEmpty()) {
                    value = String.valueOf(value) + " ";
                }
                value = String.valueOf(value) + id;
            }
            ++n2;
        }
        this.subFlows = value;
    }

    public String[] getSubFlowsIds() {
        if (this.subFlows == null) {
            return new String[0];
        }
        return this.subFlows.split(" ", -1);
    }

    public Directionality getDir() {
        return this.cc.getDir();
    }

    public void setDir(Directionality dir) {
        this.cc.setDir(dir);
    }

    public void verifyTypeSubTypeValues() {
        if (this.cc.getSubType() == null) {
            return;
        }
        String type = this.getType();
        switch (this.cc.getSubType()) {
            case "xlf:lb": 
            case "xlf:pb": 
            case "xlf:b": 
            case "xlf:i": 
            case "xlf:u": {
                if (type != null && type.equals("fmt")) break;
                throw new InvalidParameterException(String.format("When subType is '%s', type must be 'fmt'.", this.cc.getSubType()));
            }
            case "xlf:var": {
                if (type != null && type.equals("ui")) break;
                throw new InvalidParameterException(String.format("When subType is '%s', type must be 'fmt'.", this.cc.getSubType()));
            }
        }
    }
}

