/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.Tags;

public class Part {
    private Store store;
    private Fragment source;
    private Fragment target;
    private String id;
    private int targetOrder;
    private boolean preserveWS = false;

    public Part(Part original) {
        this.store = original.store;
        this.source = new Fragment(original.source, this.store, false);
        if (original.hasTarget()) {
            this.target = new Fragment(original.target, this.store, true);
        }
        this.id = original.id;
        this.targetOrder = original.targetOrder;
        this.preserveWS = original.preserveWS;
    }

    public Part(Store store) {
        this.store = store;
        this.source = new Fragment(store, false);
    }

    public Part(Store store, String sourceContent) {
        this.store = store;
        this.source = new Fragment(store, false, sourceContent);
    }

    public String getId() {
        return this.id;
    }

    public String getId(boolean createIfNeeded) {
        if (this.id == null && createIfNeeded) {
            this.id = this.getStore().suggestId(true);
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getPreserveWS() {
        return this.preserveWS;
    }

    public void setPreserveWS(boolean preserveWS) {
        this.preserveWS = preserveWS;
    }

    public Fragment getSource() {
        return this.source;
    }

    public Fragment setSource(Fragment fragment) {
        if (this.store != fragment.getStore()) {
            throw new XLIFFException("The fragment passed in setSource must use the same codes store.");
        }
        this.source = fragment;
        return this.source;
    }

    public Fragment setSource(String plainText) {
        this.source = new Fragment(this.store, false, plainText);
        return this.source;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public Fragment getTarget(GetTarget creationOption) {
        if (this.target == null) {
            switch (creationOption) {
                case DONT_CREATE: {
                    break;
                }
                case CREATE_EMPTY: {
                    this.target = new Fragment(this.store, true);
                    break;
                }
                case CLONE_SOURCE: {
                    this.target = new Fragment(this.source, this.source.getStore(), true);
                }
            }
        }
        return this.target;
    }

    public Fragment getTarget() {
        return this.target;
    }

    public Fragment setTarget(Fragment fragment) {
        if (this.store != fragment.getStore()) {
            throw new XLIFFException("The fragment passed in setTarget must use the same codes store.");
        }
        this.target = fragment;
        return this.target;
    }

    public Fragment setTarget(String plainText) {
        this.target = new Fragment(this.store, true, plainText);
        return this.target;
    }

    public Tags getSourceTags() {
        return this.store.getSourceTags();
    }

    public Tags getTargetTags() {
        return this.store.getTargetTags();
    }

    public void setTargetOrder(int targetOrder) {
        this.targetOrder = targetOrder;
    }

    public int getTargetOrder() {
        return this.targetOrder;
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isSegment() {
        return false;
    }

    public void removeMarkers(boolean target, String type) {
        Tags tags;
        Fragment frag;
        if (target) {
            if (!this.hasTarget()) {
                return;
            }
            frag = this.getTarget();
            tags = this.getStore().getTargetTags();
        } else {
            frag = this.getSource();
            tags = this.getStore().getSourceTags();
        }
        String ct = frag.getCodedText();
        int i = 0;
        while (i < ct.length()) {
            if (Fragment.isChar1(ct.charAt(i))) {
                Tag tag = tags.get((CharSequence)ct, i);
                if (tag.isMarker()) {
                    if (type == null || type.equals(tag.getType())) {
                        frag.remove(tag);
                    }
                } else {
                    ++i;
                }
            }
            ++i;
        }
    }

    public void showProtectedContent() {
        this.getSource().showProtectedContent();
        if (this.hasTarget()) {
            this.getTarget().showProtectedContent();
        }
    }

    public static enum GetTarget {
        DONT_CREATE,
        CREATE_EMPTY,
        CLONE_SOURCE;

    }
}

