/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.InheritedData;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.DataCategoryGroup;
import net.sf.okapi.lib.xliff2.its.Domain;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.IWithITSAttributes;
import net.sf.okapi.lib.xliff2.its.LocQualityIssue;
import net.sf.okapi.lib.xliff2.its.LocQualityIssues;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.its.Provenance;
import net.sf.okapi.lib.xliff2.its.Provenances;
import net.sf.okapi.lib.xliff2.its.TermTag;
import net.sf.okapi.lib.xliff2.its.TextAnalysis;

public class ITSWriter {
    public static IITSItem annotate(Fragment fragment, int start, int end, IITSItem item) {
        MTag am = new MTag(fragment.getStore().suggestId(false), "its:any");
        am.getITSItems().add(item);
        fragment.annotate(start, end, am);
        return item;
    }

    public static MTag annotate(Fragment fragment, int start, int end, IITSItem item, String matchingType) {
        MTag am = fragment.getOrCreateMarker(start, end, matchingType, "its:any");
        am.getITSItems().add(item);
        return am;
    }

    public static void addDeclaration(StartXliffData sxd) {
        sxd.setNamespace("its", "http://www.w3.org/2005/11/its");
        sxd.setNamespace("itsxlf", "http://www.w3.org/ns/its-xliff/");
        sxd.getExtAttributes().setAttribute("http://www.w3.org/2005/11/its", "version", "2.0");
    }

    public String outputStandOffElements(String indent, String lb, Unit unit) {
        List<DataCategoryGroup<?>> list = null;
        if (unit.getStore().hasSourceTag()) {
            list = this.checkForGroups(list, unit.getStore().getSourceTags());
        }
        if (unit.getStore().hasTargetTag()) {
            list = this.checkForGroups(list, unit.getStore().getTargetTags());
        }
        if ((list = this.checkForGroups(list, unit)) == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (DataCategoryGroup<?> group : list) {
            if (group instanceof LocQualityIssues) {
                LocQualityIssues issues = (LocQualityIssues)group;
                out.append(String.valueOf(indent) + "<its:" + "locQualityIssues" + " xml:id=\"" + issues.getGroupId() + "\">\n");
                for (LocQualityIssue lqi : issues.getList()) {
                    out.append(String.valueOf(indent) + " <its:" + "locQualityIssue");
                    out.append(this.outputLQIAttributes(lqi, false));
                    out.append("/>" + lb);
                }
                out.append(String.valueOf(indent) + "</its:" + "locQualityIssues" + ">" + lb);
                continue;
            }
            if (!(group instanceof Provenances)) continue;
            Provenances recs = (Provenances)group;
            out.append(String.valueOf(indent) + "<its:" + "provenanceRecords" + " xml:id=\"" + recs.getGroupId() + "\">\n");
            for (Provenance prov : recs.getList()) {
                out.append(String.valueOf(indent) + " <its:" + "provenanceRecord");
                out.append(this.outputProvenanceAttributes(prov, false));
                out.append("/>" + lb);
            }
            out.append(String.valueOf(indent) + "</its:" + "provenanceRecords" + ">" + lb);
        }
        return out.toString();
    }

    public List<AbstractMap.SimpleEntry<String, AnnotatorsRef>> createAnnotatorsRefList(Stack<InheritedData> context) {
        ArrayList<AbstractMap.SimpleEntry<String, AnnotatorsRef>> list = new ArrayList<AbstractMap.SimpleEntry<String, AnnotatorsRef>>(3);
        if (context == null || context.isEmpty()) {
            list.add(new AbstractMap.SimpleEntry<String, Object>("_#_", null));
        } else {
            list.add(new AbstractMap.SimpleEntry<String, AnnotatorsRef>("_#_", context.peek().getAnnotatorsRef()));
        }
        return list;
    }

    public AnnotatorsRef createAnnotatorsRef(IWithITSAttributes object) {
        if (object instanceof TermTag) {
            AnnotatorsRef ar = new AnnotatorsRef();
            TermTag tm = (TermTag)object;
            ar.set(tm.getDataCategoryName(), tm.getAnnotatorRef());
            return ar;
        }
        if (!object.hasITSItem()) {
            return null;
        }
        AnnotatorsRef ar = new AnnotatorsRef();
        for (IITSItem item : object.getITSItems()) {
            ar.set(item);
        }
        return ar;
    }

    public String outputAttributes(IWithITSAttributes object, AnnotatorsRef objectAR, AnnotatorsRef parentAR) {
        if (object instanceof TermTag) {
            return this.outputTerminologyAttributes((TermTag)object, parentAR);
        }
        if (!object.hasITSItem()) {
            if (objectAR == null) {
                return "";
            }
            return objectAR.printDifferences(parentAR);
        }
        if (objectAR == null) {
            if (parentAR != null) {
                return parentAR.printDifferences(null);
            }
            return this.createAnnotatorsRef(object).print();
        }
        String arOut = objectAR.printDifferences(parentAR);
        if (!object.hasITSItem()) {
            return arOut;
        }
        StringBuilder atOut = new StringBuilder();
        for (IITSItem item : object.getITSItems()) {
            if (item instanceof LocQualityIssues) {
                atOut.append(" its:locQualityIssuesRef=\"#its=" + ((DataCategoryGroup)item).getGroupId() + "\"");
                continue;
            }
            if (item instanceof Provenances) {
                atOut.append(" its:provenanceRecordsRef=\"#its=" + ((DataCategoryGroup)item).getGroupId() + "\"");
                continue;
            }
            if (item instanceof LocQualityIssue) {
                atOut.append(this.outputLQIAttributes((LocQualityIssue)item, true));
                continue;
            }
            if (item instanceof Provenance) {
                atOut.append(this.outputProvenanceAttributes((Provenance)item, true));
                continue;
            }
            if (item instanceof MTConfidence) {
                atOut.append(" its:mtConfidence=\"" + this.format(((MTConfidence)item).getMtConfidence()) + "\"");
                continue;
            }
            if (item instanceof TextAnalysis) {
                atOut.append(this.outputTextAnalysisAttributes((TextAnalysis)item, true));
                continue;
            }
            if (!(item instanceof Domain)) continue;
            atOut.append(" itsxlf:domains=\"" + Util.toXML(((Domain)item).getDomain(), true) + "\"");
        }
        if (!arOut.isEmpty()) {
            atOut.append(arOut);
        }
        return atOut.toString();
    }

    private String outputTerminologyAttributes(TermTag marker, AnnotatorsRef parentAR) {
        String arValue;
        StringBuilder out = new StringBuilder();
        if (marker.getTermConfidence() != null) {
            out.append(" itsxlf:termConfidence=\"" + marker.getTermConfidence().toString() + "\"");
        }
        if ((arValue = marker.getAnnotatorRef()) != null && parentAR != null && arValue.equals(parentAR.get(marker.getDataCategoryName()))) {
            arValue = null;
        }
        if (arValue != null) {
            out.append(" its:annotatorsRef=\"" + marker.getDataCategoryName() + "|" + arValue + "\"");
        }
        return out.toString();
    }

    private String outputLQIAttributes(LocQualityIssue lqi, boolean withPrefix) {
        String front = withPrefix ? " its:" : " ";
        StringBuilder out = new StringBuilder();
        if (lqi.getType() != null) {
            out.append(String.valueOf(front) + "locQualityIssueType" + "=\"" + lqi.getType() + "\"");
        }
        if (lqi.getComment() != null) {
            out.append(String.valueOf(front) + "locQualityIssueComment" + "=\"" + Util.toXML(lqi.getComment(), true) + "\"");
        }
        if (!lqi.isEnabled()) {
            out.append(String.valueOf(front) + "locQualityIssueEnabled" + "=\"no\"");
        }
        if (lqi.getSeverity() != null) {
            out.append(String.valueOf(front) + "locQualityIssueSeverity" + "=\"" + this.format(lqi.getSeverity()) + "\"");
        }
        if (lqi.getProfileRef() != null) {
            out.append(String.valueOf(front) + "locQualityIssueProfileRef" + "=\"" + Util.toXML(lqi.getProfileRef(), true) + "\"");
        }
        return out.toString();
    }

    private String outputProvenanceAttributes(Provenance prov, boolean withPrefix) {
        String front = withPrefix ? " its:" : " ";
        StringBuilder out = new StringBuilder();
        if (prov.getTool() != null) {
            out.append(String.valueOf(front) + "tool" + "=\"" + Util.toXML(prov.getTool(), true) + "\"");
        } else if (prov.getToolRef() != null) {
            out.append(String.valueOf(front) + "toolRef" + "=\"" + prov.getToolRef() + "\"");
        }
        if (prov.getOrg() != null) {
            out.append(String.valueOf(front) + "org" + "=\"" + Util.toXML(prov.getOrg(), true) + "\"");
        } else if (prov.getOrgRef() != null) {
            out.append(String.valueOf(front) + "orgRef" + "=\"" + prov.getOrgRef() + "\"");
        }
        if (prov.getPerson() != null) {
            out.append(String.valueOf(front) + "person" + "=\"" + Util.toXML(prov.getPerson(), true) + "\"");
        } else if (prov.getPersonRef() != null) {
            out.append(String.valueOf(front) + "personRef" + "=\"" + prov.getPersonRef() + "\"");
        }
        if (prov.getRevTool() != null) {
            out.append(String.valueOf(front) + "revTool" + "=\"" + Util.toXML(prov.getRevTool(), true) + "\"");
        } else if (prov.getRevToolRef() != null) {
            out.append(String.valueOf(front) + "revToolRef" + "=\"" + prov.getRevToolRef() + "\"");
        }
        if (prov.getRevOrg() != null) {
            out.append(String.valueOf(front) + "revOrg" + "=\"" + Util.toXML(prov.getRevOrg(), true) + "\"");
        } else if (prov.getRevOrgRef() != null) {
            out.append(String.valueOf(front) + "revOrgRef" + "=\"" + prov.getRevOrgRef() + "\"");
        }
        if (prov.getRevPerson() != null) {
            out.append(String.valueOf(front) + "revPerson" + "=\"" + Util.toXML(prov.getRevPerson(), true) + "\"");
        } else if (prov.getRevPersonRef() != null) {
            out.append(String.valueOf(front) + "revPersonRef" + "=\"" + prov.getRevPersonRef() + "\"");
        }
        if (prov.getProvRef() != null) {
            out.append(String.valueOf(front) + "provRef" + "=\"" + prov.getProvRef() + "\"");
        }
        return out.toString();
    }

    private String outputTextAnalysisAttributes(TextAnalysis ta, boolean withPrefix) {
        String front = withPrefix ? " its:" : " ";
        StringBuilder out = new StringBuilder();
        if (ta.getTaClassRef() != null) {
            out.append(String.valueOf(front) + "taClassRef" + "=\"" + Util.toXML(ta.getTaClassRef(), true) + "\"");
        }
        if (ta.getTaIdentRef() != null) {
            out.append(String.valueOf(front) + "taIdentRef" + "=\"" + Util.toXML(ta.getTaIdentRef(), true) + "\"");
        }
        if (ta.getTaSource() != null) {
            out.append(String.valueOf(front) + "taSource" + "=\"" + Util.toXML(ta.getTaSource(), true) + "\"");
        }
        if (ta.getTaIdent() != null) {
            out.append(String.valueOf(front) + "taIdent" + "=\"" + Util.toXML(ta.getTaIdent(), true) + "\"");
        }
        if (ta.getTaConfidence() != null) {
            out.append(String.valueOf(front) + "taConfidence" + "=\"" + this.format(ta.getTaConfidence()) + "\"");
        }
        return out.toString();
    }

    private List<DataCategoryGroup<?>> checkForGroups(List<DataCategoryGroup<?>> list, Tags markers) {
        for (Tag bm : markers) {
            if (!bm.isMarker() || bm.getTagType() != TagType.OPENING || !((MTag)bm).hasITSItem()) continue;
            MTag am = (MTag)bm;
            for (IITSItem item : am.getITSItems()) {
                if (!item.isGroup()) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add((DataCategoryGroup)item);
            }
        }
        return list;
    }

    private List<DataCategoryGroup<?>> checkForGroups(List<DataCategoryGroup<?>> list, IWithITSAttributes parent) {
        if (parent.hasITSItem()) {
            for (IITSItem item : parent.getITSItems()) {
                if (!item.isGroup()) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add((DataCategoryGroup)item);
            }
        }
        return list;
    }

    private String format(Double value) {
        if (value == null) {
            return "";
        }
        String tmp = String.format(null, "%f", value);
        while (tmp.length() > 1 && tmp.charAt(tmp.length() - 1) == '0') {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (tmp.charAt(tmp.length() - 1) == '.') {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }
}

