/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.processor;

import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.processor.IEventHandler;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;

public class XLIFFProcessor
implements Runnable {
    private XLIFFReader reader;
    private XLIFFWriter writer;
    private List<IEventHandler> handlers = new ArrayList<IEventHandler>();

    public void setInput(File inputFile) {
        this.reader = new XLIFFReader();
        this.reader.open(inputFile);
    }

    public void setInput(String inputText) {
        this.reader = new XLIFFReader();
        this.reader.open(inputText);
    }

    public void setInput(URI inputURI) {
        this.reader = new XLIFFReader();
        this.reader.open(inputURI);
    }

    public void setInput(InputStream inputStream) {
        this.reader = new XLIFFReader();
        this.reader.open(inputStream);
    }

    public void setOutput(File outputFile) {
        if (outputFile == null) {
            this.writer = null;
        } else {
            this.writer = new XLIFFWriter();
            this.writer.create(outputFile, null);
        }
    }

    public void setOutput(Writer outputWriter) {
        if (outputWriter == null) {
            this.writer = null;
        } else {
            this.writer = new XLIFFWriter();
            this.writer.create(outputWriter, null);
        }
    }

    public void run(File inputFile, File outputFile) {
        if (outputFile != null && inputFile.equals(outputFile)) {
            throw new InvalidParameterException("The output file must be different from the input file.");
        }
        this.setInput(inputFile);
        this.setOutput(outputFile);
        this.run();
    }

    public void run(File inputFile) {
        this.run(inputFile, null);
    }

    @Override
    public void run() {
        try {
            while (this.reader.hasNext()) {
                Event event = this.reader.next();
                for (IEventHandler handler : this.handlers) {
                    switch (event.getType()) {
                        case END_FILE: {
                            event = handler.handleEndFile(event);
                            break;
                        }
                        case END_GROUP: {
                            event = handler.handleEndGroup(event);
                            break;
                        }
                        case END_DOCUMENT: {
                            event = handler.handleEndDocument(event);
                            break;
                        }
                        case END_XLIFF: {
                            event = handler.handleEndXliff(event);
                            break;
                        }
                        case INSIGNIFICANT_PART: {
                            event = handler.handleInsignificantPart(event);
                            break;
                        }
                        case MID_FILE: {
                            event = handler.handleMidFile(event);
                            break;
                        }
                        case SKELETON: {
                            event = handler.handleSkeleton(event);
                            break;
                        }
                        case START_FILE: {
                            event = handler.handleStartFile(event);
                            break;
                        }
                        case START_GROUP: {
                            event = handler.handleStartGroup(event);
                            break;
                        }
                        case START_DOCUMENT: {
                            event = handler.handleStartDocument(event);
                            break;
                        }
                        case START_XLIFF: {
                            event = handler.handleStartXliff(event);
                            break;
                        }
                        case TEXT_UNIT: {
                            event = handler.handleUnit(event);
                        }
                    }
                }
                if (this.writer == null) continue;
                this.writer.writeEvent(event);
            }
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }

    public void setHandler(IEventHandler handler) {
        this.handlers.clear();
        this.handlers.add(handler);
    }

    public void add(IEventHandler handler) {
        this.handlers.add(handler);
    }

    public void removeAll() {
        this.handlers.clear();
    }

    public void remove(IEventHandler handler) {
        this.handlers.remove(handler);
    }

    public void remove(int index) {
        this.handlers.remove(index);
    }
}

