/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json.ui;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.filters.json.Parameters;
import net.sf.okapi.filters.json.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkExtractStandalone;
    private Button rdExtractAllPairs;
    private Button rdDontExtractPairs;
    private Text edExceptions;
    private Button chkUseKeyAsName;
    private Button rdUseSubfilter;
    private Text edSubfilterId;
    private Button rdUseCodeFinder;
    private InlineCodeFinderPanel pnlCodeFinder;
    private IHelp help;
    private Button chkUseFullKeyPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Parameters)params;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText(Res.getString("EditorCaption"));
        if (parent != null) {
            this.shell.setImage(parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        TabFolder tfTmp = new TabFolder(this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tfTmp.setLayoutData(gdTmp);
        Composite cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        Group grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        grpTmp.setLayout(layTmp);
        grpTmp.setText(Res.getString("grpStandaloneStrings"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData(gdTmp);
        this.chkExtractStandalone = new Button(grpTmp, 32);
        this.chkExtractStandalone.setText(Res.getString("chkExtractStandalone"));
        grpTmp = new Group(cmpTmp, 0);
        grpTmp.setLayout(new GridLayout());
        grpTmp.setText(Res.getString("grpKeyValuePairs"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData(gdTmp);
        this.rdExtractAllPairs = new Button(grpTmp, 16);
        this.rdExtractAllPairs.setText(Res.getString("rdExtractAllPairs"));
        this.rdDontExtractPairs = new Button(grpTmp, 16);
        this.rdDontExtractPairs.setText(Res.getString("rdDontExtractPairs"));
        Label label = new Label(grpTmp, 0);
        label.setText(Res.getString("stExceptions"));
        this.edExceptions = new Text(grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edExceptions.setLayoutData(gdTmp);
        this.chkUseKeyAsName = new Button(grpTmp, 32);
        this.chkUseKeyAsName.setText(Res.getString("chkKeyAsResname"));
        this.chkUseFullKeyPath = new Button(grpTmp, 32);
        this.chkUseFullKeyPath.setText(Res.getString("chkUseFullKeyPath"));
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabOptions"));
        tiTmp.setControl(cmpTmp);
        cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        this.rdUseSubfilter = new Button(cmpTmp, 16);
        this.rdUseSubfilter.setText(Res.getString("rdSubfilter"));
        this.edSubfilterId = new Text(cmpTmp, 2048);
        gdTmp = new GridData(768);
        this.edSubfilterId.setLayoutData(gdTmp);
        this.rdUseCodeFinder = new Button(cmpTmp, 16);
        this.rdUseCodeFinder.setText(Res.getString("rdInlineCodeFinder"));
        SelectionAdapter listener = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateInlineCodes();
            }
        };
        this.rdUseCodeFinder.addSelectionListener(listener);
        this.rdUseSubfilter.addSelectionListener(listener);
        this.pnlCodeFinder = new InlineCodeFinderPanel(cmpTmp, 0);
        this.pnlCodeFinder.setLayoutData(new GridData(1808));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabContentProcessing"));
        tiTmp.setControl(cmpTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("JSON Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        this.pnlActions.setLayoutData(gdTmp);
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkExtractStandalone.setSelection(this.params.getExtractStandalone());
        this.rdExtractAllPairs.setSelection(this.params.getExtractAllPairs());
        this.rdDontExtractPairs.setSelection(!this.params.getExtractAllPairs());
        this.edExceptions.setText(this.params.getExceptions() == null ? "" : this.params.getExceptions());
        this.chkUseKeyAsName.setSelection(this.params.getUseKeyAsName());
        this.chkUseFullKeyPath.setSelection(this.params.getUseFullKeyPath());
        this.rdUseSubfilter.setSelection(!this.params.getUseCodeFinder());
        this.edSubfilterId.setText(this.params.getSubfilter() == null ? "" : this.params.getSubfilter());
        this.rdUseCodeFinder.setSelection(this.params.getUseCodeFinder());
        this.pnlCodeFinder.setRules(this.params.getCodeFinderData());
        this.updateInlineCodes();
        this.pnlCodeFinder.updateDisplay();
    }

    private String checkExceptionsSyntax() {
        try {
            String tmp = this.edExceptions.getText();
            if (Util.isEmpty((String)tmp)) {
                return null;
            }
            Pattern.compile(tmp);
            this.params.setExceptions(tmp);
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    private boolean saveData() {
        String tmp;
        if (this.rdUseCodeFinder.getSelection()) {
            if (this.pnlCodeFinder.getRules() == null) {
                return false;
            }
            this.params.setCodeFinderData(this.pnlCodeFinder.getRules());
        }
        if ((tmp = this.checkExceptionsSyntax()) != null) {
            this.edExceptions.selectAll();
            this.edExceptions.setFocus();
            Dialogs.showError(this.shell, tmp, null);
            return false;
        }
        this.params.setUseCodeFinder(this.rdUseCodeFinder.getSelection());
        this.params.setExceptions(this.edExceptions.getText());
        this.params.setExtractStandalone(this.chkExtractStandalone.getSelection());
        this.params.setExtractAllPairs(this.rdExtractAllPairs.getSelection());
        this.params.setUseKeyAsName(this.chkUseKeyAsName.getSelection());
        this.params.setUseFullKeyPath(this.chkUseFullKeyPath.getSelection());
        this.params.setSubfilter(this.rdUseSubfilter.getSelection() ? this.edSubfilterId.getText() : "");
        return true;
    }

    private void updateInlineCodes() {
        this.pnlCodeFinder.setEnabled(this.rdUseCodeFinder.getSelection());
        this.edSubfilterId.setEnabled(!this.rdUseCodeFinder.getSelection());
    }
}

