/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilterEventConverter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.SkeletonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFilter filter;
    private SubFilterEventConverter converter;
    private String parentId;
    private String parentName;
    private int sectionIndex;
    StartSubfilter startSubfilter;
    EndSubfilter endSubfilter;

    public SubFilter(IFilter filter, IEncoder parentEncoder, int sectionIndex, String parentId, String parentName) {
        filter.close();
        this.filter = filter;
        this.parentId = parentId;
        this.parentName = parentName;
        this.sectionIndex = sectionIndex;
        this.converter = new SubFilterEventConverter(this, parentEncoder);
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public SubFilterEventConverter getConverter() {
        return this.converter;
    }

    @Override
    public String getName() {
        return this.filter.getName();
    }

    @Override
    public String getDisplayName() {
        return this.filter.getDisplayName();
    }

    @Override
    public void open(RawDocument input) {
        this.converter.reset();
        this.filter.open(input);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.converter.reset();
        this.filter.open(input, generateSkeleton);
    }

    @Override
    public void close() {
        this.filter.close();
        this.converter.reset();
    }

    @Override
    public boolean hasNext() {
        return this.filter.hasNext();
    }

    @Override
    public Event next() {
        return this.converter.convertEvent(this.filter.next());
    }

    @Override
    public void cancel() {
        this.filter.cancel();
    }

    @Override
    public IParameters getParameters() {
        return this.filter.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.filter.setParameters(params);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.filter.setFilterConfigurationMapper(fcMapper);
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return this.filter.createSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return this.filter.createFilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.filter.getEncoderManager();
    }

    @Override
    public String getMimeType() {
        return this.filter.getMimeType();
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        return this.filter.getConfigurations();
    }

    public List<Event> getEvents(RawDocument input) {
        LinkedList<Event> events = new LinkedList<Event>();
        this.open(input);
        while (this.hasNext()) {
            events.add(this.next());
        }
        this.close();
        return Collections.unmodifiableList(events);
    }

    public Code createRefCode() {
        this.startSubfilter.setIsReferent(true);
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, this.startSubfilter.getName(), TextFragment.makeRefMarker(this.startSubfilter.getId()));
        c.setReferenceFlag(true);
        return c;
    }

    private DocumentPart buildRefDP(GenericSkeleton beforeSkeleton, GenericSkeleton afterSkeleton) {
        GenericSkeleton skel = new GenericSkeleton();
        DocumentPart dp = new DocumentPart(this.buildRefId(), false, skel);
        skel.add(beforeSkeleton);
        skel.addReference(this.startSubfilter);
        this.startSubfilter.setIsReferent(true);
        skel.add(afterSkeleton);
        dp.setName(this.buildRefName());
        dp.setType("ref-ssf");
        return dp;
    }

    public Event createRefEvent() {
        return this.createRefEvent(null, null);
    }

    public Event createRefEvent(IResource resource) {
        ISkeleton skel = resource.getSkeleton();
        if (skel instanceof GenericSkeleton) {
            GenericSkeleton[] parts = SkeletonUtil.splitSkeleton((GenericSkeleton)skel);
            return this.createRefEvent(parts[0], parts[1]);
        }
        if (skel != null) {
            this.logger.warn("Unknown skeleton type, ignored.");
        }
        return this.createRefEvent();
    }

    public Event createRefEvent(ISkeleton beforeSkeleton, ISkeleton afterSkeleton) {
        if (beforeSkeleton instanceof GenericSkeleton && afterSkeleton instanceof GenericSkeleton) {
            DocumentPart dp = this.buildRefDP((GenericSkeleton)beforeSkeleton, (GenericSkeleton)afterSkeleton);
            return new Event(EventType.DOCUMENT_PART, dp);
        }
        if (beforeSkeleton != null || afterSkeleton != null) {
            this.logger.warn("Unknown skeleton type, ignored.");
        }
        DocumentPart dp = this.buildRefDP(null, null);
        return new Event(EventType.DOCUMENT_PART, dp);
    }

    private String buildStartSubfilterId(String originalResId) {
        return originalResId != null ? String.format("%s_%s", this.getParentId(), originalResId) : String.format("%s_%s%d", this.getParentId(), "ssf", this.getSectionIndex());
    }

    private String buildStartSubfilterName() {
        return "sub-filter:" + this.getParentName();
    }

    private String buildEndSubfilterId(String originalResId) {
        return originalResId != null ? String.format("%s_%s", this.getParentId(), originalResId) : String.format("%s_%s%d", this.getParentId(), "esf", this.getSectionIndex());
    }

    protected String buildResourceId(String resId, Class<? extends IResource> resClass) {
        if (resClass == StartSubfilter.class) {
            return this.buildStartSubfilterId(resId);
        }
        if (resClass == EndSubfilter.class) {
            return this.buildEndSubfilterId(resId);
        }
        return String.format("%s_%s", this.getParentId(), resId);
    }

    protected String buildResourceName(String resName, boolean autoGenerated, Class<? extends INameable> resClass) {
        if (resClass == StartSubfilter.class) {
            return this.buildStartSubfilterName();
        }
        return autoGenerated ? String.format("%s_%s", this.getParentName(), resName) : resName;
    }

    protected String buildRefId() {
        return String.format("ref-%s%s-%d", "sub-filter:", this.getParentId(), this.getSectionIndex());
    }

    public static boolean resourceIdsMatch(String startSubfilterResourceId, String endSubfilterResourceId) {
        if (startSubfilterResourceId == null || endSubfilterResourceId == null) {
            return false;
        }
        int i = startSubfilterResourceId.lastIndexOf("ssf");
        if (i != -1) {
            startSubfilterResourceId = startSubfilterResourceId.substring(0, i) + startSubfilterResourceId.substring(i + "ssf".length());
        }
        if ((i = endSubfilterResourceId.lastIndexOf("esf")) != -1) {
            endSubfilterResourceId = endSubfilterResourceId.substring(0, i) + endSubfilterResourceId.substring(i + "esf".length());
        }
        return startSubfilterResourceId.equals(endSubfilterResourceId);
    }

    protected String buildRefName() {
        return "ref:" + this.getParentId();
    }

    protected final String getParentId() {
        return this.parentId;
    }

    protected final String getParentName() {
        return this.parentName;
    }

    protected final int getSectionIndex() {
        return this.sectionIndex;
    }

    protected void convertRefsInSkeleton(ISkeleton skel) {
        if (skel instanceof GenericSkeleton) {
            GenericSkeleton gs = (GenericSkeleton)skel;
            for (GenericSkeletonPart part : gs.getParts()) {
                String data = part.getData().toString();
                if (!data.contains("[#$")) continue;
                String newData = this.converter.convertRefIds(data);
                part.setData(newData);
            }
        }
    }
}

