/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class GoogleMTv2Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String APIKEY = "apiKey";

    public String getApiKey() {
        return this.getString(APIKEY);
    }

    public void setApiKey(String apiKey) {
        this.setString(APIKEY, apiKey);
    }

    @Override
    public void reset() {
        super.reset();
        this.setApiKey("");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(APIKEY, "Google API key", "The Google API key to identify the application/user");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Google Translate v2 Connector Settings", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(APIKEY));
        tip.setPassword(true);
        return desc;
    }
}

