/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.abstractmarkup.config;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.filters.abstractmarkup.config.IllegalConditionalAttributeException;
import net.sf.okapi.filters.abstractmarkup.config.YamlConfigurationReader;

public class TaggedFilterConfiguration {
    public static final String RULETYPES = "ruleTypes";
    public static final String GLOBAL_PRESERVE_WHITESPACE = "preserve_whitespace";
    public static final String GLOBAL_EXCLUDE_BY_DEFAULT = "exclude_by_default";
    public static final String INLINE_CDATA = "inlineCdata";
    public static final String INLINE = "INLINE";
    public static final String GROUP = "GROUP";
    public static final String EXCLUDE = "EXCLUDE";
    public static final String INCLUDE = "INCLUDE";
    public static final String TEXTUNIT = "TEXTUNIT";
    public static final String TEXTRUN = "TEXTRUN";
    public static final String TEXTMARKER = "TEXTMARKER";
    public static final String PRESERVE_WHITESPACE = "PRESERVE_WHITESPACE";
    public static final String SCRIPT = "SCRIPT";
    public static final String SERVER = "SERVER";
    public static final String ATTRIBUTE_TRANS = "ATTRIBUTE_TRANS";
    public static final String ATTRIBUTE_WRITABLE = "ATTRIBUTE_WRITABLE";
    public static final String ATTRIBUTE_READONLY = "ATTRIBUTE_READONLY";
    public static final String ATTRIBUTES_ONLY = "ATTRIBUTES_ONLY";
    public static final String ATTRIBUTE_ID = "ATTRIBUTE_ID";
    public static final String ATTRIBUTE_PRESERVE_WHITESPACE = "ATTRIBUTE_PRESERVE_WHITESPACE";
    public static final String ALL_ELEMENTS_EXCEPT = "allElementsExcept";
    public static final String ONLY_THESE_ELEMENTS = "onlyTheseElements";
    public static final String EQUALS = "EQUALS";
    public static final String NOT_EQUALS = "NOT_EQUALS";
    public static final String MATCHES = "MATCHES";
    public static final String ELEMENT_TYPE = "elementType";
    public static final String WELLFORMED = "assumeWellformed";
    public static final String USECODEFINDER = "useCodeFinder";
    public static final String CODEFINDERRULES = "codeFinderRules";
    public static final String GLOBAL_ESCAPE_NBSP = "escapeNbsp";
    public static final String GLOBAL_PCDATA_SUBFILTER = "global_pcdata_subfilter";
    public static final String GLOBAL_CDATA_SUBFILTER = "global_cdata_subfilter";
    public static final String CONDITIONS = "conditions";
    public static final String SUBFILTER = "subfilter";
    public static final String ELEMENT_TRANSLATABLE_ATTRIBUTES = "translatableAttributes";
    public static final String ELEMENT_WRITABLE_ATTRIBUTES = "writableLocalizableAttributes";
    public static final String ELEMENT_READ_ONLY_ATTRIBUTES = "readOnlyLocalizableAttributes";
    public static final String ELEMENT_ID_ATTRIBUTES = "idAttributes";
    public static final String PRESERVE_CONDITION = "preserve";
    public static final String DEFAULT_CONDITION = "default";
    public static final String SIMPLIFIER_RULES = "simplifierRules";
    private final YamlConfigurationReader configReader;

    public TaggedFilterConfiguration() {
        this.configReader = new YamlConfigurationReader();
    }

    public TaggedFilterConfiguration(URL configurationPathAsResource) {
        this.configReader = new YamlConfigurationReader(configurationPathAsResource);
    }

    public TaggedFilterConfiguration(File configurationFile) {
        this.configReader = new YamlConfigurationReader(configurationFile);
    }

    public TaggedFilterConfiguration(String configurationScript) {
        this.configReader = new YamlConfigurationReader(configurationScript);
    }

    public YamlConfigurationReader getConfigReader() {
        return this.configReader;
    }

    public String toString() {
        return this.configReader.toString();
    }

    public boolean isGlobalPreserveWhitespace() {
        Boolean pw = (Boolean)this.configReader.getProperty(GLOBAL_PRESERVE_WHITESPACE);
        if (pw == null) {
            return true;
        }
        return pw;
    }

    public boolean isGlobalExcludeByDefault() {
        Boolean pw = (Boolean)this.configReader.getProperty(GLOBAL_EXCLUDE_BY_DEFAULT);
        if (pw == null) {
            return false;
        }
        return pw;
    }

    public boolean isWellformed() {
        Boolean wf = (Boolean)this.configReader.getProperty(WELLFORMED);
        if (wf == null) {
            return false;
        }
        return wf;
    }

    public boolean isInlineCdata() {
        Boolean ic = (Boolean)this.configReader.getProperty(INLINE_CDATA);
        if (ic == null) {
            return false;
        }
        return ic;
    }

    public boolean isUseCodeFinder() {
        Boolean useCF = (Boolean)this.configReader.getProperty(USECODEFINDER);
        if (useCF == null) {
            return false;
        }
        return useCF;
    }

    public boolean getBooleanParameter(String parameterName) {
        Boolean res = (Boolean)this.configReader.getProperty(parameterName);
        if (res == null) {
            return false;
        }
        return res;
    }

    public int getIntegerParameter(String parameterName) {
        Integer res = (Integer)this.configReader.getProperty(parameterName);
        if (res == null) {
            return -1;
        }
        return res;
    }

    public String getStringParameter(String parameterName) {
        return (String)this.configReader.getProperty(parameterName);
    }

    public String getGlobalPCDATASubfilter() {
        return (String)this.configReader.getProperty(GLOBAL_PCDATA_SUBFILTER);
    }

    public String getGlobalCDATASubfilter() {
        return (String)this.configReader.getProperty(GLOBAL_CDATA_SUBFILTER);
    }

    public String getCodeFinderRules() {
        return (String)this.configReader.getProperty(CODEFINDERRULES);
    }

    private boolean isRuleType(String ruleName, RULE_TYPE ruleType, List<String> ruleTypes) {
        for (String r : ruleTypes) {
            if (!this.convertRuleAsStringToRuleType(r).equals((Object)ruleType)) continue;
            return true;
        }
        return false;
    }

    public boolean isRuleType(String ruleName, RULE_TYPE ruleType) {
        List<Map> rules = this.configReader.getRules(ruleName.toLowerCase());
        for (Map rule : rules) {
            List ruleTypes = (List)rule.get(RULETYPES);
            for (String r : ruleTypes) {
                if (!this.convertRuleAsStringToRuleType(r).equals((Object)ruleType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDefinedInlineRule(String ruleName) {
        Map rule = this.configReader.getNonRegexElementRule(ruleName);
        if (rule == null) {
            return false;
        }
        List ruleTypes = (List)rule.get(RULETYPES);
        return this.isRuleType(ruleName, RULE_TYPE.INLINE_ELEMENT, ruleTypes);
    }

    public String getElementType(Tag element) {
        if (element.getTagType() == StartTagType.COMMENT) {
            return "comment";
        }
        if (element.getTagType() == StartTagType.XML_PROCESSING_INSTRUCTION) {
            return "processing-instruction";
        }
        Map rule = this.configReader.getElementRule(element.getName().toLowerCase());
        if (rule != null && rule.containsKey(ELEMENT_TYPE)) {
            return (String)rule.get(ELEMENT_TYPE);
        }
        return element.getName();
    }

    public RULE_TYPE findMatchingAttributeRule(String tag, Map<String, String> attributes, String attribute) {
        RULE_TYPE ruleType = RULE_TYPE.RULE_NOT_FOUND;
        ruleType = this.findMatchingAttributeRuleOnElementRule(tag, attributes, attribute);
        if (ruleType != RULE_TYPE.RULE_NOT_FOUND) {
            return ruleType;
        }
        return this.findMatchingElementOnAttributeRule(tag, attribute, attributes, this.getAttributeRuleType(attribute.toLowerCase()));
    }

    private RULE_TYPE findMatchingAttributeRuleOnElementRule(String tag, Map<String, String> attributes, String attribute) {
        String[] elementRuleNames;
        boolean attributeIsFound = false;
        Map elementRule = this.configReader.getElementRule(tag.toLowerCase());
        if (elementRule == null) {
            return RULE_TYPE.RULE_NOT_FOUND;
        }
        for (String attributeRule : elementRuleNames = new String[]{ELEMENT_TRANSLATABLE_ATTRIBUTES, ELEMENT_WRITABLE_ATTRIBUTES, ELEMENT_READ_ONLY_ATTRIBUTES, ELEMENT_ID_ATTRIBUTES}) {
            Object actionableAttributes;
            Object ta = elementRule.get(attributeRule);
            if (ta == null) continue;
            if (ta != null && ta instanceof List) {
                actionableAttributes = (List)elementRule.get(attributeRule);
                Iterator i = actionableAttributes.iterator();
                while (i.hasNext()) {
                    String a = (String)i.next();
                    if (!a.equalsIgnoreCase(attribute)) continue;
                    return this.convertRuleAsStringToRuleType(attributeRule);
                }
                continue;
            }
            if (ta == null || !(ta instanceof Map) || !(actionableAttributes = (Map)elementRule.get(attributeRule)).containsKey(attribute.toLowerCase())) continue;
            attributeIsFound = true;
            List condition = (List)actionableAttributes.get(attribute.toLowerCase());
            if (condition == null) {
                return this.convertRuleAsStringToRuleType(attributeRule);
            }
            if (condition.get(0) instanceof List) {
                for (int i = 0; i <= condition.size() - 1; ++i) {
                    List c = (List)condition.get(i);
                    if (!this.applyConditions(c, attributes)) continue;
                    return this.convertRuleAsStringToRuleType(attributeRule);
                }
                continue;
            }
            if (!this.applyConditions(condition, attributes)) continue;
            return this.convertRuleAsStringToRuleType(attributeRule);
        }
        if (attributeIsFound) {
            return RULE_TYPE.RULE_FAILED;
        }
        return RULE_TYPE.RULE_NOT_FOUND;
    }

    public RULE_TYPE getConditionalAttributeRuleType(String attribute, Map<String, String> attributes) {
        RULE_TYPE type = this.getAttributeRuleType(attribute);
        if (type != RULE_TYPE.RULE_NOT_FOUND) {
            if (this.doesAttributeRuleConditionApply(this.configReader.getAttributeRule(attribute), attributes)) {
                return type;
            }
            return RULE_TYPE.RULE_FAILED;
        }
        return type;
    }

    public RULE_TYPE getAttributeRuleType(String attribute) {
        Map rule = this.configReader.getAttributeRule(attribute.toLowerCase());
        if (rule != null) {
            List ruleTypes = (List)rule.get(RULETYPES);
            if (this.isRuleType(attribute, RULE_TYPE.ATTRIBUTE_TRANS, ruleTypes)) {
                return RULE_TYPE.ATTRIBUTE_TRANS;
            }
            if (this.isRuleType(attribute, RULE_TYPE.ATTRIBUTE_WRITABLE, ruleTypes)) {
                return RULE_TYPE.ATTRIBUTE_WRITABLE;
            }
            if (this.isRuleType(attribute, RULE_TYPE.ATTRIBUTE_READONLY, ruleTypes)) {
                return RULE_TYPE.ATTRIBUTE_READONLY;
            }
            if (this.isRuleType(attribute, RULE_TYPE.ATTRIBUTE_ID, ruleTypes)) {
                return RULE_TYPE.ATTRIBUTE_ID;
            }
            if (this.isRuleType(attribute, RULE_TYPE.ATTRIBUTE_PRESERVE_WHITESPACE, ruleTypes)) {
                return RULE_TYPE.ATTRIBUTE_PRESERVE_WHITESPACE;
            }
        }
        return RULE_TYPE.RULE_NOT_FOUND;
    }

    private RULE_TYPE findMatchingElementOnAttributeRule(String tag, String attribute, Map<String, String> attributes, RULE_TYPE ruleType) {
        Map attrRule = this.configReader.getAttributeRule(attribute.toLowerCase());
        if (attrRule == null) {
            return RULE_TYPE.RULE_NOT_FOUND;
        }
        if (!this.doesAttributeRuleConditionApply(attrRule, attributes)) {
            return RULE_TYPE.RULE_FAILED;
        }
        List excludedElements = (List)attrRule.get(ALL_ELEMENTS_EXCEPT);
        List onlyTheseElements = (List)attrRule.get(ONLY_THESE_ELEMENTS);
        if (excludedElements == null && onlyTheseElements == null) {
            return ruleType;
        }
        if (excludedElements != null) {
            for (int i = 0; i <= excludedElements.size() - 1; ++i) {
                String elem = (String)excludedElements.get(i);
                if (!elem.equalsIgnoreCase(tag)) continue;
                return RULE_TYPE.RULE_FAILED;
            }
            return ruleType;
        }
        if (onlyTheseElements != null) {
            for (int i = 0; i <= onlyTheseElements.size() - 1; ++i) {
                String elem = (String)onlyTheseElements.get(i);
                if (!elem.equalsIgnoreCase(tag)) continue;
                return ruleType;
            }
            return RULE_TYPE.RULE_FAILED;
        }
        return ruleType;
    }

    public RULE_TYPE getConditionalElementRuleType(String tag, Map<String, String> attributes) {
        RULE_TYPE type = this.getElementRuleTypeCandidate(tag.toLowerCase());
        if (type != RULE_TYPE.RULE_NOT_FOUND) {
            if (type == RULE_TYPE.INLINE_EXCLUDED_ELEMENT) {
                Map ruleRegex = this.configReader.getRegexElementRule(tag.toLowerCase());
                Map rule = this.configReader.getNonRegexElementRule(tag.toLowerCase());
                if (this.doesElementRuleConditionApply(ruleRegex, attributes)) {
                    return type;
                }
                if (this.hasDefinedInlineRule(tag.toLowerCase()) && !this.isRuleType(tag.toLowerCase(), RULE_TYPE.EXCLUDED_ELEMENT)) {
                    if (this.doesElementRuleConditionApply(this.configReader.getElementRule(tag.toLowerCase()), attributes)) {
                        return RULE_TYPE.INLINE_ELEMENT;
                    }
                    return RULE_TYPE.RULE_NOT_FOUND;
                }
                if (this.doesElementRuleConditionApply(rule, attributes)) {
                    return type;
                }
                return RULE_TYPE.RULE_NOT_FOUND;
            }
            if (attributes.isEmpty() && this.configReader.getElementRule(tag.toLowerCase()).get(CONDITIONS) != null) {
                return RULE_TYPE.RULE_NOT_FOUND;
            }
            if (attributes.isEmpty() && this.configReader.getElementRule(tag.toLowerCase()).get(CONDITIONS) == null) {
                return type;
            }
            if (this.doesElementRuleConditionApply(this.configReader.getElementRule(tag.toLowerCase()), attributes)) {
                return type;
            }
            return RULE_TYPE.RULE_FAILED;
        }
        return type;
    }

    public RULE_TYPE getElementRuleTypeCandidate(String tag) {
        Map rule = this.configReader.getElementRule(tag.toLowerCase());
        if (rule != null) {
            List ruleTypes = (List)rule.get(RULETYPES);
            if (this.isRuleType(tag, RULE_TYPE.EXCLUDED_ELEMENT, ruleTypes) && !this.isRuleType(tag, RULE_TYPE.INLINE_ELEMENT, ruleTypes)) {
                return RULE_TYPE.EXCLUDED_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.GROUP_ELEMENT, ruleTypes)) {
                return RULE_TYPE.GROUP_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.INCLUDED_ELEMENT, ruleTypes)) {
                return RULE_TYPE.INCLUDED_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.INLINE_ELEMENT, ruleTypes)) {
                List rt;
                Map r1 = this.configReader.getRegexElementRule(tag.toLowerCase());
                Map r2 = this.configReader.getNonRegexElementRule(tag.toLowerCase());
                if (r1 != null ? this.isRuleType(tag, RULE_TYPE.EXCLUDED_ELEMENT, rt = (List)r1.get(RULETYPES)) : r2 != null && this.isRuleType(tag, RULE_TYPE.EXCLUDED_ELEMENT, rt = (List)r2.get(RULETYPES))) {
                    return RULE_TYPE.INLINE_EXCLUDED_ELEMENT;
                }
                return RULE_TYPE.INLINE_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.SCRIPT_ELEMENT, ruleTypes)) {
                return RULE_TYPE.SCRIPT_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.SERVER_ELEMENT, ruleTypes)) {
                return RULE_TYPE.SERVER_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.ATTRIBUTES_ONLY, ruleTypes)) {
                return RULE_TYPE.ATTRIBUTES_ONLY;
            }
            if (this.isRuleType(tag, RULE_TYPE.TEXT_UNIT_ELEMENT, ruleTypes)) {
                return RULE_TYPE.TEXT_UNIT_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.TEXT_MARKER_ELEMENT, ruleTypes)) {
                return RULE_TYPE.TEXT_MARKER_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.TEXT_RUN_ELEMENT, ruleTypes)) {
                return RULE_TYPE.TEXT_RUN_ELEMENT;
            }
            if (this.isRuleType(tag, RULE_TYPE.PRESERVE_WHITESPACE, ruleTypes)) {
                return RULE_TYPE.PRESERVE_WHITESPACE;
            }
        }
        return RULE_TYPE.RULE_NOT_FOUND;
    }

    public boolean isTranslatableAttribute(String tag, String attribute, Map<String, String> attributes) {
        return this.findMatchingAttributeRule(tag, attributes, attribute) == RULE_TYPE.ATTRIBUTE_TRANS;
    }

    public boolean isReadOnlyLocalizableAttribute(String tag, String attribute, Map<String, String> attributes) {
        return this.findMatchingAttributeRule(tag, attributes, attribute) == RULE_TYPE.ATTRIBUTE_READONLY;
    }

    public boolean isWritableLocalizableAttribute(String tag, String attribute, Map<String, String> attributes) {
        return this.findMatchingAttributeRule(tag, attributes, attribute) == RULE_TYPE.ATTRIBUTE_WRITABLE;
    }

    public boolean isIdAttribute(String tag, String attribute, Map<String, String> attributes) {
        return this.findMatchingAttributeRule(tag, attributes, attribute) == RULE_TYPE.ATTRIBUTE_ID;
    }

    public RULE_TYPE convertRuleAsStringToRuleType(String ruleType) {
        if (ruleType.equalsIgnoreCase(INLINE)) {
            return RULE_TYPE.INLINE_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(GROUP)) {
            return RULE_TYPE.GROUP_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(EXCLUDE)) {
            return RULE_TYPE.EXCLUDED_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(INCLUDE)) {
            return RULE_TYPE.INCLUDED_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(TEXTUNIT)) {
            return RULE_TYPE.TEXT_UNIT_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(TEXTRUN)) {
            return RULE_TYPE.TEXT_RUN_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(TEXTMARKER)) {
            return RULE_TYPE.TEXT_MARKER_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(PRESERVE_WHITESPACE)) {
            return RULE_TYPE.PRESERVE_WHITESPACE;
        }
        if (ruleType.equalsIgnoreCase(SCRIPT)) {
            return RULE_TYPE.SCRIPT_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(SERVER)) {
            return RULE_TYPE.SERVER_ELEMENT;
        }
        if (ruleType.equalsIgnoreCase(ATTRIBUTE_TRANS)) {
            return RULE_TYPE.ATTRIBUTE_TRANS;
        }
        if (ruleType.equalsIgnoreCase(ATTRIBUTE_WRITABLE)) {
            return RULE_TYPE.ATTRIBUTE_WRITABLE;
        }
        if (ruleType.equalsIgnoreCase(ATTRIBUTE_READONLY)) {
            return RULE_TYPE.ATTRIBUTE_READONLY;
        }
        if (ruleType.equalsIgnoreCase(ATTRIBUTES_ONLY)) {
            return RULE_TYPE.ATTRIBUTES_ONLY;
        }
        if (ruleType.equalsIgnoreCase(ATTRIBUTE_ID)) {
            return RULE_TYPE.ATTRIBUTE_ID;
        }
        if (ruleType.equalsIgnoreCase(ATTRIBUTE_PRESERVE_WHITESPACE)) {
            return RULE_TYPE.ATTRIBUTE_PRESERVE_WHITESPACE;
        }
        if (ruleType.equalsIgnoreCase(ELEMENT_TRANSLATABLE_ATTRIBUTES)) {
            return RULE_TYPE.ATTRIBUTE_TRANS;
        }
        if (ruleType.equalsIgnoreCase(ELEMENT_WRITABLE_ATTRIBUTES)) {
            return RULE_TYPE.ATTRIBUTE_WRITABLE;
        }
        if (ruleType.equalsIgnoreCase(ELEMENT_READ_ONLY_ATTRIBUTES)) {
            return RULE_TYPE.ATTRIBUTE_READONLY;
        }
        if (ruleType.equalsIgnoreCase(ELEMENT_ID_ATTRIBUTES)) {
            return RULE_TYPE.ATTRIBUTE_ID;
        }
        return RULE_TYPE.RULE_NOT_FOUND;
    }

    private boolean applyConditions(List condition, Map<String, String> attributes) {
        String conditionalAttribute = null;
        conditionalAttribute = (String)condition.get(0);
        String compareType = (String)condition.get(1);
        if (condition.get(2) instanceof List) {
            List conditionValues = (List)condition.get(2);
            if (compareType.equalsIgnoreCase(NOT_EQUALS)) {
                for (String value : conditionValues) {
                    if (this.applyCondition(attributes.get(conditionalAttribute.toLowerCase()), compareType, value)) continue;
                    return false;
                }
                return true;
            }
            for (String value : conditionValues) {
                if (!this.applyCondition(attributes.get(conditionalAttribute.toLowerCase()), compareType, value)) continue;
                return true;
            }
        } else {
            if (condition.get(2) instanceof String) {
                String conditionValue = (String)condition.get(2);
                return this.applyCondition(attributes.get(conditionalAttribute.toLowerCase()), compareType, conditionValue);
            }
            throw new OkapiException("Error reading conditions. Have you quoted values such as 'true', 'false', 'yes', and 'no'?");
        }
        return false;
    }

    private boolean applyCondition(String attributeValue, String compareType, String conditionValue) {
        if (compareType.equalsIgnoreCase(EQUALS)) {
            return conditionValue.equalsIgnoreCase(attributeValue);
        }
        if (compareType.equalsIgnoreCase(NOT_EQUALS)) {
            return !conditionValue.equalsIgnoreCase(attributeValue);
        }
        if (compareType.equalsIgnoreCase(MATCHES)) {
            boolean result = false;
            if (attributeValue == null) {
                return result;
            }
            Pattern matchPattern = Pattern.compile(conditionValue);
            try {
                Matcher m = matchPattern.matcher(attributeValue);
                result = m.matches();
            }
            catch (PatternSyntaxException e) {
                throw new IllegalConditionalAttributeException(e);
            }
            return result;
        }
        throw new IllegalConditionalAttributeException("Unkown match type");
    }

    private boolean doesElementRuleConditionApply(Map elementRule, Map<String, String> attributes) {
        if (elementRule == null) {
            return false;
        }
        List conditions = (List)elementRule.get(CONDITIONS);
        if (conditions != null) {
            return this.applyConditions(conditions, attributes);
        }
        return true;
    }

    private boolean doesAttributeRuleConditionApply(Map attributeRule, Map<String, String> attributes) {
        if (attributeRule == null) {
            return false;
        }
        List conditions = (List)attributeRule.get(CONDITIONS);
        if (conditions != null) {
            return this.applyConditions(conditions, attributes);
        }
        return true;
    }

    public boolean isPreserveWhitespaceCondition(String attribute, Map<String, String> attributes) {
        List preserveWhiteSpace;
        Map attributeRule = this.configReader.getAttributeRule(attribute);
        if (this.doesAttributeRuleConditionApply(attributeRule, attributes) && (preserveWhiteSpace = (List)attributeRule.get(PRESERVE_CONDITION)) != null) {
            return this.applyConditions(preserveWhiteSpace, attributes);
        }
        return false;
    }

    public boolean isDefaultWhitespaceCondition(String attribute, Map<String, String> attributes) {
        List defaultWhiteSpace;
        Map attributeRule = this.configReader.getAttributeRule(attribute);
        if (this.doesAttributeRuleConditionApply(attributeRule, attributes) && (defaultWhiteSpace = (List)attributeRule.get(DEFAULT_CONDITION)) != null) {
            return this.applyConditions(defaultWhiteSpace, attributes);
        }
        return false;
    }

    public Map<String, Object> getAttributeRules() {
        return this.configReader.getAttributeRules();
    }

    public Map<String, Object> getElementRules() {
        return this.configReader.getElementRules();
    }

    public String getSimplifierRules() {
        return (String)this.configReader.getProperty(SIMPLIFIER_RULES);
    }

    public void setSimplfierRules(String rules) {
        this.configReader.addProperty(SIMPLIFIER_RULES, rules);
    }

    public boolean getQuoteModeDefined() {
        Boolean res = (Boolean)this.configReader.getProperty("quoteModeDefined");
        if (res == null) {
            return false;
        }
        return res;
    }

    public void setQuoteModeDefined(boolean defined) {
        this.configReader.addProperty("quoteModeDefined", defined);
    }

    public int getQuoteMode() {
        Integer res = (Integer)this.configReader.getProperty("quoteMode");
        if (res == null) {
            return 2;
        }
        return res;
    }

    public void setQuoteMode(String quoteMode) {
        this.configReader.addProperty("quoteMode", quoteMode);
    }

    public static enum RULE_TYPE {
        INLINE_ELEMENT,
        INLINE_EXCLUDED_ELEMENT,
        INLINE_INCLUDED_ELEMENT,
        EXCLUDED_ELEMENT,
        INCLUDED_ELEMENT,
        GROUP_ELEMENT,
        TEXT_UNIT_ELEMENT,
        TEXT_RUN_ELEMENT,
        TEXT_MARKER_ELEMENT,
        PRESERVE_WHITESPACE,
        SCRIPT_ELEMENT,
        SERVER_ELEMENT,
        ATTRIBUTE_TRANS,
        ATTRIBUTE_WRITABLE,
        ATTRIBUTE_READONLY,
        ATTRIBUTE_PRESERVE_WHITESPACE,
        ATTRIBUTES_ONLY,
        ATTRIBUTE_ID,
        RULE_FAILED,
        RULE_NOT_FOUND;

    }
}

