/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.ChunkParser;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunBuilderSkipper;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunMerger;
import net.sf.okapi.filters.openxml.RunParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockParser
extends ChunkParser<Block> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockParser.class);
    private ElementSkipper generalElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_LANGUAGE, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTY_DELETED_PARAGRAPH_MARK, ElementSkipper.RevisionPropertySkippableElement.PARAGRAPH_PROPERTIES_CHANGE, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTIES_CHANGE);
    private ElementSkipper bookmarkElementSkipper = ElementSkipperFactory.createBookmarkElementSkipper(ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_START, ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_END);
    private RunBuilderSkipper runBuilderSkipper = new RunBuilderSkipper();
    private BlockBuilder builder = new BlockBuilder();
    private String paragraphStyle;

    BlockParser(StartElementContext startElementContext, IdGenerator nestedBlockIdGenerator, StyleDefinitions styleDefinitions) {
        super(startElementContext, nestedBlockIdGenerator, styleDefinitions);
    }

    private void addRunsToBuilder(BlockBuilder builder, RunMerger runMerger) throws XMLStreamException {
        for (Block.BlockChunk chunk : runMerger.getRuns()) {
            builder.addChunk(chunk);
        }
        runMerger.reset();
    }

    private void parseRunContainer(ChunkContainer chunkContainer, StartElement runContainerStart) throws XMLStreamException {
        RunContainer rc = new RunContainer();
        RunMerger runMerger = new RunMerger();
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (e.isEndElement() && runContainerStart.getName().equals(e.asEndElement().getName())) {
                rc.setStartElement(runContainerStart);
                rc.setEndElement(e.asEndElement());
                rc.setType(RunContainer.Type.fromValue(runContainerStart.getName().getLocalPart()));
                rc.addChunks(runMerger);
                chunkContainer.addChunk(rc);
                return;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(this.builder, runMerger, e.asStartElement());
                continue;
            }
            if (XMLEventHelpers.isRunContainerStartEvent(e)) {
                rc.addChunks(runMerger);
                this.parseRunContainer(rc, e.asStartElement());
                continue;
            }
            if (!XMLEventHelpers.isRunContainerPropertiesStartEvent(e)) continue;
            StartElementContext rcPropertiesElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
            BlockProperties blockProperties = MarkupComponentParser.parseBlockProperties(rcPropertiesElementContext, ElementSkipperFactory.createGeneralElementSkipper(new ElementSkipper.SkippableElement[0]));
            rc.setProperties(blockProperties);
        }
        throw new IllegalStateException("Invalid content? Unterminated run container");
    }

    @Override
    public Block parse() throws XMLStreamException {
        this.log("startBlock: " + this.startElementContext.getStartElement());
        this.builder.addMarkupComponent(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), AttributeStripper.RevisionAttributeStripper.stripParagraphRevisionAttributes(this.startElementContext)));
        RunMerger runMerger = new RunMerger();
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                StartElementContext blockPropertiesElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
                BlockProperties blockProperties = MarkupComponentParser.parseBlockProperties(blockPropertiesElementContext, this.generalElementSkipper);
                if (!blockProperties.getProperties().isEmpty() || !blockProperties.getAttributes().isEmpty()) {
                    this.builder.addMarkupComponent(blockProperties);
                }
                this.paragraphStyle = this.getParagraphStyle(blockProperties.getParagraphStyleProperty());
                runMerger.setParagraphStyle(this.paragraphStyle);
                this.builder.setIsHidden(this.isParagraphExcluded(this.paragraphStyle));
                continue;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(this.builder, runMerger, e.asStartElement());
                continue;
            }
            if (XMLEventHelpers.isRunContainerStartEvent(e)) {
                StartElement runContainerStart = e.asStartElement();
                this.addRunsToBuilder(this.builder, runMerger);
                this.parseRunContainer(this.builder, runContainerStart);
                continue;
            }
            if (XMLEventHelpers.isSimpleFieldStartEvent(e)) {
                this.addRunsToBuilder(this.builder, runMerger);
                StartElementContext simpleFieldElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
                for (XMLEvent fldEvent : XMLEventHelpers.gatherEvents(simpleFieldElementContext)) {
                    this.builder.addEvent(fldEvent);
                }
                this.builder.flushMarkup();
                continue;
            }
            if (this.processSkippableElements(e) || XMLEventHelpers.isWhitespace(e)) continue;
            this.addRunsToBuilder(this.builder, runMerger);
            if (e.isEndElement() && this.startElementContext.getStartElement().getName().equals(e.asEndElement().getName())) {
                this.builder.addMarkupComponent(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                this.log("End block: " + e);
                return this.builder.build();
            }
            this.builder.addEvent(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated paragraph");
    }

    private String getParagraphStyle(BlockProperty paragraphStyleProperty) {
        if (null == paragraphStyleProperty) {
            return null;
        }
        return XMLEventHelpers.getAttributeValue(paragraphStyleProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
    }

    private boolean processSkippableElements(XMLEvent event) throws XMLStreamException {
        if (ElementSkipper.GeneralElementSkipper.isInsertedRunContentStartElement(event)) {
            ElementSkipper.GeneralElementSkipper.skipElementEvents(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext, ElementSkipper.InlineSkippableElement.class));
            return true;
        }
        if (ElementSkipper.GeneralElementSkipper.isInsertedRunContentEndElement(event)) {
            return true;
        }
        if (ElementSkipper.GeneralElementSkipper.isDeletedRunContentStartElement(event) || ElementSkipper.GeneralElementSkipper.isProofingErrorStartElement(event)) {
            ElementSkipper.GeneralElementSkipper.skipElementEvents(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext));
            return true;
        }
        if (event.isStartElement() && this.bookmarkElementSkipper.canBeSkipped(event.asStartElement())) {
            this.bookmarkElementSkipper.skipElement(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext));
            return true;
        }
        return false;
    }

    private void processRun(BlockBuilder blockBuilder, RunMerger runMerger, StartElement startEl) throws XMLStreamException {
        StartElementContext runElementContext = StartElementContextFactory.createStartElementContext(startEl, this.startElementContext);
        RunBuilder runBuilder = new RunParser(runElementContext, this.nestedBlockIdGenerator, this.styleDefinitions).parse();
        if (this.runBuilderSkipper.canBeSkipped(runBuilder)) {
            return;
        }
        this.clarifyVisibility(runBuilder);
        this.clarifyRunExclusion(runBuilder, blockBuilder);
        blockBuilder.setRunName(startEl.getName());
        blockBuilder.setTextName(runBuilder.getTextName());
        runMerger.add(runBuilder);
    }

    private void clarifyVisibility(RunBuilder runBuilder) {
        if (this.startElementContext.getConditionalParameters().getTranslateWordHidden()) {
            return;
        }
        List<RunProperty> combinedRunProperties = this.styleDefinitions.getCombinedRunProperties(this.paragraphStyle, runBuilder.getRunStyle(), runBuilder.getRunProperties()).getProperties();
        for (RunProperty property : combinedRunProperties) {
            if (!XMLEventHelpers.WPML_PROPERTY_VANISH.getLocalPart().equals(property.getName().getLocalPart())) continue;
            if (property instanceof RunProperty.ToggleRunProperty && !((RunProperty.ToggleRunProperty)property).getToggleValue()) {
                return;
            }
            runBuilder.setHidden(true);
            return;
        }
    }

    private void clarifyRunExclusion(RunBuilder runBuilder, BlockBuilder blockBuilder) {
        if (blockBuilder.isHidden()) {
            return;
        }
        if (this.isExcluded(runBuilder.getRunStyle())) {
            runBuilder.setHidden(true);
        }
    }

    private boolean isParagraphExcluded(String paragraphStyle) {
        return this.isExcluded(paragraphStyle);
    }

    private boolean isExcluded(String style) {
        ConditionalParameters params = this.startElementContext.getConditionalParameters();
        if (null == style || null == params.tsExcludeWordStyles || params.tsExcludeWordStyles.isEmpty()) {
            return false;
        }
        return params.tsExcludeWordStyles.contains(style);
    }

    private void log(String s) {
        LOGGER.debug(s);
    }

    private class BlockBuilder
    implements ChunkContainer {
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private List<XMLEvent> currentMarkupComponentEvents = new ArrayList<XMLEvent>();
        private Markup markup = new Block.BlockMarkup();
        private boolean isHidden = false;
        private QName runName;
        private QName textName;

        BlockBuilder() {
        }

        boolean isHidden() {
            return this.isHidden;
        }

        void setIsHidden(boolean isHidden) {
            this.isHidden = isHidden;
        }

        void setRunName(QName runName) {
            if (this.runName == null) {
                this.runName = runName;
            }
        }

        void setTextName(QName textName) {
            if (this.textName == null) {
                this.textName = textName;
            }
        }

        private void flushMarkup() {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            if (!this.markup.getComponents().isEmpty()) {
                this.chunks.add(this.markup);
                this.markup = new Block.BlockMarkup();
            }
        }

        void addEvent(XMLEvent event) {
            this.currentMarkupComponentEvents.add(event);
        }

        @Override
        public void addChunk(Block.BlockChunk chunk) {
            this.flushMarkup();
            this.chunks.add(chunk);
        }

        void addMarkupComponent(MarkupComponent markupComponent) {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            this.markup.addComponent(markupComponent);
        }

        Block build() {
            this.flushMarkup();
            return new Block(this.chunks, this.runName, this.textName, this.isHidden);
        }
    }
}

