/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.BidirectionalityClarifier;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.OpenXMLContentSkeletonWriter;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.TextUnitWriter;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

class BlockTextUnitWriter
implements TextUnitWriter {
    private XMLEventFactory eventFactory;
    private QName runName;
    private QName textName;
    private Map<Integer, XMLEvents> codeMap;
    private XMLEventSerializer xmlWriter;
    private BidirectionalityClarifier bidirectionalityClarifier;
    private Deque<RunProperties> currentRunProperties = new ArrayDeque<RunProperties>();
    private StringBuilder textContent = new StringBuilder();
    private boolean runIsOpen = false;

    public BlockTextUnitWriter(XMLEventFactory eventFactory, QName runName, QName textName, Map<Integer, XMLEvents> codeMap, XMLEventSerializer xmlWriter, BidirectionalityClarifier bidirectionalityClarifier) {
        this.eventFactory = eventFactory;
        this.runName = runName;
        this.textName = textName;
        this.codeMap = codeMap;
        this.xmlWriter = xmlWriter;
        this.bidirectionalityClarifier = bidirectionalityClarifier;
    }

    @Override
    public void write(TextContainer tc) {
        for (Segment segment : tc.getSegments()) {
            this.writeSegment(segment);
        }
        this.flushText(true);
    }

    private void writeSegment(Segment segment) {
        TextFragment content = segment.getContent();
        String codedText = content.getCodedText();
        List<Code> codes = content.getCodes();
        for (int i = 0; i < codedText.length(); ++i) {
            char c = codedText.charAt(i);
            if (TextFragment.isMarker(c)) {
                int codeIndex = TextFragment.toIndex(codedText.charAt(++i));
                this.writeCode(codes.get(codeIndex));
                continue;
            }
            this.writeChar(c);
        }
    }

    private void writeChar(char c) {
        this.textContent.append(c);
    }

    private void writeCode(Code code) {
        int id = code.getId();
        XMLEvents codeEvents = this.codeMap.get(id);
        switch (code.getTagType()) {
            case OPENING: {
                this.flushText(true);
                if (codeEvents instanceof RunProperties) {
                    this.currentRunProperties.push((RunProperties)codeEvents);
                    break;
                }
                if (codeEvents instanceof RunContainer) {
                    RunContainer rc = (RunContainer)codeEvents;
                    this.xmlWriter.add(rc.getStartElement());
                    this.currentRunProperties.push(rc.getDefaultRunProperties());
                    break;
                }
                throw new IllegalStateException("Unexpected code contents:" + codeEvents);
            }
            case PLACEHOLDER: {
                boolean isRunMarkup = codeEvents instanceof Run.RunMarkup;
                if (isRunMarkup) {
                    this.flushRunStart();
                }
                this.flushText(!isRunMarkup);
                this.xmlWriter.add(codeEvents);
                break;
            }
            case CLOSING: {
                this.flushText(true);
                if (codeEvents instanceof RunProperties) {
                    this.currentRunProperties.pop();
                    break;
                }
                if (codeEvents instanceof RunContainer) {
                    this.xmlWriter.add(((RunContainer)codeEvents).getEndElement());
                    this.currentRunProperties.pop();
                    break;
                }
                throw new IllegalStateException("Unexpected code contents:" + codeEvents);
            }
        }
    }

    private void flushRunStart() {
        if (!this.runIsOpen) {
            this.writeRunStart(this.currentRunProperties.peek());
            this.runIsOpen = true;
        }
    }

    private void flushText(boolean terminateRun) {
        if (this.textContent.length() > 0) {
            this.flushRunStart();
            String text = this.textContent.toString();
            this.writeRunText(text);
            this.textContent = new StringBuilder();
        }
        if (terminateRun && this.runIsOpen) {
            this.writeRunEnd();
            this.runIsOpen = false;
        }
    }

    private void writeRunStart(RunProperties properties) {
        if (this.runName == null) {
            throw new IllegalStateException("no run name set");
        }
        this.xmlWriter.add(this.eventFactory.createStartElement(this.runName, null, null));
        properties = this.bidirectionalityClarifier.clarifyRunProperties(properties);
        if (properties != null) {
            this.xmlWriter.add(properties);
        }
    }

    private void writeRunText(String text) {
        if (this.textName == null) {
            throw new IllegalStateException("no text name set");
        }
        int start = 0;
        while (start < text.length()) {
            int i = text.indexOf(10, start);
            if (i == -1) {
                this.writeText(text.substring(start));
                break;
            }
            if (i > start) {
                this.writeText(text.substring(start, i));
            }
            this.writeLineBreak();
            start = i + 1;
        }
    }

    private void writeLineBreak() {
        QName br = XMLEventHelpers.createQName("br", this.textName);
        this.xmlWriter.add(this.eventFactory.createStartElement(br, null, null));
        this.xmlWriter.add(this.eventFactory.createEndElement(br, null));
    }

    private void writeText(String text) {
        boolean needsPreserveSpace = OpenXMLContentSkeletonWriter.needsXmlSpacePreserve(text);
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (needsPreserveSpace && !Namespaces.DrawingML.containsName(this.textName)) {
            attrs.add(this.eventFactory.createAttribute("xml", Namespaces.XML.getURI(), "space", "preserve"));
        }
        this.xmlWriter.add(this.eventFactory.createStartElement(this.textName, attrs.iterator(), null));
        this.xmlWriter.add(this.eventFactory.createCharacters(text));
        this.xmlWriter.add(this.eventFactory.createEndElement(this.textName, null));
    }

    private void writeRunEnd() {
        this.xmlWriter.add(this.eventFactory.createEndElement(this.runName, null));
    }
}

