/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.okapi.common.resource.ExtendedCodeType;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunPropertyFactory;

class CodeTypeFactory {
    private static final String EMPHASIS_MARK_PROPERTY_NAME = "em";
    private static final String UNDERLINE_PROPERTY_NAME = "u";
    private static final String HIGHLIGHT_COLOR_PROPERTY_NAME = "highlight";
    private static final String SHADE_COLOR_PROPERTY_NAME = "shd";
    private static final String COLOR_PROPERTY_NAME = "color";
    private static final String NONE_VALUE = "none";
    private static final boolean ADD_EXTENDED_CODE_TYPE_PREFIX = true;

    CodeTypeFactory() {
    }

    static String createCodeType(RunContainer runContainer) {
        CodeTypeBuilder codeTypeBuilder = new CodeTypeBuilder(true);
        if (RunContainer.Type.HYPERLINK == runContainer.getType()) {
            codeTypeBuilder.addType("link");
        } else {
            codeTypeBuilder.addType(runContainer.getType().getValue());
        }
        return codeTypeBuilder.build() + CodeTypeFactory.createCodeType(runContainer.getDefaultCombinedRunProperties(), false);
    }

    static String createCodeType(RunProperties runProperties) {
        return CodeTypeFactory.createCodeType(runProperties, true);
    }

    private static String createCodeType(RunProperties runProperties, boolean addExtendedCodeTypePrefix) {
        CodeTypeBuilder codeTypeBuilder = new CodeTypeBuilder(addExtendedCodeTypePrefix);
        for (RunProperty runProperty : runProperties.getProperties()) {
            if (runProperty instanceof RunProperty.ToggleRunProperty) {
                CodeTypeFactory.handleToggleRunProperty(codeTypeBuilder, (RunProperty.ToggleRunProperty)runProperty);
                continue;
            }
            CodeTypeFactory.handleRunProperty(codeTypeBuilder, runProperty);
        }
        return codeTypeBuilder.build();
    }

    private static void handleToggleRunProperty(CodeTypeBuilder codeTypeBuilder, RunProperty.ToggleRunProperty toggleRunProperty) {
        if (!toggleRunProperty.getToggleValue()) {
            return;
        }
        switch (RunPropertyFactory.TogglePropertyName.fromValue(toggleRunProperty.getName())) {
            case BOLD: 
            case COMPLEX_SCRIPT_BOLD: {
                codeTypeBuilder.addType("bold");
                break;
            }
            case ITALICS: 
            case COMPLEX_SCRIPT_ITALICS: {
                codeTypeBuilder.addType("italic");
                break;
            }
            case STRIKE_THROUGH: {
                codeTypeBuilder.addType(ExtendedCodeType.STRIKE_THROUGH.getValue());
                break;
            }
            case SHADOW: {
                codeTypeBuilder.addType(ExtendedCodeType.SHADOW.getValue());
            }
        }
    }

    private static void handleRunProperty(CodeTypeBuilder codeTypeBuilder, RunProperty runProperty) {
        if (null == runProperty.getValue() || NONE_VALUE.equals(runProperty.getValue())) {
            return;
        }
        if (EMPHASIS_MARK_PROPERTY_NAME.equals(runProperty.getName().getLocalPart())) {
            codeTypeBuilder.addType("italic");
            return;
        }
        if (UNDERLINE_PROPERTY_NAME.equals(runProperty.getName().getLocalPart())) {
            codeTypeBuilder.addType(ExtendedCodeType.UNDERLINE.getValue(), runProperty.getValue());
            return;
        }
        if (HIGHLIGHT_COLOR_PROPERTY_NAME.equals(runProperty.getName().getLocalPart())) {
            codeTypeBuilder.addType(ExtendedCodeType.HIGHLIGHT.getValue(), runProperty.getValue());
            return;
        }
        if (SHADE_COLOR_PROPERTY_NAME.equals(runProperty.getName().getLocalPart())) {
            codeTypeBuilder.addType(ExtendedCodeType.SHADE.getValue(), runProperty.getValue());
            return;
        }
        if (COLOR_PROPERTY_NAME.equals(runProperty.getName().getLocalPart())) {
            codeTypeBuilder.addType(ExtendedCodeType.COLOR.getValue(), runProperty.getValue());
            return;
        }
    }

    private static class CodeTypeBuilder {
        private static final String EMPTY_VALUE = "";
        private boolean addExtendedCodeTypePrefix;
        private Set<String> codeTypes = new HashSet<String>();
        private Map<String, String> codeTypesAndValues = new HashMap<String, String>();

        CodeTypeBuilder(boolean addExtendedCodeTypePrefix) {
            this.addExtendedCodeTypePrefix = addExtendedCodeTypePrefix;
        }

        void addType(String type) {
            this.codeTypes.add(type);
        }

        void addType(String type, String value) {
            this.codeTypesAndValues.put(type, value);
        }

        String build() {
            if (this.codeTypes.isEmpty() && this.codeTypesAndValues.isEmpty()) {
                return EMPTY_VALUE;
            }
            StringBuilder codeTypeBuilder = new StringBuilder(this.addExtendedCodeTypePrefix ? "x-" : EMPTY_VALUE);
            for (String string : this.codeTypes) {
                codeTypeBuilder.append(string).append(";");
            }
            for (Map.Entry entry : this.codeTypesAndValues.entrySet()) {
                codeTypeBuilder.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(";");
            }
            return codeTypeBuilder.toString();
        }
    }
}

