/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiUnexpectedRevisionException;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

abstract class ElementSkipperStrategy {
    protected Set<String> skippableElementValues;

    protected ElementSkipperStrategy(Set<String> skippableElementValues) {
        this.skippableElementValues = skippableElementValues;
    }

    abstract boolean isSkippableElement(StartElement var1);

    abstract void skipElement(StartElementContext var1) throws XMLStreamException;

    static class BookmarkElementSkipperStrategy
    extends GeneralElementSkipperStrategy {
        private String bookmarkName;
        private String bookmarkId;

        BookmarkElementSkipperStrategy(Set<String> skippableElementValues, String bookmarkName) {
            super(skippableElementValues);
            this.bookmarkName = bookmarkName;
        }

        @Override
        boolean isSkippableElement(StartElement startElement) {
            return ElementSkipper.BookmarkElementSkipper.isBookmarkStartElement(startElement) && this.bookmarkName.equals(XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_NAME)) || ElementSkipper.BookmarkElementSkipper.isBookmarkEndElement(startElement) && Objects.equals(this.bookmarkId, XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_ID));
        }

        @Override
        void skipElement(StartElementContext startElementContext) throws XMLStreamException {
            super.skipElement(startElementContext);
            if (ElementSkipper.BookmarkElementSkipper.isBookmarkStartElement(startElementContext.getStartElement())) {
                this.bookmarkId = XMLEventHelpers.getAttributeValue(startElementContext.getStartElement(), XMLEventHelpers.WPML_ID);
                return;
            }
            this.bookmarkId = null;
        }
    }

    static class GeneralElementSkipperStrategy
    extends ElementSkipperStrategy {
        private static final Set<String> REVISION_SKIPPABLE_ELEMENTS = new HashSet<String>();

        GeneralElementSkipperStrategy(Set<String> skippableElementValues) {
            super(skippableElementValues);
        }

        static void skipElementEvents(StartElementContext startElementContext) throws XMLStreamException {
            if (!startElementContext.getConditionalParameters().getAutomaticallyAcceptRevisions() && REVISION_SKIPPABLE_ELEMENTS.contains(startElementContext.getStartElement().getName().getLocalPart())) {
                throw new OkapiUnexpectedRevisionException();
            }
            if (ElementSkipper.InlineSkippableElement.class == startElementContext.getSkippableElementType() && ElementSkipper.RevisionInlineSkippableElement.RUN_INSERTED_CONTENT.getValue().equals(startElementContext.getStartElement().getName().getLocalPart())) {
                return;
            }
            while (startElementContext.getEventReader().hasNext()) {
                XMLEvent e = startElementContext.getEventReader().nextEvent();
                if (!XMLEventHelpers.isEndElement(e, startElementContext.getStartElement())) continue;
                return;
            }
            throw new IllegalStateException("Unexpected structure");
        }

        @Override
        boolean isSkippableElement(StartElement startElement) {
            return this.skippableElementValues.contains(startElement.getName().getLocalPart());
        }

        @Override
        void skipElement(StartElementContext startElementContext) throws XMLStreamException {
            GeneralElementSkipperStrategy.skipElementEvents(startElementContext);
        }

        static {
            REVISION_SKIPPABLE_ELEMENTS.addAll(ElementSkipper.RevisionInlineSkippableElement.getValues());
            REVISION_SKIPPABLE_ELEMENTS.addAll(ElementSkipper.RevisionPropertySkippableElement.getValues());
        }
    }
}

